/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.troubleshooting;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.tools.idea.diagnostics.report.DiagnosticsSummaryFileProvider;
import com.android.tools.idea.diagnostics.report.FileInfo;
import com.android.tools.idea.uibuilder.troubleshooting.DesignToolsTroubleInfoCollector;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.project.Project;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\r"}, d2={"Lcom/android/tools/idea/uibuilder/troubleshooting/DesignToolsDiagnosticsSummaryFileProvider;", "Lcom/android/tools/idea/diagnostics/report/DiagnosticsSummaryFileProvider;", "<init>", "()V", "name", "", "getName", "()Ljava/lang/String;", "getFiles", "", "Lcom/android/tools/idea/diagnostics/report/FileInfo;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.android.designer"})
@StabilityInferred(parameters=1)
public final class DesignToolsDiagnosticsSummaryFileProvider
implements DiagnosticsSummaryFileProvider {
    @NotNull
    private final String name;
    public static final int $stable;

    public DesignToolsDiagnosticsSummaryFileProvider() {
        this.name = "UI Tools";
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public List<FileInfo> getFiles(@Nullable Project project) {
        if (project == null) {
            return CollectionsKt.emptyList();
        }
        String string = PathManager.getLogPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getLogPath(...)");
        Path outputFile = DiagnosticsSummaryFileProvider.Companion.getDiagnosticsDirectoryPath(string).resolve("UITools.log");
        Files.writeString(outputFile, (CharSequence)new DesignToolsTroubleInfoCollector(null, 1, null).collectInfo(project), new OpenOption[0]);
        Intrinsics.checkNotNull((Object)outputFile);
        Path path = Paths.get("UITools.log", new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        return CollectionsKt.listOf((Object)new FileInfo(outputFile, path));
    }
}

