/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.surface.interaction;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.tools.idea.common.model.Coordinates;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.draw.ColorSet;
import com.android.tools.idea.common.scene.draw.DrawLassoUtil;
import com.android.tools.idea.common.surface.Interaction;
import com.android.tools.idea.common.surface.InteractionEvent;
import com.android.tools.idea.common.surface.InteractionInformation;
import com.android.tools.idea.common.surface.Layer;
import com.android.tools.idea.common.surface.MouseDraggedEvent;
import com.android.tools.idea.common.surface.SceneView;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0001\u0018B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\n\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0016J\u000e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/android/tools/idea/uibuilder/surface/interaction/MarqueeInteraction;", "Lcom/android/tools/idea/common/surface/Interaction;", "sceneView", "Lcom/android/tools/idea/common/surface/SceneView;", "repaint", "Lkotlin/Function0;", "", "<init>", "(Lcom/android/tools/idea/common/surface/SceneView;Lkotlin/jvm/functions/Function0;)V", "overlay", "Lcom/android/tools/idea/uibuilder/surface/interaction/MarqueeInteraction$MarqueeLayer;", "startInfo", "Lcom/android/tools/idea/common/surface/InteractionInformation;", "begin", "event", "Lcom/android/tools/idea/common/surface/InteractionEvent;", "update", "commit", "cancel", "getCursor", "Ljava/awt/Cursor;", "createOverlays", "", "Lcom/android/tools/idea/common/surface/Layer;", "MarqueeLayer", "intellij.android.designer"})
@StabilityInferred(parameters=0)
public final class MarqueeInteraction
implements Interaction {
    @NotNull
    private final SceneView sceneView;
    @NotNull
    private final Function0<Unit> repaint;
    @Nullable
    private MarqueeLayer overlay;
    @Nullable
    private InteractionInformation startInfo;
    public static final int $stable = 8;

    public MarqueeInteraction(@NotNull SceneView sceneView, @NotNull Function0<Unit> repaint) {
        Intrinsics.checkNotNullParameter((Object)sceneView, (String)"sceneView");
        Intrinsics.checkNotNullParameter(repaint, (String)"repaint");
        this.sceneView = sceneView;
        this.repaint = repaint;
    }

    @Override
    public void begin(@NotNull InteractionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        boolean bl = event instanceof MouseDraggedEvent;
        if (_Assertions.ENABLED && !bl) {
            boolean bl2 = false;
            String string = "The instance of event should be MouseDraggedEvent but it is " + event.getClass() + "; The SceneView is " + this.sceneView + ", start (x, y) = " + event.getInfo().getX() + ", " + event.getInfo().getY() + ", start mask is " + event.getInfo().getModifiersEx();
            throw new AssertionError((Object)string);
        }
        this.startInfo = event.getInfo();
    }

    @Override
    public void update(@NotNull InteractionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event instanceof MouseDraggedEvent) {
            MouseEvent mouseEvent = (MouseEvent)((MouseDraggedEvent)event).getEventObject();
            if (this.overlay == null || this.startInfo == null) {
                return;
            }
            int x = mouseEvent.getX();
            int y = mouseEvent.getY();
            InteractionInformation interactionInformation = this.startInfo;
            Intrinsics.checkNotNull((Object)interactionInformation);
            int startX = interactionInformation.getX();
            InteractionInformation interactionInformation2 = this.startInfo;
            Intrinsics.checkNotNull((Object)interactionInformation2);
            int startY = interactionInformation2.getY();
            int xp = RangesKt.coerceAtMost((int)x, (int)startX);
            int yp = RangesKt.coerceAtMost((int)y, (int)startY);
            int w = Math.abs(x - startX);
            int h = Math.abs(y - startY);
            int ax = Coordinates.getAndroidXDip(this.sceneView, xp);
            int ay = Coordinates.getAndroidYDip(this.sceneView, yp);
            int aw = Coordinates.getAndroidDimensionDip(this.sceneView, w);
            int ah = Coordinates.getAndroidDimensionDip(this.sceneView, h);
            MarqueeLayer marqueeLayer = this.overlay;
            Intrinsics.checkNotNull((Object)marqueeLayer);
            marqueeLayer.updateValues(xp, yp, w, h, x, y, aw, ah);
            List<SceneComponent> list = this.sceneView.getScene().findWithin(ax, ay, aw, ah);
            Intrinsics.checkNotNullExpressionValue(list, (String)"findWithin(...)");
            Collection within = list;
            List list2 = ContainerUtil.map((Collection)within, arg_0 -> MarqueeInteraction.update$lambda$1(MarqueeInteraction::update$lambda$0, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"map(...)");
            List result = list2;
            this.sceneView.getSelectionModel().setSelection(result);
            this.repaint.invoke();
        }
    }

    @Override
    public void commit(@NotNull InteractionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
    }

    @Override
    public void cancel(@NotNull InteractionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.sceneView.getSelectionModel().clear();
    }

    @Override
    @Nullable
    public Cursor getCursor() {
        return null;
    }

    @Override
    @NotNull
    public List<Layer> createOverlays() {
        ColorSet colorSet = this.sceneView.getColorSet();
        MarqueeLayer marqueeLayer = this.overlay = new MarqueeLayer(colorSet);
        Intrinsics.checkNotNull((Object)marqueeLayer);
        return CollectionsKt.listOf((Object)marqueeLayer);
    }

    private static final NlComponent update$lambda$0(SceneComponent it) {
        return it.getNlComponent();
    }

    private static final NlComponent update$lambda$1(Function1 $tmp0, Object p0) {
        return (NlComponent)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005JF\u0010\u0011\u001a\u00020\u00122\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\tJ\u0010\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/android/tools/idea/uibuilder/surface/interaction/MarqueeInteraction$MarqueeLayer;", "Lcom/android/tools/idea/common/surface/Layer;", "colorSet", "Lcom/android/tools/idea/common/scene/draw/ColorSet;", "<init>", "(Lcom/android/tools/idea/common/scene/draw/ColorSet;)V", "getColorSet", "()Lcom/android/tools/idea/common/scene/draw/ColorSet;", "x", "", "y", "w", "h", "mouseX", "mouseY", "androidWidth", "androidHeight", "updateValues", "", "paint", "gc", "Ljava/awt/Graphics2D;", "intellij.android.designer"})
    private static final class MarqueeLayer
    extends Layer {
        @NotNull
        private final ColorSet colorSet;
        private int x;
        private int y;
        private int w;
        private int h;
        private int mouseX;
        private int mouseY;
        private int androidWidth;
        private int androidHeight;

        public MarqueeLayer(@NotNull ColorSet colorSet) {
            Intrinsics.checkNotNullParameter((Object)colorSet, (String)"colorSet");
            this.colorSet = colorSet;
        }

        @NotNull
        public final ColorSet getColorSet() {
            return this.colorSet;
        }

        public final void updateValues(int x, int y, int w, int h, int mouseX, int mouseY, int androidWidth, int androidHeight) {
            this.x = x;
            this.y = y;
            this.w = w;
            this.h = h;
            this.mouseX = mouseX;
            this.mouseY = mouseY;
            this.androidWidth = androidWidth;
            this.androidHeight = androidHeight;
        }

        @Override
        public void paint(@NotNull Graphics2D gc) {
            Intrinsics.checkNotNullParameter((Object)gc, (String)"gc");
            DrawLassoUtil.drawLasso(gc, this.colorSet, this.x, this.y, this.w, this.h, this.mouseX, this.mouseY, this.androidWidth, this.androidHeight, true);
        }
    }
}

