/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.scene.decorator;

import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.scene.decorator.SceneFrameFactory;
import com.android.tools.idea.common.scene.draw.DisplayList;
import com.android.tools.idea.common.scene.draw.DrawNlComponentFrame;
import com.android.tools.idea.common.scene.draw.DrawNlDraggingComponentFrame;
import com.android.tools.idea.uibuilder.handlers.constraint.ConstraintUtilities;
import java.awt.Rectangle;
import org.jetbrains.annotations.NotNull;

public class NlSceneFrameFactory
implements SceneFrameFactory {
    @Override
    public void addFrame(@NotNull DisplayList list, @NotNull SceneComponent component, @NotNull SceneContext sceneContext) {
        boolean paint;
        Rectangle rect = new Rectangle();
        component.fillRect(rect);
        int layoutWidth = NlSceneFrameFactory.layoutDimToMode(component.getAuthoritativeNlComponent(), "layout_width");
        int layoutHeight = NlSceneFrameFactory.layoutDimToMode(component.getAuthoritativeNlComponent(), "layout_height");
        SceneComponent.DrawState mode = component.getDrawState();
        boolean bl = paint = !sceneContext.showOnlySelection() || mode == SceneComponent.DrawState.SELECTED || mode == SceneComponent.DrawState.DRAG;
        if (paint) {
            if (component.isDragging()) {
                DrawNlDraggingComponentFrame.add(list, sceneContext, rect, mode, layoutWidth, layoutHeight);
            } else {
                DrawNlComponentFrame.add(list, sceneContext, rect, mode, layoutWidth, layoutHeight);
            }
        }
    }

    private static int layoutDimToMode(@NotNull NlComponent component, @NotNull String attr2) {
        String value = component.getAttribute("http://schemas.android.com/apk/res/android", attr2);
        if ("wrap_content".equalsIgnoreCase(value)) {
            return -2;
        }
        if ("match_parent".equalsIgnoreCase(value)) {
            return -1;
        }
        return ConstraintUtilities.getDpValue(component, value);
    }
}

