/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.scene;

import com.android.tools.idea.uibuilder.scene.SessionClock;

public class RealTimeSessionClock
implements SessionClock {
    private static final long INVALID_TIME = -1L;
    private long myStartTimeNanos = System.nanoTime();
    private long myPauseTimeNanos = -1L;

    @Override
    public synchronized long getTimeNanos() {
        if (this.myPauseTimeNanos != -1L) {
            return this.myPauseTimeNanos - this.myStartTimeNanos;
        }
        return System.nanoTime() - this.myStartTimeNanos;
    }

    @Override
    public synchronized void pause() {
        if (this.myPauseTimeNanos == -1L) {
            this.myPauseTimeNanos = System.nanoTime();
        }
    }

    @Override
    public synchronized void resume() {
        if (this.myPauseTimeNanos == -1L) {
            return;
        }
        this.myStartTimeNanos += System.nanoTime() - this.myPauseTimeNanos;
        this.myPauseTimeNanos = -1L;
    }
}

