/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.scene;

import android.graphics.Rect;
import android.os.Bundle;
import android.view.View;
import android.view.accessibility.AccessibilityNodeInfo;
import com.android.ide.common.rendering.api.ViewInfo;
import com.android.tools.rendering.RenderAsyncActionExecutor;
import com.android.tools.rendering.RenderService;
import com.intellij.openapi.diagnostic.Logger;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000B\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\u001a.\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0002\u001a\f\u0010\u0014\u001a\u0004\u0018\u00010\u0015*\u00020\t\u001a\n\u0010\u0016\u001a\u00020\u0017*\u00020\t\"\u0016\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0004\"#\u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0018"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "accessibilityBasedHierarchyParser", "Lkotlin/Function1;", "", "", "Lcom/android/ide/common/rendering/api/ViewInfo;", "getAccessibilityBasedHierarchyParser", "()Lkotlin/jvm/functions/Function1;", "parseChildren", "rootView", "Landroid/view/View;", "nodeInfo", "Landroid/view/accessibility/AccessibilityNodeInfo;", "parentX", "", "parentY", "getAccessibilityText", "", "getAccessibilitySourceId", "", "intellij.android.designer"})
public final class AccessibilityViewInfoParserKt {
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final Function1<Object, List<ViewInfo>> accessibilityBasedHierarchyParser;

    @NotNull
    public static final Logger getLOG() {
        return LOG;
    }

    @NotNull
    public static final Function1<Object, List<ViewInfo>> getAccessibilityBasedHierarchyParser() {
        return accessibilityBasedHierarchyParser;
    }

    private static final List<ViewInfo> parseChildren(View rootView, AccessibilityNodeInfo nodeInfo, int parentX, int parentY) {
        int childCount = nodeInfo.getChildCount();
        List children = new ArrayList(childCount);
        for (int i = 0; i < childCount; ++i) {
            AccessibilityNodeInfo childNodeInfo = nodeInfo.getChild(i);
            Rect bounds2 = childNodeInfo.getBoundsInScreen();
            if (childNodeInfo.getAvailableExtraData().contains("android.view.accessibility.extra.DATA_TEXT_CHARACTER_LOCATION_KEY")) {
                Bundle extras = childNodeInfo.getExtras();
                extras.putInt("android.view.accessibility.extra.DATA_TEXT_CHARACTER_LOCATION_ARG_START_INDEX", 0);
                extras.putInt("android.view.accessibility.extra.DATA_TEXT_CHARACTER_LOCATION_ARG_LENGTH", childNodeInfo.getText().length());
                try {
                    childNodeInfo.refreshWithExtraData("android.view.accessibility.extra.DATA_TEXT_CHARACTER_LOCATION_KEY", extras);
                }
                catch (Exception ex) {
                    Logger.getInstance((String)"AccessibilityViewInfoParser.kt").warn((Throwable)ex);
                }
            }
            ViewInfo result = new ViewInfo(((Object)childNodeInfo.getClassName()).toString(), null, bounds2.left - parentX, bounds2.top - parentY, bounds2.right - parentX, bounds2.bottom - parentY, (Object)rootView, (Object)childNodeInfo, (Object)rootView.getLayoutParams());
            Intrinsics.checkNotNull((Object)childNodeInfo);
            result.setChildren(AccessibilityViewInfoParserKt.parseChildren(rootView, childNodeInfo, bounds2.left, bounds2.top));
            children.add(result);
        }
        return children;
    }

    @Nullable
    public static final String getAccessibilityText(@NotNull ViewInfo $this$getAccessibilityText) {
        Intrinsics.checkNotNullParameter((Object)$this$getAccessibilityText, (String)"<this>");
        Object object = $this$getAccessibilityText.getAccessibilityObject();
        Object object2 = object instanceof AccessibilityNodeInfo ? (AccessibilityNodeInfo)object : null;
        return object2 != null && (object2 = object2.getText()) != null ? object2.toString() : null;
    }

    public static final long getAccessibilitySourceId(@NotNull ViewInfo $this$getAccessibilitySourceId) {
        long l;
        Intrinsics.checkNotNullParameter((Object)$this$getAccessibilitySourceId, (String)"<this>");
        if ($this$getAccessibilitySourceId.getAccessibilityObject() != null) {
            Object object = $this$getAccessibilitySourceId.getAccessibilityObject();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.view.accessibility.AccessibilityNodeInfo");
            l = ((AccessibilityNodeInfo)object).getSourceNodeId();
        } else {
            Long l2;
            try {
                l2 = (Long)RenderService.getRenderAsyncActionExecutor().runAsyncActionWithTimeout(250L, TimeUnit.MILLISECONDS, RenderAsyncActionExecutor.RenderingTopic.NOT_SPECIFIED, () -> AccessibilityViewInfoParserKt.getAccessibilitySourceId$lambda$0($this$getAccessibilitySourceId)).get();
            }
            catch (TimeoutException e) {
                LOG.warn("Timeout while retrieving the sourceNodeId", (Throwable)e);
                l2 = -1L;
            }
            Long l3 = l2;
            Intrinsics.checkNotNull((Object)l3);
            l = ((Number)l3).longValue();
        }
        return l;
    }

    private static final List accessibilityBasedHierarchyParser$lambda$0(Object view) {
        List<ViewInfo> list;
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        if (!(view instanceof View)) {
            list = CollectionsKt.emptyList();
        } else {
            AccessibilityNodeInfo accessibilityNodeInfo = ((View)view).createAccessibilityNodeInfo();
            Intrinsics.checkNotNullExpressionValue((Object)accessibilityNodeInfo, (String)"createAccessibilityNodeInfo(...)");
            AccessibilityNodeInfo nodeInfo = accessibilityNodeInfo;
            nodeInfo.setQueryFromAppProcessEnabled((View)view, true);
            Rect bounds2 = nodeInfo.getBoundsInScreen();
            list = AccessibilityViewInfoParserKt.parseChildren((View)view, nodeInfo, bounds2.left, bounds2.top);
        }
        return list;
    }

    private static final Long getAccessibilitySourceId$lambda$0(ViewInfo $this_getAccessibilitySourceId) {
        Object object = $this_getAccessibilitySourceId.getViewObject();
        View view = object instanceof View ? (View)object : null;
        if (view == null || (view = view.createAccessibilityNodeInfo()) == null) {
            return -1L;
        }
        View node = view;
        return node.getSourceNodeId();
    }

    static {
        Logger logger = Logger.getInstance((String)"Accessibility");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        accessibilityBasedHierarchyParser = AccessibilityViewInfoParserKt::accessibilityBasedHierarchyParser$lambda$0;
    }
}

