/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.property.inspector;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.uibuilder.api.CustomPanel;
import com.android.tools.idea.uibuilder.api.PropertyComponentHandler;
import com.android.tools.idea.uibuilder.api.ViewHandler;
import com.android.tools.idea.uibuilder.handlers.ViewHandlerManager;
import com.android.tools.idea.uibuilder.property.NlPropertyItem;
import com.android.tools.idea.uibuilder.property.inspector.InspectorSection;
import com.android.tools.idea.uibuilder.property.inspector.SampleCustomPanel;
import com.android.tools.property.panel.api.EditorProvider;
import com.android.tools.property.panel.api.InspectorBuilder;
import com.android.tools.property.panel.api.InspectorLineModel;
import com.android.tools.property.panel.api.InspectorPanel;
import com.android.tools.property.panel.api.PropertiesTable;
import com.android.tools.property.panel.api.PropertyItem;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u001e\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00020\u0018H\u0016J.\u0010\u0019\u001a\u00020\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00100\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00020\u0018H\u0002J\u001c\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00100\u001c2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00020\u0018H\u0002J$\u0010 \u001a\u00020\u00132\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00020\u00182\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00100!H\u0002J\u0018\u0010\"\u001a\u0004\u0018\u00010#2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00020\u0018H\u0002J\u0018\u0010$\u001a\u0004\u0018\u00010\u001e2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00020\u0018H\u0002J\u0010\u0010%\u001a\u00020\u00102\u0006\u0010&\u001a\u00020#H\u0002J\u0018\u0010'\u001a\u00020\u00112\u0006\u0010&\u001a\u00020#2\u0006\u0010(\u001a\u00020\u0010H\u0002R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0013\u0010\u000b\u001a\u00070\f\u00a2\u0006\u0002\b\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/android/tools/idea/uibuilder/property/inspector/LayoutInspectorBuilder;", "Lcom/android/tools/property/panel/api/InspectorBuilder;", "Lcom/android/tools/idea/uibuilder/property/NlPropertyItem;", "project", "Lcom/intellij/openapi/project/Project;", "editorProvider", "Lcom/android/tools/property/panel/api/EditorProvider;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/android/tools/property/panel/api/EditorProvider;)V", "getEditorProvider", "()Lcom/android/tools/property/panel/api/EditorProvider;", "viewHandlerManager", "Lcom/android/tools/idea/uibuilder/handlers/ViewHandlerManager;", "Lorg/jetbrains/annotations/NotNull;", "cachedCustomPanels", "", "", "Lcom/android/tools/idea/uibuilder/api/CustomPanel;", "resetCache", "", "attachToInspector", "inspector", "Lcom/android/tools/property/panel/api/InspectorPanel;", "properties", "Lcom/android/tools/property/panel/api/PropertiesTable;", "isApplicable", "", "attributes", "", "custom", "Ljavax/swing/JPanel;", "getLayoutAttributes", "addAttributesFromViewHandler", "", "getParentComponent", "Lcom/android/tools/idea/common/model/NlComponent;", "setupCustomPanel", "getCustomPanelKey", "parent", "createCustomPanel", "customPanelKey", "intellij.android.designer"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nLayoutInspectorBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LayoutInspectorBuilder.kt\ncom/android/tools/idea/uibuilder/property/inspector/LayoutInspectorBuilder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,140:1\n1761#2,3:141\n1740#2,3:144\n*S KotlinDebug\n*F\n+ 1 LayoutInspectorBuilder.kt\ncom/android/tools/idea/uibuilder/property/inspector/LayoutInspectorBuilder\n*L\n88#1:141,3\n111#1:144,3\n*E\n"})
public final class LayoutInspectorBuilder
implements InspectorBuilder<NlPropertyItem> {
    @NotNull
    private final EditorProvider<NlPropertyItem> editorProvider;
    @NotNull
    private final ViewHandlerManager viewHandlerManager;
    @NotNull
    private final Map<String, CustomPanel> cachedCustomPanels;
    public static final int $stable = 8;

    public LayoutInspectorBuilder(@NotNull Project project, @NotNull EditorProvider<? super NlPropertyItem> editorProvider) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(editorProvider, (String)"editorProvider");
        this.editorProvider = editorProvider;
        ViewHandlerManager viewHandlerManager = ViewHandlerManager.get(project);
        Intrinsics.checkNotNullExpressionValue((Object)viewHandlerManager, (String)"get(...)");
        this.viewHandlerManager = viewHandlerManager;
        this.cachedCustomPanels = new LinkedHashMap();
    }

    @NotNull
    public final EditorProvider<NlPropertyItem> getEditorProvider() {
        return this.editorProvider;
    }

    public void resetCache() {
        this.cachedCustomPanels.clear();
    }

    public void attachToInspector(@NotNull InspectorPanel inspector, @NotNull PropertiesTable<NlPropertyItem> properties) {
        Intrinsics.checkNotNullParameter((Object)inspector, (String)"inspector");
        Intrinsics.checkNotNullParameter(properties, (String)"properties");
        List<String> attributes = this.getLayoutAttributes(properties);
        JPanel custom = this.setupCustomPanel(properties);
        if (!this.isApplicable(attributes, custom, properties)) {
            return;
        }
        InspectorLineModel titleModel = InspectorPanel.addExpandableTitle$default((InspectorPanel)inspector, (String)InspectorSection.LAYOUT.getTitle(), (boolean)false, null, (int)6, null);
        if (custom != null) {
            inspector.addComponent((JComponent)custom, titleModel);
        }
        for (String propertyName : attributes) {
            NlPropertyItem propertyToAdd;
            NlPropertyItem nlPropertyItem;
            String attrName;
            Intrinsics.checkNotNullExpressionValue((Object)StringUtil.trimStart((String)propertyName, (String)"tools:"), (String)"trimStart(...)");
            NlPropertyItem property = (NlPropertyItem)properties.getOrNull("http://schemas.android.com/apk/res/android", attrName);
            if (StringsKt.startsWith$default((String)propertyName, (String)"tools:", (boolean)false, (int)2, null)) {
                NlPropertyItem nlPropertyItem2 = property;
                nlPropertyItem = nlPropertyItem2 != null ? nlPropertyItem2.getDesignProperty() : null;
            } else {
                nlPropertyItem = property;
            }
            if ((propertyToAdd = nlPropertyItem) == null) continue;
            inspector.addEditor(EditorProvider.createEditor$default(this.editorProvider, (PropertyItem)propertyToAdd, null, (int)2, null), titleModel);
        }
    }

    private final boolean isApplicable(List<String> attributes, JPanel custom, PropertiesTable<NlPropertyItem> properties) {
        boolean bl;
        block5: {
            if (!InspectorSection.LAYOUT.getVisible()) {
                return false;
            }
            if (custom != null) {
                return true;
            }
            Iterable $this$any$iv = attributes;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!(properties.getOrNull("http://schemas.android.com/apk/res/android", it) != null)) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final List<String> getLayoutAttributes(PropertiesTable<NlPropertyItem> properties) {
        Object[] objectArray = new String[]{"layout_width", "layout_height"};
        List attributes = CollectionsKt.mutableListOf((Object[])objectArray);
        this.addAttributesFromViewHandler(properties, attributes);
        attributes.add("visibility");
        attributes.add("tools:visibility");
        return attributes;
    }

    private final void addAttributesFromViewHandler(PropertiesTable<NlPropertyItem> properties, List<String> attributes) {
        NlComponent nlComponent = this.getParentComponent(properties);
        if (nlComponent == null) {
            return;
        }
        NlComponent parent = nlComponent;
        ViewHandler viewHandler = this.viewHandlerManager.getHandler(parent, LayoutInspectorBuilder::addAttributesFromViewHandler$lambda$0);
        if (viewHandler == null) {
            return;
        }
        ViewHandler handler = viewHandler;
        List<String> list = handler.getLayoutInspectorProperties();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getLayoutInspectorProperties(...)");
        attributes.addAll((Collection<String>)list);
    }

    private final NlComponent getParentComponent(PropertiesTable<NlPropertyItem> properties) {
        boolean bl;
        NlComponent firstParent;
        block5: {
            NlPropertyItem nlPropertyItem = (NlPropertyItem)properties.getFirst();
            if (nlPropertyItem == null) {
                return null;
            }
            NlPropertyItem property = nlPropertyItem;
            NlComponent nlComponent = (NlComponent)CollectionsKt.firstOrNull(property.getComponents());
            if (nlComponent == null || (nlComponent = nlComponent.getParent()) == null) {
                return null;
            }
            firstParent = nlComponent;
            Iterable $this$all$iv = property.getComponents();
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    NlComponent it = (NlComponent)element$iv;
                    boolean bl2 = false;
                    NlComponent nlComponent2 = it.getParent();
                    if (Intrinsics.areEqual((Object)(nlComponent2 != null ? nlComponent2.getTagName() : null), (Object)firstParent.getTagName())) continue;
                    bl = false;
                    break block5;
                }
                bl = true;
            }
        }
        return bl ? firstParent : null;
    }

    private final JPanel setupCustomPanel(PropertiesTable<NlPropertyItem> properties) {
        CustomPanel panel;
        NlComponent nlComponent = this.getParentComponent(properties);
        if (nlComponent == null) {
            return null;
        }
        NlComponent parent = nlComponent;
        String customPanelKey = this.getCustomPanelKey(parent);
        CustomPanel customPanel = this.cachedCustomPanels.get(customPanelKey);
        if (customPanel == null) {
            customPanel = this.createCustomPanel(parent, customPanelKey);
        }
        if (Intrinsics.areEqual((Object)(panel = customPanel), (Object)SampleCustomPanel.INSTANCE)) {
            return null;
        }
        NlPropertyItem nlPropertyItem = (NlPropertyItem)properties.getFirst();
        if (nlPropertyItem == null) {
            return null;
        }
        NlPropertyItem property = nlPropertyItem;
        NlComponent nlComponent2 = (NlComponent)CollectionsKt.singleOrNull(property.getComponents());
        if (nlComponent2 == null) {
            return null;
        }
        NlComponent component = nlComponent2;
        panel.useComponent(component, property.getModel().getSurface());
        return panel.getPanel();
    }

    private final String getCustomPanelKey(NlComponent parent) {
        String string;
        String string2 = parent.getTagName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getTagName(...)");
        String tagName = string2;
        if (!Intrinsics.areEqual((Object)tagName, (Object)"merge")) {
            string = tagName;
        } else {
            string = parent.getAttribute("http://schemas.android.com/tools", "parentTag");
            if (string == null) {
                string = tagName;
            }
        }
        return string;
    }

    private final CustomPanel createCustomPanel(NlComponent parent, String customPanelKey) {
        ViewHandler handler = this.viewHandlerManager.getHandler(parent, LayoutInspectorBuilder::createCustomPanel$lambda$0);
        Object object = handler;
        if (object == null || (object = ((PropertyComponentHandler)object).getLayoutCustomPanel()) == null) {
            object = SampleCustomPanel.INSTANCE;
        }
        Object panel = object;
        this.cachedCustomPanels.put(customPanelKey, (CustomPanel)panel);
        return panel;
    }

    private static final void addAttributesFromViewHandler$lambda$0() {
    }

    private static final void createCustomPanel$lambda$0() {
    }
}

