/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.preference;

import com.android.tools.idea.common.api.InsertType;
import com.android.tools.idea.common.command.NlWriteCommandActionUtil;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.uibuilder.api.ViewHandler;
import com.android.tools.idea.uibuilder.api.XmlType;
import com.google.common.base.Strings;
import com.intellij.psi.xml.XmlTag;
import java.util.Arrays;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PreferenceHandler
extends ViewHandler {
    @Override
    @Language(value="XML")
    @NotNull
    public abstract String getXml(@NotNull String var1, @NotNull XmlType var2);

    @Override
    public boolean onCreate(@Nullable NlComponent parent, @NotNull NlComponent newChild, @NotNull InsertType type) {
        if (type.equals((Object)InsertType.CREATE)) {
            NlWriteCommandActionUtil.run(newChild, "Clearing Width and Height", () -> {
                newChild.removeAndroidAttribute("layout_width");
                newChild.removeAndroidAttribute("layout_height");
            });
        }
        return true;
    }

    @NotNull
    static String generateKey(@NotNull NlComponent component, @NotNull String tagName, @NotNull String keyPrefix) {
        XmlTag preferenceScreen = component.getModel().getFile().getRootTag();
        if (preferenceScreen == null) {
            return "";
        }
        XmlTag[] preferences = preferenceScreen.findSubTags(tagName);
        int i = 1;
        String key = keyPrefix + i++;
        while (PreferenceHandler.anyPreferenceKeyEquals(preferences, key)) {
            key = keyPrefix + i++;
        }
        return key;
    }

    private static boolean anyPreferenceKeyEquals(@NotNull XmlTag[] preferences, @NotNull String key) {
        return Arrays.stream(preferences).map(preference -> preference.getAttributeValue("key", "http://schemas.android.com/apk/res/android")).anyMatch(key::equals);
    }

    @Override
    @NotNull
    public String getTitle(@NotNull NlComponent component) {
        String title = component.getAttribute("http://schemas.android.com/apk/res-auto", "title");
        return title != null ? title : Strings.nullToEmpty((String)component.getAndroidAttribute("title"));
    }
}

