/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.coordinator;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.tools.idea.common.model.NlAttributesHolder;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.scene.Placeholder;
import com.android.tools.idea.common.scene.Region;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.SnappingInfo;
import com.android.tools.idea.uibuilder.handlers.relative.targets.RelativeUtilitiesKt;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import java.awt.Point;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0001\"B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010 \u001a\u00020!H\u0002R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\u00020\u0017X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006#"}, d2={"Lcom/android/tools/idea/uibuilder/handlers/coordinator/CoordinatorPlaceholder;", "Lcom/android/tools/idea/common/scene/Placeholder;", "host", "Lcom/android/tools/idea/common/scene/SceneComponent;", "anchor", "type", "Lcom/android/tools/idea/uibuilder/handlers/coordinator/CoordinatorPlaceholder$Type;", "<init>", "(Lcom/android/tools/idea/common/scene/SceneComponent;Lcom/android/tools/idea/common/scene/SceneComponent;Lcom/android/tools/idea/uibuilder/handlers/coordinator/CoordinatorPlaceholder$Type;)V", "associatedComponent", "getAssociatedComponent", "()Lcom/android/tools/idea/common/scene/SceneComponent;", "updateAttribute", "", "sceneComponent", "attributes", "Lcom/android/tools/idea/common/model/NlAttributesHolder;", "left", "", "top", "right", "bottom", "region", "Lcom/android/tools/idea/common/scene/Region;", "getRegion", "()Lcom/android/tools/idea/common/scene/Region;", "snap", "", "info", "Lcom/android/tools/idea/common/scene/SnappingInfo;", "retPoint", "Ljava/awt/Point;", "getAnchorGravity", "", "Type", "intellij.android.designer"})
@StabilityInferred(parameters=0)
public final class CoordinatorPlaceholder
extends Placeholder {
    @NotNull
    private final SceneComponent anchor;
    @NotNull
    private final Type type;
    private final int left;
    private final int top;
    private final int right;
    private final int bottom;
    @NotNull
    private final Region region;
    public static final int $stable = 8;

    public CoordinatorPlaceholder(@NotNull SceneComponent host, @NotNull SceneComponent anchor, @NotNull Type type) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        super(host);
        this.anchor = anchor;
        this.type = type;
        this.left = switch (WhenMappings.$EnumSwitchMapping$0[this.type.ordinal()]) {
            case 1, 2, 3 -> this.anchor.getDrawX();
            case 4, 5, 6 -> RelativeUtilitiesKt.getDrawCenterX(this.anchor) - 10;
            case 7, 8, 9 -> this.anchor.getDrawX() + this.anchor.getDrawWidth() - 20;
            default -> throw new NoWhenBranchMatchedException();
        };
        this.top = switch (WhenMappings.$EnumSwitchMapping$0[this.type.ordinal()]) {
            case 1, 4, 7 -> this.anchor.getDrawY();
            case 2, 5, 8 -> RelativeUtilitiesKt.getDrawCenterY(this.anchor) - 10;
            case 3, 6, 9 -> this.anchor.getDrawY() + this.anchor.getDrawHeight() - 20;
            default -> throw new NoWhenBranchMatchedException();
        };
        this.right = this.left + 20;
        this.bottom = this.top + 20;
        this.region = new Region(this.left, this.top, this.right, this.bottom, this.anchor.getDepth() + 1);
    }

    @Override
    @NotNull
    public SceneComponent getAssociatedComponent() {
        return this.anchor;
    }

    @Override
    public void updateAttribute(@NotNull SceneComponent sceneComponent, @NotNull NlAttributesHolder attributes) {
        Intrinsics.checkNotNullParameter((Object)sceneComponent, (String)"sceneComponent");
        Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
        attributes.setAttribute("http://schemas.android.com/apk/res-auto", "layout_anchorGravity", this.getAnchorGravity());
        NlComponent nlComponent = this.anchor.getNlComponent();
        Intrinsics.checkNotNullExpressionValue((Object)nlComponent, (String)"getNlComponent(...)");
        attributes.setAttribute("http://schemas.android.com/apk/res-auto", "layout_anchor", "@+id/" + NlComponentHelperKt.ensureLiveId(nlComponent));
    }

    @Override
    @NotNull
    public Region getRegion() {
        return this.region;
    }

    @Override
    public boolean snap(@NotNull SnappingInfo info, @NotNull Point retPoint) {
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        Intrinsics.checkNotNullParameter((Object)retPoint, (String)"retPoint");
        if (this.getRegion().contains(info.getCenterX(), info.getCenterY())) {
            retPoint.x = (this.getRegion().getLeft() + this.getRegion().getRight()) / 2 - (info.getRight() - info.getLeft()) / 2;
            retPoint.y = (this.getRegion().getTop() + this.getRegion().getBottom()) / 2 - (info.getBottom() - info.getTop()) / 2;
            return true;
        }
        return false;
    }

    private final String getAnchorGravity() {
        return switch (WhenMappings.$EnumSwitchMapping$0[this.type.ordinal()]) {
            case 2 -> "start|center";
            case 8 -> "end|center";
            case 4 -> "top|center";
            case 6 -> "bottom|center";
            case 1 -> "start|top";
            case 3 -> "start|bottom";
            case 5 -> "center";
            case 7 -> "end|top";
            case 9 -> "end|bottom";
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\f\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\f\u00a8\u0006\r"}, d2={"Lcom/android/tools/idea/uibuilder/handlers/coordinator/CoordinatorPlaceholder$Type;", "", "<init>", "(Ljava/lang/String;I)V", "LEFT_TOP", "LEFT", "LEFT_BOTTOM", "TOP", "CENTER", "BOTTOM", "RIGHT_TOP", "RIGHT", "RIGHT_BOTTOM", "intellij.android.designer"})
    public static final class Type
    extends Enum<Type> {
        public static final /* enum */ Type LEFT_TOP = new Type();
        public static final /* enum */ Type LEFT = new Type();
        public static final /* enum */ Type LEFT_BOTTOM = new Type();
        public static final /* enum */ Type TOP = new Type();
        public static final /* enum */ Type CENTER = new Type();
        public static final /* enum */ Type BOTTOM = new Type();
        public static final /* enum */ Type RIGHT_TOP = new Type();
        public static final /* enum */ Type RIGHT = new Type();
        public static final /* enum */ Type RIGHT_BOTTOM = new Type();
        private static final /* synthetic */ Type[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Type[] values() {
            return (Type[])$VALUES.clone();
        }

        public static Type valueOf(String value) {
            return Enum.valueOf(Type.class, value);
        }

        @NotNull
        public static EnumEntries<Type> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = typeArray = new Type[]{Type.LEFT_TOP, Type.LEFT, Type.LEFT_BOTTOM, Type.TOP, Type.CENTER, Type.BOTTOM, Type.RIGHT_TOP, Type.RIGHT, Type.RIGHT_BOTTOM};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Type.values().length];
            try {
                nArray[Type.LEFT_TOP.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Type.LEFT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Type.LEFT_BOTTOM.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Type.TOP.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Type.CENTER.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Type.BOTTOM.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Type.RIGHT_TOP.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Type.RIGHT.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Type.RIGHT_BOTTOM.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

