/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.constraint;

import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.resources.configuration.LayoutDirectionQualifier;
import com.android.resources.LayoutDirection;
import com.android.tools.configurations.Configuration;
import com.android.tools.idea.common.model.Coordinates;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.android.tools.idea.uibuilder.api.ViewEditor;
import com.android.tools.idea.uibuilder.handlers.constraint.ConstraintAttribute;
import com.android.tools.property.panel.api.HelpSupport;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.ide.DataManager;
import java.util.HashMap;
import java.util.function.Supplier;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConstraintUtilities {
    private static HashMap<String, Integer> alignmentMap_ltr = new HashMap();
    private static HashMap<String, Integer> alignmentMap_rtl = new HashMap();
    static String[] mode = new String[]{"0", "1", "2", "3", "center", "START", "END"};
    private static final String[][] CHARS_MAP = new String[][]{{"&quot;", "\""}, {"&apos;", "'"}, {"&lt;", "<"}, {"&gt;", ">"}, {"&amp;", "&"}};

    public static int getAlignment(String s, boolean rtl) {
        HashMap<String, Integer> alignmentMap;
        HashMap<String, Integer> hashMap = alignmentMap = rtl ? alignmentMap_rtl : alignmentMap_ltr;
        if (alignmentMap.containsKey(s)) {
            return alignmentMap.get(s);
        }
        return 5;
    }

    static int getMargin(@NotNull NlComponent component, @NotNull String attr2) {
        String margin = component.getLiveAttribute("http://schemas.android.com/apk/res/android", attr2);
        if (margin == null) {
            if (attr2 == "layout_marginStart") {
                margin = component.getLiveAttribute("http://schemas.android.com/apk/res/android", "layout_marginLeft");
            } else if (attr2 == "layout_marginEnd") {
                margin = component.getLiveAttribute("http://schemas.android.com/apk/res/android", "layout_marginRight");
            }
        }
        if (margin != null) {
            return ConstraintUtilities.getDpValue(component, margin);
        }
        return 0;
    }

    public static boolean isInRTL(@NotNull NlComponent component) {
        Configuration configuration = component.getModel().getConfiguration();
        if (configuration == null) {
            return false;
        }
        LayoutDirectionQualifier qualifier = configuration.getFullConfig().getLayoutDirectionQualifier();
        if (qualifier == null) {
            return false;
        }
        return qualifier.getValue() == LayoutDirection.RTL;
    }

    public static int getDpValue(@NotNull NlComponent component, String value) {
        if (value != null) {
            Configuration configuration = component.getModel().getConfiguration();
            Integer px = ViewEditor.resolveDimensionPixelSize(value, configuration);
            return px == null ? 0 : Coordinates.pxToDp(component.getModel(), (int)px);
        }
        return 0;
    }

    @NotNull
    static String resolveStringResource(@NotNull NlComponent component, @NotNull String text) {
        Configuration configuration = component.getModel().getConfiguration();
        return IdeResourcesUtil.resolveStringValue((RenderResources)configuration.getResourceItemResolver(), (String)text);
    }

    @NotNull
    public static String getResolvedText(@NotNull NlComponent component) {
        String text = ConstraintUtilities.getResolvedAttribute(component, "text");
        if (text == null) {
            return "";
        }
        return text;
    }

    @NotNull
    public static String getResolvedToggleText(@NotNull NlComponent component) {
        String checkedText = ConstraintUtilities.getResolvedAttribute(component, "checked");
        String toggleTextAttr = checkedText != null && checkedText.equals("true") ? "textOn" : "textOff";
        String text = ConstraintUtilities.getResolvedAttribute(component, toggleTextAttr);
        if (text == null) {
            return "";
        }
        return text;
    }

    @Nullable
    private static String getResolvedAttribute(@NotNull NlComponent component, @NotNull String attribute) {
        String resolvedAttribute = component.getAttribute("http://schemas.android.com/tools", attribute);
        if (resolvedAttribute == null) {
            resolvedAttribute = component.getAttribute("http://schemas.android.com/apk/res/android", attribute);
        }
        if (resolvedAttribute != null && resolvedAttribute.startsWith("@")) {
            resolvedAttribute = ConstraintUtilities.resolveStringResource(component, resolvedAttribute);
        }
        return ConstraintUtilities.replaceSpecialChars(resolvedAttribute);
    }

    @VisibleForTesting
    @Nullable
    static String replaceSpecialChars(@Nullable String text) {
        if (text == null || text.isEmpty()) {
            return text;
        }
        int offset = 0;
        int pos = 0;
        if (text.indexOf("&") >= 0) {
            boolean notDone = true;
            while (notDone) {
                char part;
                int end;
                int begin;
                notDone = false;
                for (int i = 0; i < CHARS_MAP.length; ++i) {
                    pos = text.indexOf(CHARS_MAP[i][0], offset);
                    if (pos < 0) continue;
                    notDone = true;
                    text = text.replace(CHARS_MAP[i][0], CHARS_MAP[i][1]);
                    offset = pos + CHARS_MAP[i][0].length();
                }
                if (offset < text.length() && text.substring(offset).matches(".*&#[0-9]+;.*")) {
                    begin = text.indexOf("&#");
                    end = text.indexOf(";", begin);
                    part = (char)Integer.parseInt(text.substring(begin + 2, end));
                    text = text.replace(text.substring(begin, end + 1), "" + part);
                    notDone = true;
                    offset = end;
                }
                if (offset >= text.length() || !text.substring(offset).matches(".*&#x[a-fA-F0-9]+;.*")) continue;
                begin = text.indexOf("&#x");
                end = text.indexOf(";", begin);
                part = (char)Integer.parseInt(text.substring(begin + 3, end), 16);
                text = text.replace(text.substring(begin, end + 1), "" + part);
                notDone = true;
                offset = end;
            }
        }
        return text;
    }

    static void registerAttributeHelp(@NotNull JComponent component, @NotNull Supplier<ConstraintAttribute> attributeSupplier) {
        DataManager.registerDataProvider((JComponent)component, dataId -> HelpSupport.Companion.getPROPERTY_ITEM().is(dataId) ? attributeSupplier.get() : null);
    }

    static {
        alignmentMap_rtl.put("center", 4);
        alignmentMap_rtl.put("textStart", 2);
        alignmentMap_rtl.put("textEnd", 3);
        alignmentMap_rtl.put("viewStart", 6);
        alignmentMap_rtl.put("viewEnd", 5);
        alignmentMap_ltr.put("center", 4);
        alignmentMap_ltr.put("textStart", 2);
        alignmentMap_ltr.put("textEnd", 3);
        alignmentMap_ltr.put("viewStart", 5);
        alignmentMap_ltr.put("viewEnd", 6);
    }
}

