/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.editor;

import com.android.sdklib.devices.Device;
import com.android.tools.adtui.actions.DropDownAction;
import com.android.tools.idea.actions.ColorBlindModeAction;
import com.android.tools.idea.actions.DeviceChangeListener;
import com.android.tools.idea.actions.DeviceMenuAction;
import com.android.tools.idea.actions.LocaleMenuAction;
import com.android.tools.idea.actions.OrientationMenuAction;
import com.android.tools.idea.actions.SetScreenViewProviderAction;
import com.android.tools.idea.actions.SystemUiModeAction;
import com.android.tools.idea.actions.TargetMenuAction;
import com.android.tools.idea.actions.ThemeMenuAction;
import com.android.tools.idea.common.actions.IssueNotificationAction;
import com.android.tools.idea.common.actions.NextDeviceAction;
import com.android.tools.idea.common.actions.RefreshRenderAction;
import com.android.tools.idea.common.actions.ToggleDeviceNightModeAction;
import com.android.tools.idea.common.actions.ToggleDeviceOrientationAction;
import com.android.tools.idea.common.editor.ToolbarActionGroups;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.ui.designer.overlays.OverlayConfiguration;
import com.android.tools.idea.ui.designer.overlays.OverlayMenuAction;
import com.android.tools.idea.uibuilder.actions.LayoutQualifierDropdownMenu;
import com.android.tools.idea.uibuilder.actions.SwitchToNextScreenViewProviderAction;
import com.android.tools.idea.uibuilder.surface.NlDesignSurface;
import com.android.tools.idea.uibuilder.surface.NlScreenViewProvider;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.vfs.VirtualFile;
import icons.StudioIcons;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class DefaultNlToolbarActionGroups
extends ToolbarActionGroups {
    public DefaultNlToolbarActionGroups(@NotNull NlDesignSurface surface2) {
        super(surface2);
    }

    @Override
    @NotNull
    protected ActionGroup getEastGroup() {
        DefaultActionGroup group = new DefaultActionGroup();
        group.add(ActionManager.getInstance().getAction("LayoutEditor.HelpAssistant"));
        return group;
    }

    @Override
    @NotNull
    protected ActionGroup getNorthGroup() {
        DefaultActionGroup group = new DefaultActionGroup();
        if (this.isInVisualizationTool()) {
            return group;
        }
        List<NlModel> models = this.mySurface.getModels();
        VirtualFile file2 = !models.isEmpty() ? models.get(0).getVirtualFile() : null;
        LayoutQualifierDropdownMenu dropdown = new LayoutQualifierDropdownMenu(file2);
        group.add((AnAction)dropdown);
        group.addSeparator();
        DropDownAction designModeAction = this.createDesignModeAction();
        this.appendShortcutText((AnAction)designModeAction, SwitchToNextScreenViewProviderAction.getInstance());
        group.add((AnAction)designModeAction);
        group.addSeparator();
        OrientationMenuAction orientationMenuAction = new OrientationMenuAction(true);
        this.appendShortcutText((AnAction)orientationMenuAction, ToggleDeviceOrientationAction.getInstance());
        group.add((AnAction)orientationMenuAction);
        if (OverlayConfiguration.EP_NAME.hasAnyExtensions()) {
            group.addSeparator();
            OverlayMenuAction overlayAction = new OverlayMenuAction(this.mySurface.getOverlayConfiguration(), () -> this.mySurface.repaint());
            group.add((AnAction)overlayAction);
        }
        group.addSeparator();
        SystemUiModeAction systemUiModeAction = new SystemUiModeAction();
        this.appendShortcutText((AnAction)systemUiModeAction, ToggleDeviceNightModeAction.getInstance());
        group.add((AnAction)systemUiModeAction);
        group.addSeparator();
        DeviceMenuAction menuAction = new DeviceMenuAction(new DeviceChangeListener(){

            @Override
            public void onDeviceChanged(@NotNull Device oldDevice, @NotNull Device newDevice) {
                DefaultNlToolbarActionGroups.this.mySurface.getZoomController().zoomToFit();
            }

            @Override
            public void onRevertToOriginal() {
                DefaultNlToolbarActionGroups.this.mySurface.getZoomController().zoomToFit();
            }
        });
        this.appendShortcutText((AnAction)menuAction, NextDeviceAction.getInstance());
        group.add((AnAction)menuAction);
        group.add((AnAction)new TargetMenuAction());
        group.add((AnAction)new ThemeMenuAction());
        group.addSeparator();
        group.add((AnAction)new LocaleMenuAction());
        group.addSeparator();
        return group;
    }

    private void appendShortcutText(@NotNull AnAction targetAction, @NotNull AnAction action2) {
        String shortcutsText = KeymapUtil.getPreferredShortcutText((Shortcut[])action2.getShortcutSet().getShortcuts());
        Presentation presentation = targetAction.getTemplatePresentation();
        if (!shortcutsText.isEmpty()) {
            presentation.setDescription(String.format("%s (%s)", presentation.getDescription(), shortcutsText));
        }
    }

    @NotNull
    private DropDownAction createDesignModeAction() {
        DropDownAction designSurfaceMenu = new DropDownAction("Select Design Surface", "Select Design Surface", StudioIcons.LayoutEditor.Toolbar.VIEW_MODE);
        designSurfaceMenu.addAction((AnAction)new SetScreenViewProviderAction(NlScreenViewProvider.RENDER));
        designSurfaceMenu.addAction((AnAction)new SetScreenViewProviderAction(NlScreenViewProvider.BLUEPRINT));
        designSurfaceMenu.addAction((AnAction)new SetScreenViewProviderAction(NlScreenViewProvider.RENDER_AND_BLUEPRINT));
        ColorBlindModeAction colorBlindMode = new ColorBlindModeAction();
        designSurfaceMenu.addAction((AnAction)colorBlindMode);
        designSurfaceMenu.addSeparator();
        designSurfaceMenu.addAction((AnAction)RefreshRenderAction.getInstance());
        return designSurfaceMenu;
    }

    @Override
    @NotNull
    protected ActionGroup getNorthEastGroup() {
        DefaultActionGroup group = new DefaultActionGroup();
        if (this.isInVisualizationTool()) {
            return group;
        }
        group.add((AnAction)IssueNotificationAction.getInstance());
        return group;
    }

    private boolean isInVisualizationTool() {
        return ((NlDesignSurface)this.mySurface).getScreenViewProvider() == NlScreenViewProvider.VISUALIZATION;
    }
}

