/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.editor;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.resources.ResourceUrl;
import com.android.tools.configurations.Configuration;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.rendering.AndroidBuildTargetReference;
import com.android.tools.idea.uibuilder.editor.EmptyModelUpdater;
import com.android.tools.idea.util.FileExtensions;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import java.io.Closeable;
import java.io.File;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.core.util.PhysicalFileSystemUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0000\b\u0007\u0018\u00002\u00020\u0001B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u001c\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u00122\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J>\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\u0003H\u0002J\b\u0010\u001e\u001a\u00020\u0003H\u0002J\u0010\u0010\u001f\u001a\u00020\u00132\u0006\u0010 \u001a\u00020\u0014H\u0002J\u0006\u0010!\u001a\u00020\u0017J\u000e\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u0013J\u0010\u0010%\u001a\u0004\u0018\u00010\u00132\u0006\u0010$\u001a\u00020\u0013J\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00130'R\u001a\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/android/tools/idea/uibuilder/editor/AnimatedSelectorModel;", "", "originalFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "buildTarget", "Lcom/android/tools/idea/rendering/AndroidBuildTargetReference;", "componentRegistrar", "Ljava/util/function/Consumer;", "Lcom/android/tools/idea/common/model/NlComponent;", "config", "Lcom/android/tools/configurations/Configuration;", "<init>", "(Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/openapi/Disposable;Lcom/intellij/openapi/project/Project;Lcom/android/tools/idea/rendering/AndroidBuildTargetReference;Ljava/util/function/Consumer;Lcom/android/tools/configurations/Configuration;)V", "animationTags", "", "", "Lcom/intellij/psi/xml/XmlTag;", "tempModelFile", "nlModelOfTempFile", "Lcom/android/tools/idea/common/model/NlModel;", "currentOption", "createIdAnimationMap", "xmlFile", "Lcom/intellij/psi/xml/XmlFile;", "createModelWithFile", "file", "createTempAnimatedSelectorFile", "getTransitionContent", "embeddedAnimationTag", "getNlModel", "setPreviewOption", "", "option", "getPreviewOptionTagName", "getPreviewOption", "", "intellij.android.designer"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nAnimatedSelectorToolbar.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AnimatedSelectorToolbar.kt\ncom/android/tools/idea/uibuilder/editor/AnimatedSelectorModel\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,358:1\n1310#2,2:359\n1#3:361\n*S KotlinDebug\n*F\n+ 1 AnimatedSelectorToolbar.kt\ncom/android/tools/idea/uibuilder/editor/AnimatedSelectorModel\n*L\n287#1:359,2\n*E\n"})
public final class AnimatedSelectorModel {
    @NotNull
    private Map<String, ? extends XmlTag> animationTags;
    @NotNull
    private final VirtualFile tempModelFile;
    @NotNull
    private final NlModel nlModelOfTempFile;
    @Nullable
    private String currentOption;
    public static final int $stable = 8;

    public AnimatedSelectorModel(final @NotNull VirtualFile originalFile, @NotNull Disposable parentDisposable, @NotNull Project project, @NotNull AndroidBuildTargetReference buildTarget, @NotNull Consumer<NlComponent> componentRegistrar, @NotNull Configuration config) {
        Intrinsics.checkNotNullParameter((Object)originalFile, (String)"originalFile");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)buildTarget, (String)"buildTarget");
        Intrinsics.checkNotNullParameter(componentRegistrar, (String)"componentRegistrar");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        PsiFile psiFile = PhysicalFileSystemUtilsKt.toPsiFile((VirtualFile)originalFile, (Project)project);
        Intrinsics.checkNotNull((Object)psiFile, (String)"null cannot be cast to non-null type com.intellij.psi.xml.XmlFile");
        final XmlFile xmlFile = (XmlFile)psiFile;
        this.tempModelFile = this.createTempAnimatedSelectorFile();
        this.nlModelOfTempFile = this.createModelWithFile(parentDisposable, project, buildTarget, componentRegistrar, config, this.tempModelFile);
        this.animationTags = this.createIdAnimationMap(xmlFile);
        VirtualFileManager.getInstance().addVirtualFileListener(new VirtualFileListener(){

            public void contentsChanged(VirtualFileEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (Intrinsics.areEqual((Object)event.getFile(), (Object)originalFile)) {
                    animationTags = this.createIdAnimationMap(xmlFile);
                    String string = currentOption;
                    if (string == null) {
                        string = "Select Transition...";
                    }
                    this.setPreviewOption(string);
                }
            }
        });
        this.setPreviewOption("Select Transition...");
    }

    private final Map<String, XmlTag> createIdAnimationMap(XmlFile xmlFile) {
        XmlTag xmlTag = xmlFile.getRootTag();
        Intrinsics.checkNotNull((Object)xmlTag);
        XmlTag rootTag = xmlTag;
        XmlTag[] xmlTagArray = rootTag.getSubTags();
        Intrinsics.checkNotNullExpressionValue((Object)xmlTagArray, (String)"getSubTags(...)");
        List transitions = SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)ArraysKt.asSequence((Object[])xmlTagArray), AnimatedSelectorModel::createIdAnimationMap$lambda$0));
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"Select Transition...", (Object)rootTag)};
        Map maps = MapsKt.mutableMapOf((Pair[])pairArray);
        for (XmlTag transition : transitions) {
            XmlTag animationTag;
            Object object;
            Object toId;
            Object fromId;
            block2: {
                Object object2 = transition.getAttribute("fromId", "http://schemas.android.com/apk/res/android");
                if (object2 == null || (object2 = object2.getValue()) == null) continue;
                Object fromIdAttribute = object2;
                Object object3 = transition.getAttribute("toId", "http://schemas.android.com/apk/res/android");
                if (object3 == null || (object3 = object3.getValue()) == null) continue;
                Object toIdAttribute = object3;
                Object object4 = ResourceUrl.parse((String)fromIdAttribute);
                if (object4 == null || (object4 = object4.name) == null) continue;
                fromId = object4;
                Object object5 = ResourceUrl.parse((String)toIdAttribute);
                if (object5 == null || (object5 = object5.name) == null) continue;
                toId = object5;
                XmlTag[] xmlTagArray2 = transition.getSubTags();
                Intrinsics.checkNotNullExpressionValue((Object)xmlTagArray2, (String)"getSubTags(...)");
                Object[] $this$firstOrNull$iv = xmlTagArray2;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    XmlTag it = (XmlTag)element$iv;
                    boolean bl = false;
                    if (!(Intrinsics.areEqual((Object)it.getName(), (Object)"animated-vector") || Intrinsics.areEqual((Object)it.getName(), (Object)"animation-list"))) continue;
                    object = element$iv;
                    break block2;
                }
                object = null;
            }
            if ((XmlTag)object == null) continue;
            String transitionId = (String)fromId + " to " + (String)toId;
            maps.put(transitionId, animationTag);
        }
        return maps;
    }

    private final NlModel createModelWithFile(Disposable parentDisposable, Project project, AndroidBuildTargetReference buildTarget, Consumer<NlComponent> componentRegistrar, Configuration config, VirtualFile file2) {
        NlModel nlModel;
        PsiFile psiFile = PhysicalFileSystemUtilsKt.toPsiFile((VirtualFile)file2, (Project)project);
        Intrinsics.checkNotNull((Object)psiFile, (String)"null cannot be cast to non-null type com.intellij.psi.xml.XmlFile");
        XmlFile psiXmlFile = (XmlFile)psiFile;
        psiXmlFile.putUserData(ModuleUtilCore.KEY_MODULE, (Object)buildTarget.getModule());
        NlModel $this$createModelWithFile_u24lambda_u241 = nlModel = new NlModel.Builder(parentDisposable, buildTarget, file2, config).withComponentRegistrar(componentRegistrar).withXmlProvider((arg_0, arg_1) -> AnimatedSelectorModel.createModelWithFile$lambda$0(psiXmlFile, arg_0, arg_1)).build();
        boolean bl = false;
        $this$createModelWithFile_u24lambda_u241.setModelUpdater(EmptyModelUpdater.INSTANCE);
        return nlModel;
    }

    private final VirtualFile createTempAnimatedSelectorFile() {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String fileName = "drawable_" + StringsKt.replace$default((String)string, (String)"-", (String)"_", (boolean)false, (int)4, null);
        VirtualFile virtualFile = PhysicalFileSystemUtilsKt.toVirtualFile((File)new File(FileUtilRt.getTempDirectory()));
        Intrinsics.checkNotNull((Object)virtualFile);
        VirtualFile systemTempDir = virtualFile;
        VirtualFile virtualFile2 = systemTempDir.findChild("drawable-temp");
        if (virtualFile2 == null) {
            VirtualFile virtualFile3 = systemTempDir.createChildDirectory((Object)this, "drawable-temp");
            virtualFile2 = virtualFile3;
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile3, (String)"createChildDirectory(...)");
        }
        VirtualFile tempDrawableDir = virtualFile2;
        File file2 = FileUtilRt.createTempFile((File)FileExtensions.toIoFile((VirtualFile)tempDrawableDir), (String)fileName, (String)".xml", (boolean)true, (boolean)true);
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"createTempFile(...)");
        File physicalChildInTempDrawableFile = file2;
        VirtualFile virtualFile4 = FileExtensions.toVirtualFile((File)physicalChildInTempDrawableFile, (boolean)true);
        Intrinsics.checkNotNull((Object)virtualFile4);
        return virtualFile4;
    }

    private final String getTransitionContent(XmlTag embeddedAnimationTag) {
        String originalText = embeddedAnimationTag.getText();
        String string = embeddedAnimationTag.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String tag = string;
        Intrinsics.checkNotNull((Object)originalText);
        return StringsKt.substringBefore$default((String)originalText, (String)tag, null, (int)2, null) + tag + " xmlns:android=\"http://schemas.android.com/apk/res/android\" " + StringsKt.substringAfter$default((String)originalText, (String)tag, null, (int)2, null);
    }

    @NotNull
    public final NlModel getNlModel() {
        return this.nlModelOfTempFile;
    }

    public final void setPreviewOption(@NotNull String option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        if (Intrinsics.areEqual((Object)this.currentOption, (Object)option)) {
            return;
        }
        this.currentOption = option;
        XmlTag xmlTag = this.animationTags.get(option);
        if (xmlTag == null) {
            return;
        }
        XmlTag tag = xmlTag;
        WriteCommandAction.runWriteCommandAction((Project)this.nlModelOfTempFile.getProject(), () -> AnimatedSelectorModel.setPreviewOption$lambda$0(this, tag));
    }

    @Nullable
    public final String getPreviewOptionTagName(@NotNull String option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        XmlTag xmlTag = this.animationTags.get(option);
        return xmlTag != null ? xmlTag.getName() : null;
    }

    @NotNull
    public final Set<String> getPreviewOption() {
        return this.animationTags.keySet();
    }

    private static final boolean createIdAnimationMap$lambda$0(XmlTag it) {
        return Intrinsics.areEqual((Object)it.getName(), (Object)"transition");
    }

    private static final XmlFile createModelWithFile$lambda$0(XmlFile $psiXmlFile, Project project, VirtualFile virtualFile) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"<unused var>");
        return $psiXmlFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void setPreviewOption$lambda$0(AnimatedSelectorModel this$0, XmlTag $tag) {
        OutputStream outputStream = this$0.tempModelFile.getOutputStream((Object)this$0);
        Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"getOutputStream(...)");
        Closeable closeable = outputStream;
        Object object = Charsets.UTF_8;
        closeable = new OutputStreamWriter((OutputStream)closeable, (Charset)object);
        object = null;
        try {
            OutputStreamWriter it = (OutputStreamWriter)closeable;
            boolean bl = false;
            it.write(this$0.getTransitionContent($tag));
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
        }
    }
}

