/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.api;

import android.view.View;
import android.view.ViewGroup;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.uibuilder.api.ScrollHandler;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.android.tools.rendering.RenderService;
import com.intellij.openapi.util.Computable;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.function.IntConsumer;
import java.util.function.IntSupplier;
import org.jetbrains.annotations.NotNull;

public final class ScrollViewScrollHandler
implements ScrollHandler {
    private final int myMaxScrollableSize;
    private final int myScrollUnitSize;
    private final int myStartScrollPosition;
    @NotNull
    private final IntConsumer myScrollSetter;
    @NotNull
    private final IntSupplier myScrollGetter;
    @NotNull
    private final Computable<CompletableFuture<Void>> myScrollHandler;
    private CompletableFuture<Void> myScrollingTask;

    ScrollViewScrollHandler(int maxScrollableSize, int scrollUnitSize, @NotNull IntConsumer scrollSetter, @NotNull IntSupplier scrollGetter, @NotNull Computable<CompletableFuture<Void>> scrollHandler) {
        this.myMaxScrollableSize = maxScrollableSize;
        this.myScrollUnitSize = scrollUnitSize;
        this.myScrollSetter = scrollSetter;
        this.myScrollGetter = scrollGetter;
        this.myStartScrollPosition = scrollGetter.getAsInt();
        this.myScrollHandler = scrollHandler;
    }

    @NotNull
    public static ScrollViewScrollHandler createHandler(@NotNull ViewGroup viewGroup, NlComponent component, int maxScrollableSize, int scrollUnitSize, @NotNull Orientation orientation) {
        return new ScrollViewScrollHandler(maxScrollableSize, scrollUnitSize, orientation == Orientation.VERTICAL ? i -> {
            viewGroup.setScrollY(i);
            NlComponentHelperKt.setScrollY(component, i);
        } : i -> {
            viewGroup.setScrollX(i);
            NlComponentHelperKt.setScrollX(component, i);
        }, orientation == Orientation.VERTICAL ? () -> ((ViewGroup)viewGroup).getScrollY() : () -> ((ViewGroup)viewGroup).getScrollX(), (Computable<CompletableFuture<Void>>)((Computable)() -> ScrollViewScrollHandler.handleScrolling((View)viewGroup)));
    }

    private static CompletableFuture<Void> handleScrolling(@NotNull View view) {
        return RenderService.getRenderAsyncActionExecutor().runAsyncAction(() -> {
            int scrollPosX = view.getScrollX();
            int scrollPosY = view.getScrollY();
            if (scrollPosX != 0 || scrollPosY != 0) {
                if (view.isNestedScrollingEnabled()) {
                    int[] consumed = new int[2];
                    int axis = scrollPosX != 0 ? 1 : 0;
                    if (view.startNestedScroll(axis |= scrollPosY != 0 ? 2 : 0)) {
                        view.dispatchNestedPreScroll(scrollPosX, scrollPosY, consumed, null);
                        view.dispatchNestedScroll(consumed[0], consumed[1], scrollPosX, scrollPosY, null);
                        view.stopNestedScroll();
                        scrollPosX -= consumed[0];
                        scrollPosY -= consumed[1];
                    }
                }
                if (scrollPosX != 0 || scrollPosY != 0) {
                    view.scrollTo(scrollPosX, scrollPosY);
                }
                view.requestLayout();
            }
            if (!(view instanceof ViewGroup)) {
                return;
            }
            ViewGroup group = (ViewGroup)view;
            for (int i = 0; i < group.getChildCount(); ++i) {
                View child = group.getChildAt(i);
                ScrollViewScrollHandler.handleScrolling(child);
            }
        });
    }

    @Override
    public int update(int scrollAmount) {
        int currentScrollPosition = this.myScrollGetter.getAsInt();
        int newScrollPos = Math.min(this.myMaxScrollableSize, Math.max(0, this.myStartScrollPosition + scrollAmount * this.myScrollUnitSize));
        if (newScrollPos == currentScrollPosition) {
            return 0;
        }
        if (this.myScrollingTask != null && !this.myScrollingTask.isDone()) {
            this.myScrollingTask.cancel(true);
        }
        this.myScrollSetter.accept(newScrollPos);
        this.myScrollingTask = (CompletableFuture)this.myScrollHandler.compute();
        return newScrollPos - currentScrollPosition;
    }

    @Override
    public void commit(int scrollAmount) {
        this.update(scrollAmount);
    }

    @Override
    public boolean canScroll(int scrollAmount) {
        if (this.myScrollGetter.getAsInt() == 0 && scrollAmount < 0) {
            return false;
        }
        return this.myScrollGetter.getAsInt() != this.myMaxScrollableSize || scrollAmount <= 0;
    }

    public static int getMaxScrollable(@NotNull ViewGroup viewGroup, @NotNull Function<ViewGroup, Integer> measureGroup, @NotNull Function<View, Integer> measureChildren) {
        int maxScrollable = 0;
        for (int i = 0; i < viewGroup.getChildCount(); ++i) {
            maxScrollable += measureChildren.apply(viewGroup.getChildAt(i)).intValue();
        }
        if ((maxScrollable -= measureGroup.apply(viewGroup).intValue()) < 0) {
            maxScrollable = 0;
        }
        return maxScrollable;
    }

    public static enum Orientation {
        VERTICAL,
        HORIZONTAL;

    }
}

