/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.actions;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.resources.configuration.ScreenOrientationQualifier;
import com.android.ide.common.resources.configuration.SmallestScreenWidthQualifier;
import com.android.resources.ResourceFolderType;
import com.android.resources.ScreenOrientation;
import com.android.tools.adtui.actions.DropDownAction;
import com.android.tools.configurations.Configuration;
import com.android.tools.idea.actions.DesignerDataKeys;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.configurations.ConfigurationFileUtil;
import com.android.tools.idea.configurations.ConfigurationManager;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.android.tools.idea.res.ResourceFilesUtil;
import com.android.tools.idea.ui.designer.EditorDesignSurface;
import com.android.tools.idea.uibuilder.actions.CreateVariationAction;
import com.android.tools.idea.uibuilder.actions.LayoutQualifierDropdownMenuKt;
import com.android.tools.idea.uibuilder.actions.SwitchToVariationAction;
import com.android.tools.idea.uibuilder.surface.NlDesignSurface;
import com.android.tools.idea.uibuilder.surface.NlScreenViewProvider;
import com.android.tools.idea.uibuilder.surface.ScreenViewProvider;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B\t\b\u0012\u00a2\u0006\u0004\b\u0004\u0010\u0006J\b\u0010\t\u001a\u00020\nH\u0014J\b\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/android/tools/idea/uibuilder/actions/LayoutQualifierDropdownMenu;", "Lcom/android/tools/adtui/actions/DropDownAction;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "<init>", "(Lcom/intellij/openapi/vfs/VirtualFile;)V", "()V", "displayText", "", "isPerformableWithoutActionButton", "", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "updateActions", "context", "Lcom/intellij/openapi/actionSystem/DataContext;", "createVariationsActions", "configuration", "Lcom/android/tools/configurations/Configuration;", "surface", "Lcom/android/tools/idea/ui/designer/EditorDesignSurface;", "intellij.android.designer"})
@StabilityInferred(parameters=0)
public final class LayoutQualifierDropdownMenu
extends DropDownAction {
    @NotNull
    private final String displayText;
    public static final int $stable = 8;

    public LayoutQualifierDropdownMenu(@Nullable VirtualFile file2) {
        super(LayoutQualifierDropdownMenuKt.access$generateLayoutAndQualifierTitle(file2), "Action to switch and create qualifiers for layout files", null);
        this.displayText = LayoutQualifierDropdownMenuKt.access$generateLayoutAndQualifierTitle(file2);
    }

    private LayoutQualifierDropdownMenu() {
        this(null);
    }

    protected boolean isPerformableWithoutActionButton() {
        return true;
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        NlDesignSurface nlDesignSurface = (NlDesignSurface)e.getDataContext().getData(DesignerDataKeys.DESIGN_SURFACE);
        ScreenViewProvider screenViewProvider = nlDesignSurface != null ? nlDesignSurface.getScreenViewProvider() : null;
        e.getPresentation().setEnabled(screenViewProvider == NlScreenViewProvider.RENDER || screenViewProvider == NlScreenViewProvider.BLUEPRINT || screenViewProvider == NlScreenViewProvider.Companion.getDEFAULT_SCREEN_MODE());
        e.getPresentation().setText(this.displayText, false);
        e.getPresentation().putClientProperty(ActionUtil.SHOW_TEXT_IN_TOOLBAR, (Object)true);
    }

    public boolean updateActions(@NotNull DataContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.removeAll();
        DesignSurface designSurface2 = (DesignSurface)context.getData(DesignerDataKeys.DESIGN_SURFACE);
        if (designSurface2 == null) {
            return true;
        }
        DesignSurface surface2 = designSurface2;
        Configuration configuration = (Configuration)CollectionsKt.firstOrNull(surface2.getConfigurations());
        if (configuration == null) {
            return true;
        }
        Configuration config = configuration;
        this.createVariationsActions(config, surface2);
        return true;
    }

    private final void createVariationsActions(Configuration configuration, EditorDesignSurface surface2) {
        VirtualFile virtualFile = ConfigurationFileUtil.getVirtualFile((Configuration)configuration);
        if (virtualFile != null) {
            Project project = ConfigurationManager.getFromConfiguration((Configuration)configuration).getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            Project project2 = project;
            List variations = IdeResourcesUtil.getResourceVariations((VirtualFile)virtualFile, (boolean)true);
            for (Object e : variations) {
                Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
                VirtualFile file2 = (VirtualFile)e;
                String title = LayoutQualifierDropdownMenuKt.access$generateLayoutAndQualifierTitle(file2);
                this.add(new SwitchToVariationAction(title, project2, file2, Intrinsics.areEqual((Object)virtualFile, (Object)file2)));
            }
            this.addSeparator();
            ResourceFolderType folderType = ResourceFilesUtil.getFolderType((VirtualFile)ConfigurationFileUtil.getVirtualFile((Configuration)configuration));
            if (folderType == ResourceFolderType.LAYOUT) {
                boolean haveLandscape = false;
                boolean haveTablet = false;
                for (Object e : variations) {
                    SmallestScreenWidthQualifier size;
                    FolderConfiguration config;
                    String name;
                    Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
                    VirtualFile file3 = (VirtualFile)e;
                    Intrinsics.checkNotNullExpressionValue((Object)file3.getParent().getName(), (String)"getName(...)");
                    if (!StringsKt.startsWith$default((String)name, (String)"layout", (boolean)false, (int)2, null) || (config = FolderConfiguration.getConfigForFolder((String)name)) == null) continue;
                    ScreenOrientationQualifier orientation = config.getScreenOrientationQualifier();
                    if (orientation != null && orientation.getValue() == ScreenOrientation.LANDSCAPE) {
                        haveLandscape = true;
                        if (haveTablet) break;
                    }
                    if ((size = config.getSmallestScreenWidthQualifier()) == null || size.getValue() < 600) continue;
                    haveTablet = true;
                    if (!haveLandscape) continue;
                }
                if (!haveLandscape) {
                    this.add(new CreateVariationAction(surface2, "Create Landscape Qualifier", "layout-land"));
                }
                if (!haveTablet) {
                    this.add(new CreateVariationAction(surface2, "Create Tablet Qualifier", "layout-sw600dp"));
                }
                this.add(new CreateVariationAction(surface2, "Add Resource Qualifier", null));
            } else {
                this.add(new CreateVariationAction(surface2, "Create Alternative...", null));
            }
        }
    }
}

