/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.actions;

import com.intellij.ide.BrowserUtil;
import com.intellij.ide.actions.ExternalJavaDocAction;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.function.Supplier;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ComponentHelpAction
extends AnAction {
    public static final String ANDROID_CAST_ITEM = "android.support.item";
    public static final String ANDROIDX_CAST_ITEM = "androidx.item";
    private static final String ANDROID_REFERENCE_PREFIX = "https://developer.android.com/reference/";
    private static final String GOOGLE_REFERENCE_PREFIX = "https://developers.google.com/android/reference/";
    private final Supplier<String> myTagNameSupplier;

    public ComponentHelpAction(@NotNull Supplier<String> tagNameSupplier) {
        super("Android Documentation");
        this.myTagNameSupplier = tagNameSupplier;
        this.setShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(112, 64)));
    }

    public void actionPerformed(@NotNull AnActionEvent event) {
        Project project = event.getProject();
        if (project == null) {
            return;
        }
        String tagName = this.myTagNameSupplier.get();
        if (tagName == null) {
            return;
        }
        String className = this.findClassName(project, tagName);
        if (className == null) {
            return;
        }
        String reference = ComponentHelpAction.computeReferenceFromClassName(className);
        if (reference != null) {
            BrowserUtil.browse((String)reference);
            return;
        }
        PsiClass psiClass = this.findClassByClassName(project, className);
        if (psiClass == null) {
            return;
        }
        ExternalJavaDocAction.showExternalJavadoc((PsiElement)psiClass, null, null, (DataContext)event.getDataContext());
    }

    @Nullable
    private String findClassName(@NotNull Project project, @NotNull String tagName) {
        switch (tagName) {
            case "item": 
            case "android.support.item": 
            case "androidx.item": {
                return "android.view.MenuItem";
            }
            case "group": 
            case "menu": {
                return "android.view.Menu";
            }
        }
        if (tagName.indexOf(46) != -1) {
            return tagName;
        }
        if (this.findClassByClassName(project, "android.widget." + tagName) != null) {
            return "android.widget." + tagName;
        }
        if (this.findClassByClassName(project, "android.view." + tagName) != null) {
            return "android.view." + tagName;
        }
        if (this.findClassByClassName(project, "android.webkit." + tagName) != null) {
            return "android.webkit." + tagName;
        }
        return null;
    }

    @Nullable
    private PsiClass findClassByClassName(@NotNull Project project, @NotNull String fullyQualifiedClassName) {
        JavaPsiFacade javaFacade = JavaPsiFacade.getInstance((Project)project);
        return javaFacade.findClass(fullyQualifiedClassName, GlobalSearchScope.allScope((Project)project));
    }

    @Nullable
    private static String computeReferenceFromClassName(@NotNull String className) {
        if (className.startsWith("android.") || className.startsWith("android.support.") || className.startsWith("androidx.")) {
            return ANDROID_REFERENCE_PREFIX + className.replace('.', '/') + ".html";
        }
        if (className.startsWith("com.google.android.")) {
            return GOOGLE_REFERENCE_PREFIX + className.replace('.', '/');
        }
        return null;
    }
}

