/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.actions;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.uibuilder.api.ViewEditor;
import com.android.tools.idea.uibuilder.api.ViewHandler;
import com.android.tools.idea.uibuilder.api.actions.DirectViewAction;
import com.android.tools.idea.uibuilder.api.actions.ViewActionPresentation;
import com.android.tools.idea.uibuilder.handlers.constraint.ComponentModification;
import com.android.tools.idea.uibuilder.handlers.constraint.targets.ChainChecker;
import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@VisibleForTesting
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0001-B+\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0005\u00a2\u0006\u0004\b\t\u0010\nJ6\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00160\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J(\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020\u0005H\u0002J \u0010 \u001a\u0004\u0018\u00010\u001d2\u0006\u0010!\u001a\u00020\u001d2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u001d0#H\u0002J \u0010$\u001a\u0004\u0018\u00010\u001d2\u0006\u0010!\u001a\u00020\u001d2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u001d0#H\u0002J,\u0010%\u001a\b\u0012\u0004\u0012\u00020\u001d0#2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010&\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00160#H\u0002J>\u0010'\u001a\u00020\u00102\u0006\u0010(\u001a\u00020)2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00160\u00182\u0006\u0010*\u001a\u00020\u001aH\u0016J\u001e\u0010+\u001a\u00020,2\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00160#H\u0007R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006."}, d2={"Lcom/android/tools/idea/uibuilder/actions/ChainStyleViewAction;", "Lcom/android/tools/idea/uibuilder/api/actions/DirectViewAction;", "icon", "Ljavax/swing/Icon;", "style", "", "chainDirection", "Lcom/android/tools/idea/uibuilder/actions/ChainStyleViewAction$ChainDirection;", "label", "<init>", "(Ljavax/swing/Icon;Ljava/lang/String;Lcom/android/tools/idea/uibuilder/actions/ChainStyleViewAction$ChainDirection;Ljava/lang/String;)V", "getStyle", "()Ljava/lang/String;", "getChainDirection", "()Lcom/android/tools/idea/uibuilder/actions/ChainStyleViewAction$ChainDirection;", "perform", "", "editor", "Lcom/android/tools/idea/uibuilder/api/ViewEditor;", "handler", "Lcom/android/tools/idea/uibuilder/api/ViewHandler;", "component", "Lcom/android/tools/idea/common/model/NlComponent;", "selectedChildren", "", "modifiers", "", "chooseChainStyle", "chainHeadComponent", "Lcom/android/tools/idea/common/scene/SceneComponent;", "orientationStyle", "chainStyle", "getHorizontalHead", "primary", "nonPrimaryComponents", "", "getVerticalHead", "getNonPrimaryComponent", "primaryNlComponent", "updatePresentation", "presentation", "Lcom/android/tools/idea/uibuilder/api/actions/ViewActionPresentation;", "modifiersEx", "isApplicable", "", "ChainDirection", "intellij.android.designer"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nChainStyleViewActions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChainStyleViewActions.kt\ncom/android/tools/idea/uibuilder/actions/ChainStyleViewAction\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,247:1\n1869#2,2:248\n1869#2,2:250\n774#2:252\n865#2,2:253\n1563#2:255\n1634#2,3:256\n*S KotlinDebug\n*F\n+ 1 ChainStyleViewActions.kt\ncom/android/tools/idea/uibuilder/actions/ChainStyleViewAction\n*L\n160#1:248,2\n185#1:250,2\n201#1:252\n201#1:253,2\n202#1:255\n202#1:256,3\n*E\n"})
public final class ChainStyleViewAction
extends DirectViewAction {
    @NotNull
    private final String style;
    @NotNull
    private final ChainDirection chainDirection;
    public static final int $stable = 8;

    public ChainStyleViewAction(@Nullable Icon icon2, @NotNull String style, @NotNull ChainDirection chainDirection, @NotNull String label) {
        Intrinsics.checkNotNullParameter((Object)style, (String)"style");
        Intrinsics.checkNotNullParameter((Object)((Object)chainDirection), (String)"chainDirection");
        Intrinsics.checkNotNullParameter((Object)label, (String)"label");
        super(icon2, label);
        this.style = style;
        this.chainDirection = chainDirection;
    }

    public /* synthetic */ ChainStyleViewAction(Icon icon2, String string, ChainDirection chainDirection, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            string2 = string;
        }
        this(icon2, string, chainDirection, string2);
    }

    @NotNull
    public final String getStyle() {
        return this.style;
    }

    @NotNull
    public final ChainDirection getChainDirection() {
        return this.chainDirection;
    }

    @Override
    public void perform(@NotNull ViewEditor editor, @NotNull ViewHandler handler, @NotNull NlComponent component, @NotNull List<NlComponent> selectedChildren, int modifiers) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        Intrinsics.checkNotNullParameter(selectedChildren, (String)"selectedChildren");
        if (selectedChildren.isEmpty()) {
            return;
        }
        NlComponent primaryNlComponent = selectedChildren.get(0);
        SceneComponent sceneComponent = editor.getScene().getSceneComponent(primaryNlComponent);
        if (sceneComponent == null) {
            return;
        }
        SceneComponent primary = sceneComponent;
        List<SceneComponent> nonPrimaryComponents = this.getNonPrimaryComponent(editor, primaryNlComponent, selectedChildren);
        if (this.chainDirection == ChainDirection.HORIZONTAL) {
            SceneComponent sceneComponent2 = this.getHorizontalHead(primary, nonPrimaryComponents);
            if (sceneComponent2 == null) {
                return;
            }
            SceneComponent horizontalHead = sceneComponent2;
            this.chooseChainStyle(horizontalHead, "layout_constraintHorizontal_chainStyle", primary, this.style);
        } else if (this.chainDirection == ChainDirection.VERTICAL) {
            SceneComponent sceneComponent3 = this.getVerticalHead(primary, nonPrimaryComponents);
            if (sceneComponent3 == null) {
                return;
            }
            SceneComponent verticalHead = sceneComponent3;
            this.chooseChainStyle(verticalHead, "layout_constraintVertical_chainStyle", primary, this.style);
        }
    }

    private final void chooseChainStyle(SceneComponent chainHeadComponent, String orientationStyle, SceneComponent component, String chainStyle) {
        NlComponent nlComponent = chainHeadComponent.getAuthoritativeNlComponent();
        Intrinsics.checkNotNullExpressionValue((Object)nlComponent, (String)"getAuthoritativeNlComponent(...)");
        NlComponent chainHead = nlComponent;
        ComponentModification modification = new ComponentModification(chainHead, "Cycle Chain Style");
        modification.setAttribute("http://schemas.android.com/apk/res-auto", orientationStyle, chainStyle);
        modification.commit();
        component.getScene().needsRebuildList();
    }

    private final SceneComponent getHorizontalHead(SceneComponent primary, List<? extends SceneComponent> nonPrimaryComponents) {
        ChainChecker checker = new ChainChecker();
        if (!checker.checkIsInChain(primary) || !checker.isInHorizontalChain()) {
            return null;
        }
        SceneComponent head = checker.getHorizontalChainHead();
        Iterable $this$forEach$iv = nonPrimaryComponents;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SceneComponent it = (SceneComponent)element$iv;
            boolean bl = false;
            ChainChecker componentChecker = new ChainChecker();
            componentChecker.checkIsInChain(it);
            if (componentChecker.isInHorizontalChain() && componentChecker.getHorizontalChainHead() == head) continue;
            return null;
        }
        return head;
    }

    private final SceneComponent getVerticalHead(SceneComponent primary, List<? extends SceneComponent> nonPrimaryComponents) {
        ChainChecker checker = new ChainChecker();
        if (!checker.checkIsInChain(primary) || !checker.isInVerticalChain()) {
            return null;
        }
        SceneComponent head = checker.getVerticalChainHead();
        Iterable $this$forEach$iv = nonPrimaryComponents;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SceneComponent it = (SceneComponent)element$iv;
            boolean bl = false;
            ChainChecker componentChecker = new ChainChecker();
            componentChecker.checkIsInChain(it);
            if (componentChecker.isInVerticalChain() && componentChecker.getVerticalChainHead() == head) continue;
            return null;
        }
        return head;
    }

    /*
     * WARNING - void declaration
     */
    private final List<SceneComponent> getNonPrimaryComponent(ViewEditor editor, NlComponent primaryNlComponent, List<? extends NlComponent> selectedChildren) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        NlComponent it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Iterable iterable = selectedChildren;
        boolean $i$f$filter = false;
        void var6_6 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (NlComponent)element$iv$iv;
            boolean bl = false;
            if (!(it != primaryNlComponent)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (NlComponent)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(editor.getScene().getSceneComponent(it));
        }
        return CollectionsKt.filterNotNull((Iterable)CollectionsKt.toList((Iterable)((List)destination$iv$iv)));
    }

    @Override
    public void updatePresentation(@NotNull ViewActionPresentation presentation, @NotNull ViewEditor editor, @NotNull ViewHandler handler, @NotNull NlComponent component, @NotNull List<NlComponent> selectedChildren, int modifiersEx) {
        Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        Intrinsics.checkNotNullParameter(selectedChildren, (String)"selectedChildren");
        super.updatePresentation(presentation, editor, handler, component, selectedChildren, modifiersEx);
        presentation.setVisible(this.isApplicable(editor, selectedChildren));
    }

    @VisibleForTesting
    public final boolean isApplicable(@NotNull ViewEditor editor, @NotNull List<? extends NlComponent> selectedChildren) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter(selectedChildren, (String)"selectedChildren");
        if (selectedChildren.isEmpty()) {
            return false;
        }
        NlComponent primaryNlComponent = selectedChildren.get(0);
        SceneComponent sceneComponent = editor.getScene().getSceneComponent(primaryNlComponent);
        if (sceneComponent == null) {
            return false;
        }
        SceneComponent primary = sceneComponent;
        List<SceneComponent> nonPrimaryComponents = this.getNonPrimaryComponent(editor, primaryNlComponent, selectedChildren);
        if (this.chainDirection == ChainDirection.HORIZONTAL) {
            return this.getHorizontalHead(primary, nonPrimaryComponents) != null;
        }
        if (this.chainDirection == ChainDirection.VERTICAL) {
            return this.getVerticalHead(primary, nonPrimaryComponents) != null;
        }
        return false;
    }

    @VisibleForTesting
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0087\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/android/tools/idea/uibuilder/actions/ChainStyleViewAction$ChainDirection;", "", "<init>", "(Ljava/lang/String;I)V", "HORIZONTAL", "VERTICAL", "intellij.android.designer"})
    public static final class ChainDirection
    extends Enum<ChainDirection> {
        public static final /* enum */ ChainDirection HORIZONTAL = new ChainDirection();
        public static final /* enum */ ChainDirection VERTICAL = new ChainDirection();
        private static final /* synthetic */ ChainDirection[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static ChainDirection[] values() {
            return (ChainDirection[])$VALUES.clone();
        }

        public static ChainDirection valueOf(String value) {
            return Enum.valueOf(ChainDirection.class, value);
        }

        @NotNull
        public static EnumEntries<ChainDirection> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = chainDirectionArray = new ChainDirection[]{ChainDirection.HORIZONTAL, ChainDirection.VERTICAL};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

