/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.android.AndroidXConstants;
import com.android.ide.common.rendering.api.AttributeFormat;
import com.android.ide.common.repository.GoogleMavenArtifactId;
import com.android.ide.common.resources.ResourceResolver;
import com.android.sdklib.IAndroidTarget;
import com.android.tools.dom.attrs.AttributeDefinition;
import com.android.tools.dom.attrs.AttributeDefinitions;
import com.android.tools.idea.model.StudioAndroidModuleInfo;
import com.android.tools.idea.psi.TagToClassMapper;
import com.android.tools.idea.rendering.AddMissingAttributesFix;
import com.android.tools.idea.rendering.DataBindingErrorUtils;
import com.android.tools.idea.rendering.HtmlBuilderHelper;
import com.android.tools.idea.rendering.ProblemSeverities;
import com.android.tools.idea.rendering.RenderErrorContributor;
import com.android.tools.idea.rendering.SetAttributeFix;
import com.android.tools.idea.rendering.ShowExceptionFix;
import com.android.tools.idea.rendering.errors.ComposeRenderErrorContributor;
import com.android.tools.idea.rendering.errors.RenderErrorContributorUtilKt;
import com.android.tools.idea.rendering.errors.WearTileRenderErrorContributor;
import com.android.tools.idea.rendering.errors.ui.RenderErrorModel;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.idea.ui.designer.EditorDesignSurface;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.module.AndroidModuleInfo;
import com.android.tools.rendering.HtmlLinkManager;
import com.android.tools.rendering.ProblemSeverity;
import com.android.tools.rendering.RenderContext;
import com.android.tools.rendering.RenderLogger;
import com.android.tools.rendering.RenderProblem;
import com.android.tools.rendering.RenderResult;
import com.android.tools.rendering.security.RenderSecurityException;
import com.android.tools.rendering.security.RenderSecurityManager;
import com.android.tools.sdk.AndroidPlatform;
import com.android.tools.sdk.AndroidSdkData;
import com.android.tools.sdk.AndroidTargetData;
import com.android.utils.HtmlBuilder;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.icons.AllIcons;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.problems.WolfTheProblemSolver;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.android.dom.manifest.Application;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.refactoring.MigrateToAndroidxUtil;
import org.jetbrains.android.util.LinkHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RenderErrorContributorImpl
implements RenderErrorContributor {
    private static final String RENDER_SESSION_IMPL_FQCN = "com.android.layoutlib.bridge.impl.RenderSessionImpl";
    protected static final Logger LOG = Logger.getInstance(RenderErrorContributorImpl.class);
    private static final String APP_COMPAT_REQUIRED_MSG = "You need to use a Theme.AppCompat";
    private final Set<RenderErrorModel.Issue> myIssues = new LinkedHashSet<RenderErrorModel.Issue>();
    private final HtmlLinkManager myLinkManager;
    private final LinkHandler myLinkHandler;
    @NotNull
    private final Module myModule;
    @NotNull
    protected final PsiFile mySourceFile;
    @NotNull
    private final RenderLogger myLogger;
    @Nullable
    private final RenderContext myRenderContext;
    private final boolean myHasRequestedCustomViews;

    protected RenderErrorContributorImpl(@Nullable EditorDesignSurface surface2, @NotNull RenderResult result) {
        this.myModule = result.getModule();
        this.mySourceFile = result.getSourceFile();
        this.myLogger = result.getLogger();
        this.myRenderContext = result.getRenderContext();
        this.myHasRequestedCustomViews = result.hasRequestedCustomViews();
        this.myLinkManager = result.getLogger().getLinkManager();
        this.myLinkHandler = new LinkHandler(result.getLogger().getLinkManager(), surface2, result.getModule(), result.getSourceFile());
    }

    public Collection<RenderErrorModel.Issue> reportIssues() {
        RenderLogger logger = this.myLogger;
        RenderContext renderContext = this.myRenderContext;
        this.reportMissingStyles(logger);
        this.reportAppCompatRequired(logger);
        if (renderContext != null) {
            this.reportRelevantCompilationErrors(logger);
            this.reportMissingSizeAttributes(logger, renderContext, this.mySourceFile instanceof XmlFile ? (XmlFile)this.mySourceFile : null);
            this.reportMissingClasses(logger);
        }
        this.reportBrokenClasses(logger);
        this.reportOtherProblems(logger);
        this.reportUnknownFragments(logger);
        this.reportRenderingFidelityProblems(logger);
        if (!this.myModule.isDisposed()) {
            this.myIssues.addAll(ComposeRenderErrorContributor.reportComposeErrors(logger, this.myLinkManager, (HyperlinkListener)this.myLinkHandler));
        }
        this.myIssues.addAll(WearTileRenderErrorContributor.reportWearTileErrors(logger, this.myLinkManager, (HyperlinkListener)this.myLinkHandler, this.mySourceFile));
        return this.getIssues();
    }

    protected Collection<RenderErrorModel.Issue> getIssues() {
        return Collections.unmodifiableCollection(this.myIssues);
    }

    private void reportMissingStyles(@NotNull RenderLogger logger) {
        if (logger.seenTagPrefix("project.building")) {
            this.addIssue().setSummary("Project Still Building: May cause rendering errors until the build is done").build();
        } else if (logger.seenTagPrefix("resources.resolve.theme")) {
            this.addIssue().setSummary("Missing styles").addMessageTip(AllIcons.General.Information, new HtmlBuilder().addBold("Missing styles. Is the correct theme chosen for this layout?").newline().add("Use the Theme combo box above the layout to choose a different layout, or fix the theme style references.")).build();
        }
    }

    private void reportAppCompatRequired(@NotNull RenderLogger logger) {
        Map brokenClasses = logger.getBrokenClasses();
        if (brokenClasses.isEmpty()) {
            return;
        }
        brokenClasses.values().stream().filter(Objects::nonNull).filter(t -> t.getMessage() != null && t.getMessage().startsWith(APP_COMPAT_REQUIRED_MSG)).findAny().ifPresent(t -> this.addIssue().setSeverity(HighlightSeverity.ERROR, 101).setSummary("Using the design library requires using Theme.AppCompat or a descendant").setHtmlContent(new HtmlBuilder().add("Select ").addItalic("Theme.AppCompat").add(" or a descendant in the theme selector.")).build());
    }

    private void reportRelevantCompilationErrors(@NotNull RenderLogger logger) {
        boolean hasJavaErrors;
        if (this.myModule.isDisposed()) {
            return;
        }
        Project project = this.myModule.getProject();
        WolfTheProblemSolver wolfgang = WolfTheProblemSolver.getInstance((Project)project);
        boolean hasProblemsInModule = (Boolean)ApplicationManager.getApplication().runReadAction(() -> wolfgang.hasProblemFilesBeneath(this.myModule));
        if (!hasProblemsInModule) {
            return;
        }
        HtmlBuilder builder = new HtmlBuilder();
        String summary = null;
        if (logger.seenTagPrefix("resources.")) {
            boolean haveResourceErrors = RenderErrorContributorImpl.checkErrorsByFileType(wolfgang, (FileType)XmlFileType.INSTANCE);
            if (haveResourceErrors) {
                summary = "Resource errors";
                builder.addBold("This project contains resource errors, so aapt did not succeed, which can cause rendering failures. Fix resource problems first.").newline().newline();
            }
        } else if (this.myHasRequestedCustomViews && (hasJavaErrors = RenderErrorContributorImpl.checkErrorsByFileType(wolfgang, (FileType)JavaFileType.INSTANCE))) {
            summary = "Compilation errors";
            builder.addBold("This project contains Java compilation errors, which can cause rendering failures for custom views. Fix compilation problems first.").newline().newline();
        }
        if (summary == null) {
            return;
        }
        this.addIssue().setSeverity(HighlightSeverity.ERROR).setSummary(summary).setHtmlContent(builder).build();
    }

    private void reportMissingSizeAttributes(@NotNull RenderLogger logger, @NotNull RenderContext renderTaskContext, @Nullable XmlFile psiFile) {
        if (!logger.isMissingSize()) {
            return;
        }
        HtmlBuilder builder = new HtmlBuilder();
        builder.addBold("NOTE: One or more layouts are missing the layout_width or layout_height attributes. These are required in most layouts.").newline();
        ResourceResolver resourceResolver = renderTaskContext.getConfiguration().getResourceResolver();
        if (psiFile == null) {
            LOG.error("PsiFile is missing in RenderTask used in RenderErrorPanel!");
            return;
        }
        AndroidModuleInfo moduleInfo = StudioAndroidModuleInfo.getInstance((Module)this.myModule);
        String fill = moduleInfo == null || moduleInfo.getBuildSdkVersion() == null || moduleInfo.getBuildSdkVersion().getApiLevel() >= 8 ? "match_parent" : "fill_parent";
        this.addMissingSizeAttributeLinks(psiFile, resourceResolver, builder, fill);
        builder.newline().add("Or: ").addLink("Automatically add all missing attributes", this.myLinkManager.createCommandLink((HtmlLinkManager.CommandLink)new AddMissingAttributesFix(psiFile, resourceResolver))).newline().newline().newline();
        this.addIssue().setSeverity(HighlightSeverity.ERROR).setSummary("One or more layouts are missing the layout_width or layout_height attributes").setHtmlContent(builder).build();
    }

    private void reportMissingClasses(@NotNull RenderLogger logger) {
        Set missingClasses = logger.getMissingClasses();
        if (missingClasses.isEmpty()) {
            return;
        }
        HtmlBuilder builder = new HtmlBuilder();
        if (this.handleMissingCalendarView(missingClasses, builder)) {
            return;
        }
        boolean missingResourceClass = logger.isMissingResourceClass() && logger.getResourceClass() != null && logger.hasLoadedClasses();
        builder.add("The following classes could not be found:");
        builder.beginList();
        ViewClasses views = this.getAvailableViews();
        if (missingResourceClass) {
            builder.listItem();
            builder.add(logger.getResourceClass());
        }
        boolean foundCustomView = false;
        for (String className : missingClasses) {
            builder.listItem();
            builder.add(className);
            builder.add(" (");
            foundCustomView |= this.addMissingClassLinks(builder, className, views.customViews, views.androidViewClassNames);
            builder.add(")");
        }
        builder.endList();
        if (foundCustomView) {
            builder.newline().add("One or more missing custom views were found in the project, but does not appear to have been compiled yet.");
        }
        this.addIssue().setSeverity(HighlightSeverity.ERROR).setSummary("Missing classes").setHtmlContent(builder).addMessageTip(RenderErrorContributorUtilKt.createBuildTheModuleMessage((HtmlLinkManager)this.myLinkManager)).addMessageTip(RenderErrorContributorUtilKt.createBuildTheProjectMessage((HtmlLinkManager)this.myLinkManager, null)).addMessageTip(RenderErrorContributorUtilKt.createBuildAndRefreshPreviewMessage((HtmlLinkManager)this.myLinkManager)).build();
    }

    private void reportBrokenClasses(@NotNull RenderLogger logger) {
        Map brokenClasses = logger.getBrokenClasses();
        if (brokenClasses.isEmpty()) {
            return;
        }
        HtmlBuilder builder = new HtmlBuilder();
        Project project = this.myModule.getProject();
        for (Throwable throwable : brokenClasses.values()) {
            if (RenderLogger.isIssue164378((Throwable)throwable)) {
                RenderErrorContributorImpl.addHtmlForIssue164378(throwable, project, this.myLinkManager, builder, false);
                break;
            }
            if (!DataBindingErrorUtils.handleDataBindingMapperError(throwable, builder)) continue;
            break;
        }
        builder.add("The following classes could not be instantiated:");
        boolean listContainsElements = false;
        Throwable firstThrowable = null;
        builder.beginList();
        for (Map.Entry entry : brokenClasses.entrySet()) {
            String className = (String)entry.getKey();
            Throwable throwable = (Throwable)entry.getValue();
            if (throwable != null && throwable.getMessage() != null && throwable.getMessage().startsWith(APP_COMPAT_REQUIRED_MSG) || WearTileRenderErrorContributor.isHandledByWearTileContributor(throwable)) continue;
            listContainsElements = true;
            builder.listItem().add(className).add(" (").addLink("Open Class", this.myLinkManager.createOpenClassUrl(className));
            if (throwable != null) {
                builder.add(", ");
                ShowExceptionFix detailsFix = new ShowExceptionFix(throwable);
                builder.addLink("Show Exception", this.myLinkManager.createActionLink((HtmlLinkManager.Action)detailsFix));
            }
            builder.add(", ").addLink("Clear Cache", this.myLinkManager.createClearCacheUrl()).add(")");
            if (firstThrowable != null || throwable == null) continue;
            firstThrowable = throwable;
        }
        if (!listContainsElements) {
            return;
        }
        if (firstThrowable != null) {
            builder.newline().newline().addHeading("Exception Details", HtmlBuilderHelper.getHeaderFontColor()).newline();
            this.reportThrowable(builder, firstThrowable, false);
            this.reportSandboxError(firstThrowable, true, false);
        }
        builder.newline().newline();
        this.addIssue().setSeverity(HighlightSeverity.ERROR, 100).setSummary("Failed to instantiate one or more classes").setHtmlContent(builder).addMessageTip(AllIcons.General.Information, new HtmlBuilder().addLink("Tip: Use ", "View.isInEditMode()", " in your custom views to skip code or show sample data when shown in the IDE.", "http://developer.android.com/reference/android/view/View.html#isInEditMode()").newline().add("If this is an unexpected error you can also try to ").addLink("", "build the project", ", then ", this.myLinkManager.createBuildProjectUrl()).addLink("manually ", "refresh the layout", ".", this.myLinkManager.createRefreshRenderUrl())).build();
    }

    private void reportOtherProblems(@NotNull RenderLogger logger) {
        List messages = logger.getMessages();
        if (messages.isEmpty()) {
            return;
        }
        HashSet seenTags = Sets.newHashSet();
        block12: for (RenderProblem message : messages) {
            Throwable throwable;
            String tag = message.getTag();
            if (tag != null && seenTags.contains(tag)) continue;
            seenTags.add(tag);
            if (tag != null) {
                switch (tag) {
                    case "resources.format": {
                        if (!this.reportTagResourceFormat(message)) break;
                        continue block12;
                    }
                    case "rtl-not-enabled": {
                        if (!this.reportRtlNotEnabled(logger)) break;
                        continue block12;
                    }
                    case "rtl-not-supported": {
                        this.addIssue().setSeverity(HighlightSeverity.ERROR).setSummary("RTL support requires API level >= 17").setHtmlContent(new HtmlBuilder().addHtml(message.getHtml())).build();
                        continue block12;
                    }
                    case "thread-creation": {
                        throwable = message.getThrowable();
                        HtmlBuilder builder = new HtmlBuilder();
                        this.reportThrowable(builder, throwable, false);
                        this.addIssue().setSeverity(HighlightSeverity.WARNING).setSummary(message.getHtml()).setHtmlContent(builder).build();
                        continue block12;
                    }
                }
            }
            HtmlBuilder builder = new HtmlBuilder();
            String html = message.getHtml();
            throwable = message.getThrowable();
            String summary = "Render problem";
            if (throwable != null) {
                if (this.reportSandboxError(throwable, false, true) || ComposeRenderErrorContributor.isHandledByComposeContributor(throwable)) continue;
                if (this.reportThrowable(builder, throwable, !html.isEmpty() || !message.isDefaultHtml())) {
                    if (!html.isEmpty()) {
                        builder.getStringBuilder().append(html);
                        builder.newlineIfNecessary();
                    }
                    summary = throwable.getLocalizedMessage() != null ? throwable.getLocalizedMessage() : summary;
                }
            } else {
                if (html.contains("has been edited more recently")) {
                    summary = "Build out-of-date";
                }
                builder.getStringBuilder().append(html);
                builder.newlineIfNecessary();
            }
            this.addIssue().setSeverity(ProblemSeverities.toHighlightSeverity((ProblemSeverity)message.getSeverity())).setSummary(summary).addMessageTip(RenderErrorContributorUtilKt.createBuildAndRefreshPreviewMessage((HtmlLinkManager)this.myLinkManager)).setHtmlContent(builder).build();
        }
    }

    private void reportUnknownFragments(@NotNull RenderLogger logger) {
        List fragmentNames = logger.getMissingFragments();
        if (fragmentNames == null || fragmentNames.isEmpty()) {
            return;
        }
        String fragmentTagName = MigrateToAndroidxUtil.isAndroidx((Project)this.myModule.getProject()) ? "androidx.fragment.app.FragmentContainerView" : "fragment";
        String fragmentTagDisplayName = "<" + fragmentTagName + ">";
        HtmlBuilder builder = new HtmlBuilder();
        builder.add("A ").addHtml("<code>").add(fragmentTagDisplayName).addHtml("</code>").add(" tag allows a layout file to dynamically include different layouts at runtime. ").add("At layout editing time the specific layout to be used is not known. You can choose which layout you would like previewed while editing the layout.");
        builder.beginList();
        for (String className : fragmentNames) {
            boolean isActivityKnown;
            builder.listItem();
            boolean isIdentified = className != null && !className.isEmpty();
            boolean bl = isActivityKnown = isIdentified && !className.startsWith("@");
            if (isIdentified) {
                builder.add("<").add(fragmentTagName).add(" ").addBold(className).add(" ...>");
            } else {
                builder.add(fragmentTagDisplayName);
            }
            builder.add(" (");
            if (isActivityKnown) {
                this.addFragmentLayoutSuggestions(builder, className);
            } else {
                builder.addLink("Choose Fragment Class...", this.myLinkManager.createAssignFragmentUrl(className));
            }
            builder.add(")");
        }
        builder.endList().newline().addLink("Do not warn about " + fragmentTagDisplayName + " tags in this session", this.myLinkManager.createIgnoreFragmentsUrl()).newline();
        this.addIssue().setSeverity(HighlightSeverity.ERROR).setSummary("Unknown fragments").setHtmlContent(builder).build();
    }

    private void reportRenderingFidelityProblems(@NotNull RenderLogger logger) {
        List fidelityWarnings = logger.getFidelityWarnings();
        if (fidelityWarnings.isEmpty()) {
            return;
        }
        HtmlBuilder builder = new HtmlBuilder();
        builder.add("The graphics preview in the layout editor may not be accurate:").newline();
        builder.beginList();
        int count = 0;
        for (RenderProblem warning : fidelityWarnings) {
            int remaining;
            builder.listItem();
            warning.appendHtml(builder.getStringBuilder());
            Object clientData = warning.getClientData();
            if (clientData != null) {
                builder.addLink(" (Ignore for this session)", this.myLinkManager.createActionLink(module -> {
                    RenderLogger.ignoreFidelityWarning((Object)clientData);
                    this.myLinkHandler.forceUserRequestedRefresh();
                }));
            }
            builder.newline();
            if (++count != 3 || (remaining = fidelityWarnings.size() - count) <= 0) continue;
            builder.add("(").addHtml(Integer.toString(remaining)).add(" additional render fidelity issues hidden)");
            break;
        }
        builder.endList();
        builder.addLink("Ignore all fidelity warnings for this session", this.myLinkManager.createActionLink(module -> {
            RenderLogger.ignoreAllFidelityWarnings();
            this.myLinkHandler.forceUserRequestedRefresh();
        }));
        builder.newline();
        this.addIssue().setSeverity(HighlightSeverity.WEAK_WARNING).setSummary("Layout fidelity warning").setHtmlContent(builder).build();
    }

    protected RenderErrorModel.Issue.Builder addIssue() {
        return new RenderErrorModel.Issue.Builder(){

            @NotNull
            public RenderErrorModel.Issue build() {
                RenderErrorModel.Issue built = super.build();
                RenderErrorContributorImpl.this.myIssues.add(built);
                return built;
            }
        }.setLinkHandler((HyperlinkListener)this.myLinkHandler);
    }

    private void reportMissingSize(@NotNull HtmlBuilder builder, @NotNull String fill, @NotNull XmlTag tag, @NotNull String id, @NotNull String attribute) {
        if (this.myModule.isDisposed()) {
            return;
        }
        String wrapUrl = this.myLinkManager.createCommandLink((HtmlLinkManager.CommandLink)new SetAttributeFix(tag, attribute, "http://schemas.android.com/apk/res/android", "wrap_content"));
        String fillUrl = this.myLinkManager.createCommandLink((HtmlLinkManager.CommandLink)new SetAttributeFix(tag, attribute, "http://schemas.android.com/apk/res/android", fill));
        builder.add(String.format("%1$s does not set the required %2$s attribute: ", id, attribute)).newline().addNbsps(4).addLink("Set to wrap_content", wrapUrl).add(", ").addLink("Set to " + fill, fillUrl).newline();
    }

    private void addMissingSizeAttributeLinks(@NotNull XmlFile psiFile, @NotNull ResourceResolver resourceResolver, @NotNull HtmlBuilder builder, @NotNull String fill) {
        ApplicationManager.getApplication().runReadAction(() -> AddMissingAttributesFix.findViewsMissingSizes(psiFile, resourceResolver).stream().map(SmartPsiElementPointer::getElement).filter(Objects::nonNull).filter(PsiElement::isValid).forEach(tag -> {
            boolean missingHeight;
            boolean missingWidth = !AddMissingAttributesFix.definesWidth(tag, resourceResolver);
            boolean bl = missingHeight = !AddMissingAttributesFix.definesHeight(tag, resourceResolver);
            assert (missingWidth || missingHeight);
            Object id = tag.getAttributeValue("id");
            id = id == null || ((String)id).isEmpty() ? "<" + tag.getName() + ">" : "\"" + Lint.stripIdPrefix((String)id) + "\"";
            if (missingWidth) {
                this.reportMissingSize(builder, fill, (XmlTag)tag, (String)id, "layout_width");
            }
            if (missingHeight) {
                this.reportMissingSize(builder, fill, (XmlTag)tag, (String)id, "layout_height");
            }
        }));
    }

    private static void addHtmlForIssue164378(@NotNull Throwable throwable, Project project, HtmlLinkManager linkManager, HtmlBuilder builder, boolean addShowExceptionLink) {
        builder.add("Rendering failed with a known bug. ");
        if (project == null) {
            builder.add("Please rebuild the project and then clear the cache by clicking the refresh icon above the preview.").newline();
            return;
        }
        builder.addLink("Please try a ", "rebuild", ".", linkManager.createBuildProjectUrl());
        builder.newline().newline();
        if (!addShowExceptionLink) {
            return;
        }
        ShowExceptionFix showExceptionFix = new ShowExceptionFix(throwable);
        builder.addLink("Show Exception", linkManager.createActionLink((HtmlLinkManager.Action)showExceptionFix));
    }

    private static boolean checkErrorsByFileType(@NotNull WolfTheProblemSolver wolfgang, @NotNull FileType type) {
        return (Boolean)ApplicationManager.getApplication().runReadAction(() -> wolfgang.hasProblemFilesBeneath(virtualFile -> virtualFile.getFileType() == type));
    }

    private boolean reportSandboxError(@NotNull Throwable throwable, boolean newlineBefore, boolean newlineAfter) {
        if (!(throwable instanceof SecurityException)) {
            return false;
        }
        HtmlBuilder builder = new HtmlBuilder();
        if (newlineBefore) {
            builder.newline();
        }
        builder.add("Looks like the preview you are running has run into a limitation of our preview environment. Due to how previews are created, we're not able to support:");
        builder.newline();
        builder.newline();
        builder.addBulletedItem("Network access: Previews can't make network requests.");
        builder.addBulletedItem("File system access: Previews can't read from or write to files on your device.");
        builder.addBulletedItem("Full Context API support: Some Android Context APIs might not be fully available.");
        builder.newline();
        builder.newline();
        builder.add("Please check your code for any reliance on these features, as they can prevent the preview from rendering correctly. Refer to the ");
        builder.addLink("documentation", "https://developer.android.com/develop/ui/compose/tooling/previews#preview-limitations");
        builder.add(" for a more detailed description.");
        builder.newline();
        builder.newline();
        builder.addLink("Turn off custom view rendering sandbox", this.myLinkManager.createDisableSandboxUrl());
        ShowExceptionFix showExceptionFix = new ShowExceptionFix(throwable);
        builder.newline().newline();
        builder.addLink("Show Exception", this.myLinkManager.createActionLink((HtmlLinkManager.Action)showExceptionFix));
        builder.newline().newline();
        String lastFailedPath = RenderSecurityManager.getLastFailedPath();
        if (lastFailedPath != null) {
            builder.newline().newline().add("Diagnostic info for Studio bug report:").newline().add("Failed path: ").add(lastFailedPath).newline();
            String tempDir = System.getProperty("java.io.tmpdir");
            builder.add("Normal temp dir: ").add(tempDir).newline();
            File normalized = new File(tempDir);
            builder.add("Normalized temp dir: ").add(normalized.getPath()).newline();
            try {
                builder.add("Canonical temp dir: ").add(normalized.getCanonicalPath()).newline();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            builder.add("os.name: ").add(SystemInfo.OS_NAME).newline().add("os.version: ").add(SystemInfo.OS_VERSION).newline().add("java.runtime.version: ").add(SystemInfo.JAVA_RUNTIME_VERSION);
        }
        if (newlineAfter) {
            builder.newline().newline();
        }
        this.addIssue().setSeverity(HighlightSeverity.ERROR).setSummary(throwable instanceof RenderSecurityException ? throwable.getMessage() : "Rendering sandbox error").setHtmlContent(builder).build();
        return true;
    }

    private boolean reportThrowable(@NotNull HtmlBuilder builder, @NotNull Throwable throwable, boolean hideIfIrrelevant) {
        StackTraceElement[] frames = throwable.getStackTrace();
        int end = RenderErrorContributorImpl.findBestThrowableFrame(frames);
        if (end == -1) {
            if (hideIfIrrelevant) {
                return true;
            }
            block0: for (int i = 0; i < frames.length; ++i) {
                StackTraceElement frame = frames[i];
                if (RenderErrorContributorImpl.isVisible(frame)) continue;
                end = i;
                if (end != 0) break;
                for (int j = 0; j < frames.length; ++j) {
                    frame = frames[j];
                    String className = frame.getClassName();
                    if (!className.equals(RENDER_SESSION_IMPL_FQCN)) continue;
                    end = j;
                    break block0;
                }
                break;
            }
        }
        builder.addHtml(StringUtil.replace((String)throwable.toString(), (String)"\n", (String)"<BR/>")).newline();
        this.addStackTrace(builder, frames, end);
        builder.addLink("Copy stack to clipboard", this.myLinkManager.createActionLink(module -> {
            String text = Throwables.getStackTraceAsString((Throwable)throwable);
            try {
                CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(text));
                this.myLinkManager.showNotification("Stack trace copied to clipboard");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }));
        return false;
    }

    private static int findBestThrowableFrame(@NotNull StackTraceElement[] frames) {
        int end = -1;
        boolean haveInterestingFrame = false;
        for (int i = 0; i < frames.length; ++i) {
            String className;
            StackTraceElement frame = frames[i];
            if (RenderErrorContributorImpl.isInterestingFrame(frame)) {
                haveInterestingFrame = true;
            }
            if (!(className = frame.getClassName()).equals(RENDER_SESSION_IMPL_FQCN)) continue;
            end = i;
            break;
        }
        return haveInterestingFrame ? end : -1;
    }

    private void addStackTrace(@NotNull HtmlBuilder builder, @NotNull StackTraceElement[] frames, int end) {
        boolean wasHidden = false;
        int indent = 2;
        File platformSource = null;
        boolean platformSourceExists = true;
        for (int i = 0; i < end; ++i) {
            StackTraceElement frame = frames[i];
            if (RenderErrorContributorImpl.isHiddenFrame(frame)) {
                wasHidden = true;
                continue;
            }
            String className = frame.getClassName();
            String methodName = frame.getMethodName();
            builder.addNbsps(indent);
            builder.add("at ").add(className).add(".").add(methodName);
            String fileName = frame.getFileName();
            if (fileName == null || fileName.isEmpty()) continue;
            int lineNumber = frame.getLineNumber();
            String location = fileName + ":" + lineNumber;
            if (RenderErrorContributorImpl.isInterestingFrame(frame)) {
                if (wasHidden) {
                    builder.addNbsps(indent).add("    ...").newline();
                    wasHidden = false;
                }
                url = this.myLinkManager.createOpenStackUrl(className, methodName, fileName, lineNumber);
                builder.add("(").addLink(location, url).add(")");
            } else {
                url = null;
                if (RenderErrorContributorImpl.isFramework(frame) && platformSourceExists) {
                    if (platformSource == null) {
                        IAndroidTarget target = this.myRenderContext != null ? this.myRenderContext.getConfiguration().getRealTarget() : null;
                        platformSource = target != null ? AndroidSdks.getInstance().findPlatformSources(target) : null;
                        boolean bl = platformSourceExists = platformSource != null;
                    }
                    if (platformSourceExists) {
                        url = this.findFrameworkSourceUrl(frame, platformSource, lineNumber);
                    }
                }
                if (url != null) {
                    builder.add("(").addLink(location, url).add(")");
                } else {
                    builder.add("(").add(location).add(")");
                }
            }
            builder.newline();
        }
    }

    @Nullable
    private String findFrameworkSourceUrl(@NotNull StackTraceElement frame, @NotNull File platformSource, int lineNumber) {
        File parentFile;
        File classFile = new File(platformSource, frame.getClassName().replace('.', File.separatorChar) + ".java");
        if (!classFile.exists() && !(classFile = new File((parentFile = classFile.getParentFile()).getParentFile(), parentFile.getName() + ".java")).exists()) {
            classFile = null;
        }
        if (classFile != null) {
            return HtmlLinkManager.createFilePositionUrl((File)classFile, (int)lineNumber, (int)0);
        }
        return null;
    }

    private boolean reportRtlNotEnabled(@NotNull RenderLogger logger) {
        return (Boolean)ApplicationManager.getApplication().runReadAction(() -> {
            Application application;
            if (this.myModule.isDisposed()) {
                return false;
            }
            Project project = this.myModule.getProject();
            if (project.isDisposed()) {
                return false;
            }
            AndroidFacet facet = AndroidFacet.getInstance((Module)this.myModule);
            Manifest manifest = facet != null ? Manifest.getMainManifest((AndroidFacet)facet) : null;
            Application application2 = application = manifest != null ? manifest.getApplication() : null;
            if (application == null) {
                return false;
            }
            XmlTag applicationTag = application.getXmlTag();
            if (applicationTag == null) {
                return false;
            }
            HtmlBuilder builder = new HtmlBuilder();
            builder.add("(").addLink("Add android:supportsRtl=\"true\" to the manifest", logger.getLinkManager().createActionLink(module -> {
                new SetAttributeFix(applicationTag, "supportsRtl", "http://schemas.android.com/apk/res/android", "true").executeCommand();
                this.myLinkHandler.forceUserRequestedRefresh();
            })).add(")");
            this.addIssue().setSeverity(HighlightSeverity.ERROR).setSummary("RTL support requires android:supportsRtl=\"true\" in the manifest").setHtmlContent(builder).build();
            return true;
        });
    }

    private boolean reportTagResourceFormat(@NotNull RenderProblem message) {
        String[] values;
        Object clientData = message.getClientData();
        if (!(clientData instanceof String[])) {
            return false;
        }
        String[] strings = (String[])clientData;
        if (strings.length != 2) {
            return false;
        }
        RenderContext renderContext = this.myRenderContext;
        if (renderContext == null) {
            return false;
        }
        IAndroidTarget target = renderContext.getConfiguration().getRealTarget();
        if (target == null) {
            return false;
        }
        AndroidPlatform platform = renderContext.getModule().getAndroidPlatform();
        if (platform == null) {
            return false;
        }
        AndroidTargetData targetData = AndroidTargetData.get((AndroidSdkData)platform.getSdkData(), (IAndroidTarget)target);
        AttributeDefinitions definitionLookup = targetData.getPublicAttrDefs();
        String attributeName = strings[0];
        String currentValue = strings[1];
        AttributeDefinition definition = definitionLookup.getAttrDefByName(attributeName);
        if (definition == null) {
            return false;
        }
        Set formats = definition.getFormats();
        if ((formats.contains(AttributeFormat.FLAGS) || formats.contains(AttributeFormat.ENUM)) && (values = definition.getValues()).length > 0) {
            HtmlBuilder builder = new HtmlBuilder();
            builder.add("Change ").add(currentValue).add(" to: ");
            boolean first = true;
            for (String value : values) {
                if (first) {
                    first = false;
                } else {
                    builder.add(", ");
                }
                builder.addLink(value, this.myLinkManager.createReplaceAttributeValueUrl(attributeName, currentValue, value));
            }
            this.addIssue().setSummary("Incorrect resource value format").setHtmlContent(builder).addMessageTip(RenderErrorContributorUtilKt.createBuildAndRefreshPreviewMessage((HtmlLinkManager)this.myLinkManager)).build();
            return true;
        }
        return false;
    }

    private boolean addTypoSuggestions(@NotNull HtmlBuilder builder, @NotNull String actual, @Nullable Collection<String> views, boolean compareWithPackage) {
        if (views == null || views.isEmpty()) {
            return false;
        }
        String actualBase = actual.substring(actual.lastIndexOf(46) + 1);
        String match = compareWithPackage ? actual : actualBase;
        int maxDistance = actualBase.length() >= 4 ? 2 : 1;
        for (String suggested : views) {
            String matchWith;
            String suggestedBase = suggested.substring(suggested.lastIndexOf(46) + 1);
            String string = matchWith = compareWithPackage ? suggested : suggestedBase;
            if (Math.abs(actualBase.length() - suggestedBase.length()) > maxDistance) continue;
            boolean sameBase = actualBase.equals(suggestedBase);
            if (!compareWithPackage && sameBase) continue;
            if (compareWithPackage) {
                if (!sameBase) continue;
                if (actualBase.equals(actual) && !actualBase.equals(suggested) && IdeResourcesUtil.isViewPackageNeeded((String)suggested, (int)-1)) {
                    builder.addLink(String.format("Change to %1$s", suggested), this.myLinkManager.createReplaceTagsUrl(actual, suggested));
                    builder.add(", ");
                    continue;
                }
            }
            if (compareWithPackage && Math.abs(match.length() - matchWith.length()) > maxDistance) continue;
            if (match.equals(matchWith)) {
                return true;
            }
            if (Lint.editDistance((String)match, (String)matchWith, (int)(maxDistance + 1)) > maxDistance) continue;
            String labelClass = suggestedBase.equals(actual) || actual.indexOf(46) != -1 ? suggested : suggestedBase;
            builder.addLink(String.format("Change to %1$s", labelClass), this.myLinkManager.createReplaceTagsUrl(actual, IdeResourcesUtil.isViewPackageNeeded((String)suggested, (int)-1) ? suggested : suggestedBase));
            builder.add(", ");
        }
        return false;
    }

    private boolean handleMissingCalendarView(@NotNull Set<String> missingClasses, @NotNull HtmlBuilder builder) {
        if (missingClasses.contains("CalendarView")) {
            builder.add("The ").addBold("CalendarView").add(" widget does not work correctly with this render target. As a workaround, try using the API 15 (Android 4.0.3) render target library by selecting it from the toolbar menu above.");
            if (missingClasses.size() == 1) {
                this.addIssue().setSeverity(HighlightSeverity.WARNING).setSummary("CalendarView does not work correctly with this render target").setHtmlContent(builder).build();
                return true;
            }
        }
        return false;
    }

    @NotNull
    private ViewClasses getAvailableViews() {
        Ref viewsRef = new Ref(Collections.emptyList());
        ProgressIndicatorUtils.runWithWriteActionPriority(() -> viewsRef.set(RenderErrorContributorImpl.getAllViews(this.myModule)), (ProgressIndicator)new EmptyProgressIndicator());
        Collection views = (Collection)viewsRef.get();
        if (views.isEmpty()) {
            return ViewClasses.EMPTY;
        }
        ArrayList customViews = Lists.newArrayListWithExpectedSize((int)Math.max(10, views.size() - 80));
        ArrayList androidViewClassNames = Lists.newArrayListWithExpectedSize((int)views.size());
        for (String fqcn : views) {
            if (fqcn.startsWith("android.") && !IdeResourcesUtil.isViewPackageNeeded((String)fqcn, (int)-1)) {
                androidViewClassNames.add(fqcn);
                continue;
            }
            customViews.add(fqcn);
        }
        return new ViewClasses(customViews, androidViewClassNames);
    }

    private boolean addMissingClassLinks(@NotNull HtmlBuilder builder, @NotNull String className, @NotNull Collection<String> customViews, @NotNull Collection<String> androidViewClassNames) {
        boolean foundCustomView = this.addTypoSuggestions(builder, className, customViews, false);
        this.addTypoSuggestions(builder, className, customViews, true);
        this.addTypoSuggestions(builder, className, androidViewClassNames, false);
        if (this.myLinkManager == null) {
            return foundCustomView;
        }
        if (AndroidXConstants.CLASS_CONSTRAINT_LAYOUT.isEquals(className)) {
            Project project = this.myModule.getProject();
            boolean useAndroidX = MigrateToAndroidxUtil.isAndroidx((Project)project);
            GoogleMavenArtifactId artifact = useAndroidX ? GoogleMavenArtifactId.ANDROIDX_CONSTRAINTLAYOUT : GoogleMavenArtifactId.CONSTRAINT_LAYOUT;
            builder.addLink("Add constraint-layout library dependency to the project", this.myLinkManager.createAddDependencyUrl(artifact));
            builder.add(", ");
        } else if ("com.google.android.flexbox.FlexboxLayout".equals(className)) {
            builder.addLink("Add flexbox layout library dependency to the project", this.myLinkManager.createAddDependencyUrl(GoogleMavenArtifactId.FLEXBOX_LAYOUT));
            builder.add(", ");
        } else if ("androidx.compose.ui.tooling.ComposeViewAdapter".equals(className)) {
            builder.add("This is likely due to a missing ui-tooling dependency in your project configuration. If your active variant is debug: ");
            builder.addLink("Add the ui-tooling library to your project's dependencies", this.myLinkManager.createAddDebugDependencyUrl(GoogleMavenArtifactId.COMPOSE_TOOLING));
            builder.add(". If you are using a release variant and require previews: ");
            builder.addLink("Add the ui-tooling dependency as an implementation dependency", this.myLinkManager.createAddDependencyUrl(GoogleMavenArtifactId.COMPOSE_TOOLING));
            builder.add(". Note that including ui-tooling in a release build will increase your APK size and potentially build time. ");
            builder.add("Remember to remove this dependency from your release configuration after you have finished using the preview features. ");
            builder.add("Alternatively, you can try to:  ");
        } else if ("androidx.wear.tiles.tooling.TileServiceViewAdapter".equals(className)) {
            builder.addLink("Add tiles-tooling library dependency to the project", this.myLinkManager.createAddDebugDependencyUrl(GoogleMavenArtifactId.WEAR_TILES_TOOLING));
            builder.add(", ");
        }
        builder.addLink("Fix Build Path", this.myLinkManager.createEditClassPathUrl());
        String fileType = this.mySourceFile.getFileType() == XmlFileType.INSTANCE ? "XML" : "File";
        builder.add(", ");
        builder.addLink("Edit " + fileType, this.myLinkManager.createShowTagUrl(className));
        if (className.indexOf(46) != -1) {
            builder.add(", ");
            builder.addLink("Create Class", this.myLinkManager.createNewClassUrl(className));
        }
        return foundCustomView;
    }

    private void addFragmentLayoutSuggestions(@NotNull HtmlBuilder builder, @NotNull String className) {
        Project project = this.myModule.getProject();
        ApplicationManager.getApplication().runReadAction(() -> {
            GlobalSearchScope scope2 = GlobalSearchScope.allScope((Project)project);
            PsiClass clz = DumbService.getInstance((Project)project).isDumb() ? null : JavaPsiFacade.getInstance((Project)project).findClass(className, scope2);
            String layoutName = this.mySourceFile.getName();
            boolean separate = false;
            if (clz != null) {
                String matchText = clz.getText();
                Pattern LAYOUT_FIELD_PATTERN = Pattern.compile("R\\.layout\\.([a-z0-9_]+)");
                Matcher matcher = LAYOUT_FIELD_PATTERN.matcher(matchText);
                TreeSet layouts = Sets.newTreeSet();
                int index = 0;
                while (matcher.find(index)) {
                    layouts.add(matcher.group(1));
                    index = matcher.end();
                }
                for (String layout : layouts) {
                    if (layout.equals(layoutName)) continue;
                    if (separate) {
                        builder.add(", ");
                    }
                    builder.addLink("Use @layout/" + layout, this.myLinkManager.createAssignLayoutUrl(className, layout));
                    separate = true;
                }
            }
            if (separate) {
                builder.add(", ");
            }
            builder.addLink("Pick Layout...", this.myLinkManager.createPickLayoutUrl(className));
        });
    }

    private static boolean isHiddenFrame(@NotNull StackTraceElement frame) {
        String className = frame.getClassName();
        return className.startsWith("sun.reflect.") || className.equals("android.view.BridgeInflater") || className.startsWith("com.android.tools.") || className.startsWith("org.jetbrains.");
    }

    private static boolean isInterestingFrame(@NotNull StackTraceElement frame) {
        String className = frame.getClassName();
        return !RenderErrorContributorImpl.isFramework(frame) && !className.startsWith("org.jetbrains.") && !className.startsWith("com.android.");
    }

    private static boolean isFramework(@NotNull StackTraceElement frame) {
        String className = frame.getClassName();
        return className.startsWith("android.") || className.startsWith("java.") || className.startsWith("javax.") || className.startsWith("sun.");
    }

    private static boolean isVisible(@NotNull StackTraceElement frame) {
        return !RenderErrorContributorImpl.isFramework(frame);
    }

    @NotNull
    private static Collection<String> getAllViews(@Nullable Module module) {
        if (module == null) {
            return Collections.emptyList();
        }
        if (!ApplicationManager.getApplication().isReadAccessAllowed()) {
            return (Collection)ReadAction.compute(() -> RenderErrorContributorImpl.getAllViews(module));
        }
        if (DumbService.getInstance((Project)module.getProject()).isDumb()) {
            LOG.warn("getAllViews called in Dumb mode, no views will be returned");
            return Collections.emptyList();
        }
        return TagToClassMapper.getInstance((Module)module).getClassMap("android.view.View").values().stream().map(PsiClass::getQualifiedName).collect(Collectors.toSet());
    }

    private static class ViewClasses {
        final Collection<String> customViews;
        final Collection<String> androidViewClassNames;
        static final ViewClasses EMPTY = new ViewClasses(Collections.emptyList(), Collections.emptyList());

        ViewClasses(@NotNull Collection<String> customViews, @NotNull Collection<String> androidViewClassNames) {
            this.customViews = customViews;
            this.androidViewClassNames = androidViewClassNames;
        }
    }

    public static class Provider
    implements RenderErrorContributor.Provider {
        public boolean isApplicable(Project project) {
            return true;
        }

        public RenderErrorContributor getContributor(@Nullable EditorDesignSurface surface2, @NotNull RenderResult result) {
            return new RenderErrorContributorImpl(surface2, result);
        }
    }
}

