/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.preview.util.device.check;

import com.android.tools.idea.preview.util.device.check.DeviceSpecCheckState;
import com.android.tools.idea.preview.util.device.check.DeviceSpecCheckStateKt;
import com.android.tools.idea.preview.util.device.check.DeviceSpecValueTypesKt;
import com.android.tools.idea.preview.util.device.check.DimensionParameterCheckResult;
import com.android.tools.idea.preview.util.device.check.ExpectedValueType;
import com.android.tools.idea.preview.util.device.check.ParameterCheckResult;
import com.android.tools.idea.preview.util.device.check.ParameterRule;
import com.android.tools.preview.config.DeviceSpecDimensionUtilKt;
import com.android.tools.preview.config.DimUnit;
import com.android.tools.preview.config.Preview;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.diagnostic.Logger;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0004\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u001a\u0010\u0018\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0003H\u0002J\u0010\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u0003H\u0002R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\n\u001a\u00070\u000b\u00a2\u0006\u0002\b\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\tR\u0014\u0010\u000f\u001a\u00020\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001e"}, d2={"Lcom/android/tools/idea/preview/util/device/check/DimensionParameterRule;", "Lcom/android/tools/idea/preview/util/device/check/ParameterRule;", "name", "", "defaultNumber", "", "<init>", "(Ljava/lang/String;I)V", "getName", "()Ljava/lang/String;", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "defaultValue", "getDefaultValue", "expectedType", "Lcom/android/tools/idea/preview/util/device/check/ExpectedValueType;", "getExpectedType", "()Lcom/android/tools/idea/preview/util/device/check/ExpectedValueType;", "checkValue", "", "value", "dataProvider", "Lcom/intellij/openapi/actionSystem/DataProvider;", "attemptFix", "fixNumberOrDefault", "", "valueToFix", "isBadNumber", "numberString", "intellij.android.preview-designer"})
@SourceDebugExtension(value={"SMAP\nDimensionParameterRule.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DimensionParameterRule.kt\ncom/android/tools/idea/preview/util/device/check/DimensionParameterRule\n+ 2 EnumUtils.kt\ncom/android/ide/common/util/EnumUtilsKt\n+ 3 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,134:1\n27#2,5:135\n170#3,6:140\n*S KotlinDebug\n*F\n+ 1 DimensionParameterRule.kt\ncom/android/tools/idea/preview/util/device/check/DimensionParameterRule\n*L\n47#1:135,5\n128#1:140,6\n*E\n"})
public final class DimensionParameterRule
extends ParameterRule {
    @NotNull
    private final String name;
    private final int defaultNumber;
    @NotNull
    private final Logger log;
    @NotNull
    private final String defaultValue;
    @NotNull
    private final ExpectedValueType expectedType;

    public DimensionParameterRule(@NotNull String name, int defaultNumber) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.name = name;
        this.defaultNumber = defaultNumber;
        Logger logger = Logger.getInstance(this.getClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.log = logger;
        this.defaultValue = "" + this.defaultNumber + Preview.DeviceSpec.INSTANCE.getDEFAULT_UNIT();
        this.expectedType = DeviceSpecValueTypesKt.getExpectedFloatWithUnit();
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public String getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    @NotNull
    public ExpectedValueType getExpectedType() {
        return this.expectedType;
    }

    @Override
    public boolean checkValue(@NotNull String value, @NotNull DataProvider dataProvider) {
        boolean bl;
        DimUnit expectedUnit;
        Enum enum_;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)dataProvider, (String)"dataProvider");
        DeviceSpecCheckState deviceSpecState = (DeviceSpecCheckState)DeviceSpecCheckStateKt.getDeviceSpecCheckStateKey().getData(dataProvider);
        String value$iv = StringsKt.takeLast((String)value, (int)2);
        boolean $i$f$enumValueOfOrNull = false;
        try {
            enum_ = (Enum)DimUnit.valueOf((String)value$iv);
        }
        catch (Exception exception) {
            enum_ = null;
        }
        DimUnit currentUnit = (DimUnit)enum_;
        if (currentUnit == null) {
            if (this.isBadNumber(value)) {
                DeviceSpecCheckState deviceSpecCheckState = deviceSpecState;
                if (deviceSpecCheckState != null) {
                    deviceSpecCheckState.setCheckResult(this.getName(), DimensionParameterCheckResult.BadStatement);
                }
                return false;
            }
            DeviceSpecCheckState deviceSpecCheckState = deviceSpecState;
            if (deviceSpecCheckState != null) {
                deviceSpecCheckState.setCheckResult(this.getName(), DimensionParameterCheckResult.MissingUnit);
            }
            return false;
        }
        if (this.isBadNumber(StringsKt.dropLast((String)value, (int)2))) {
            DeviceSpecCheckState deviceSpecCheckState = deviceSpecState;
            if (deviceSpecCheckState != null) {
                deviceSpecCheckState.setCheckResult(this.getName(), DimensionParameterCheckResult.BadNumber);
            }
            return false;
        }
        DeviceSpecCheckState deviceSpecCheckState = deviceSpecState;
        Object object = expectedUnit = deviceSpecCheckState != null ? deviceSpecCheckState.getCommonUnit() : null;
        if (expectedUnit != null && currentUnit != expectedUnit) {
            deviceSpecState.setCheckResult(this.getName(), DimensionParameterCheckResult.WrongUnit);
            bl = false;
        } else {
            if (deviceSpecState != null && deviceSpecState.getCommonUnit() == null) {
                deviceSpecState.setCommonUnit(currentUnit);
            }
            DeviceSpecCheckState deviceSpecCheckState2 = deviceSpecState;
            if (deviceSpecCheckState2 != null) {
                deviceSpecCheckState2.setCheckResult(this.getName(), DimensionParameterCheckResult.Ok);
            }
            bl = true;
        }
        return bl;
    }

    @Override
    @Nullable
    public String attemptFix(@NotNull String value, @NotNull DataProvider dataProvider) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)dataProvider, (String)"dataProvider");
        DeviceSpecCheckState deviceSpecCheckState = (DeviceSpecCheckState)DeviceSpecCheckStateKt.getDeviceSpecCheckStateKey().getData(dataProvider);
        if (deviceSpecCheckState == null) {
            DimensionParameterRule $this$attemptFix_u24lambda_u240 = this;
            boolean bl = false;
            $this$attemptFix_u24lambda_u240.log.error("Expected a " + Reflection.getOrCreateKotlinClass(DeviceSpecCheckState.class).getSimpleName() + " object");
            return null;
        }
        DeviceSpecCheckState deviceSpecState = deviceSpecCheckState;
        ParameterCheckResult parameterCheckResult = deviceSpecState.getCheckResult(this.getName());
        DimensionParameterCheckResult dimensionParameterCheckResult = parameterCheckResult instanceof DimensionParameterCheckResult ? (DimensionParameterCheckResult)parameterCheckResult : null;
        if (dimensionParameterCheckResult == null) {
            DimensionParameterRule $this$attemptFix_u24lambda_u241 = this;
            boolean bl = false;
            $this$attemptFix_u24lambda_u241.log.error("Expected " + Reflection.getOrCreateKotlinClass(DimensionParameterCheckResult.class).getSimpleName() + " for " + $this$attemptFix_u24lambda_u241.getName());
            return null;
        }
        DimensionParameterCheckResult parameterState = dimensionParameterCheckResult;
        DimUnit dimUnit = deviceSpecState.getCommonUnit();
        if (dimUnit == null) {
            dimUnit = Preview.DeviceSpec.INSTANCE.getDEFAULT_UNIT();
        }
        DimUnit commonUnit = dimUnit;
        return switch (WhenMappings.$EnumSwitchMapping$0[parameterState.ordinal()]) {
            case 1 -> StringsKt.dropLast((String)value, (int)2) + commonUnit.name();
            case 2 -> value + commonUnit.name();
            case 3 -> this.fixNumberOrDefault(StringsKt.dropLast((String)value, (int)2)) + commonUnit.name();
            case 4 -> this.defaultNumber + commonUnit.name();
            case 5 -> {
                this.log.warn("Call to fix value, but nothing to fix");
                yield value;
            }
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private final Number fixNumberOrDefault(String valueToFix) {
        Float floatNumber = null;
        int lengthToFix = valueToFix.length();
        while (floatNumber == null && lengthToFix > 0) {
            floatNumber = StringsKt.toFloatOrNull((String)((Object)valueToFix.subSequence(0, lengthToFix--)).toString());
        }
        if (floatNumber == null) {
            return this.defaultNumber;
        }
        return DeviceSpecDimensionUtilKt.convertToDeviceSpecDimension((float)floatNumber.floatValue());
    }

    private final boolean isBadNumber(String numberString) {
        int n;
        block2: {
            CharSequence $this$indexOfLast$iv = numberString;
            boolean $i$f$indexOfLast = false;
            int n2 = $this$indexOfLast$iv.length() + -1;
            if (0 <= n2) {
                do {
                    int index$iv = n2--;
                    char it = $this$indexOfLast$iv.charAt(index$iv);
                    boolean bl = false;
                    if (!(it == '.')) continue;
                    n = index$iv;
                    break block2;
                } while (0 <= n2);
            }
            n = -1;
        }
        int decimalIndex = n;
        return StringsKt.toFloatOrNull((String)numberString) == null || decimalIndex >= 0 && numberString.length() - decimalIndex > 2;
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DimensionParameterCheckResult.values().length];
            try {
                nArray[DimensionParameterCheckResult.WrongUnit.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DimensionParameterCheckResult.MissingUnit.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DimensionParameterCheckResult.BadNumber.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DimensionParameterCheckResult.BadStatement.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DimensionParameterCheckResult.Ok.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

