/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.preview.interactive;

import com.android.tools.idea.common.surface.DelegateInteractionHandler;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.common.surface.InteractionHandler;
import com.android.tools.idea.common.surface.LayoutlibInteractionHandler;
import com.android.tools.idea.common.util.ControllableTicker;
import com.android.tools.idea.preview.analytics.InteractivePreviewUsageTracker;
import com.android.tools.idea.preview.interactive.FpsCalculator;
import com.android.tools.idea.uibuilder.scene.InteractiveSceneManager;
import com.android.tools.rendering.RenderService;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import java.time.Duration;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001BE\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0007\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0007\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0006\u0010\u001e\u001a\u00020\u001fJ\u0006\u0010 \u001a\u00020\u001fJ\u0006\u0010!\u001a\u00020\u001fJ\u0006\u0010\"\u001a\u00020\u001fJ\b\u0010#\u001a\u00020\u001fH\u0002J\b\u0010$\u001a\u00020\u001fH\u0016R\u0012\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u0005@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/android/tools/idea/preview/interactive/InteractivePreviewManager;", "Lcom/intellij/openapi/Disposable;", "surface", "Lcom/android/tools/idea/common/surface/DesignSurface;", "initialFpsLimit", "", "interactiveScenesProvider", "Lkotlin/Function0;", "", "Lcom/android/tools/idea/uibuilder/scene/InteractiveSceneManager;", "usageTrackerProvider", "Lcom/android/tools/idea/preview/analytics/InteractivePreviewUsageTracker;", "delegateInteractionHandler", "Lcom/android/tools/idea/common/surface/DelegateInteractionHandler;", "<init>", "(Lcom/android/tools/idea/common/surface/DesignSurface;ILkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;Lcom/android/tools/idea/common/surface/DelegateInteractionHandler;)V", "fpsCounter", "Lcom/android/tools/idea/preview/interactive/FpsCalculator;", "originalInteractionHandler", "Lcom/android/tools/idea/common/surface/InteractionHandler;", "interactiveInteractionHandler", "Lcom/android/tools/idea/common/surface/LayoutlibInteractionHandler;", "value", "fpsLimit", "getFpsLimit", "()I", "setFpsLimit", "(I)V", "ticker", "Lcom/android/tools/idea/common/util/ControllableTicker;", "start", "", "resume", "pause", "stop", "logMetrics", "dispose", "intellij.android.preview-designer"})
@SourceDebugExtension(value={"SMAP\nInteractivePreviewManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InteractivePreviewManager.kt\ncom/android/tools/idea/preview/interactive/InteractivePreviewManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,96:1\n1#2:97\n1869#3,2:98\n1869#3,2:100\n1869#3,2:102\n1869#3,2:104\n*S KotlinDebug\n*F\n+ 1 InteractivePreviewManager.kt\ncom/android/tools/idea/preview/interactive/InteractivePreviewManager\n*L\n61#1:98,2\n72#1:100,2\n78#1:102,2\n53#1:104,2\n*E\n"})
public final class InteractivePreviewManager
implements Disposable {
    @NotNull
    private final DesignSurface<?> surface;
    @NotNull
    private final Function0<Collection<InteractiveSceneManager>> interactiveScenesProvider;
    @NotNull
    private final Function0<InteractivePreviewUsageTracker> usageTrackerProvider;
    @NotNull
    private final DelegateInteractionHandler delegateInteractionHandler;
    @NotNull
    private final FpsCalculator fpsCounter;
    @NotNull
    private final InteractionHandler originalInteractionHandler;
    @NotNull
    private final LayoutlibInteractionHandler interactiveInteractionHandler;
    private int fpsLimit;
    @NotNull
    private final ControllableTicker ticker;

    /*
     * WARNING - void declaration
     */
    public InteractivePreviewManager(@NotNull DesignSurface<?> surface2, int initialFpsLimit, @NotNull Function0<? extends Collection<? extends InteractiveSceneManager>> interactiveScenesProvider, @NotNull Function0<? extends InteractivePreviewUsageTracker> usageTrackerProvider, @NotNull DelegateInteractionHandler delegateInteractionHandler) {
        void it;
        ControllableTicker controllableTicker;
        Intrinsics.checkNotNullParameter(surface2, (String)"surface");
        Intrinsics.checkNotNullParameter(interactiveScenesProvider, (String)"interactiveScenesProvider");
        Intrinsics.checkNotNullParameter(usageTrackerProvider, (String)"usageTrackerProvider");
        Intrinsics.checkNotNullParameter((Object)delegateInteractionHandler, (String)"delegateInteractionHandler");
        this.surface = surface2;
        this.interactiveScenesProvider = interactiveScenesProvider;
        this.usageTrackerProvider = usageTrackerProvider;
        this.delegateInteractionHandler = delegateInteractionHandler;
        this.fpsCounter = new FpsCalculator((Function0<Long>)((Function0)InteractivePreviewManager::fpsCounter$lambda$0));
        this.originalInteractionHandler = this.delegateInteractionHandler.getDelegate();
        this.interactiveInteractionHandler = new LayoutlibInteractionHandler(this.surface, this.surface.getPannable());
        this.fpsLimit = initialFpsLimit;
        Function0 function0 = () -> InteractivePreviewManager.ticker$lambda$0(this);
        Duration duration = Duration.ofMillis(5L);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofMillis(...)");
        ControllableTicker controllableTicker2 = controllableTicker = new ControllableTicker(function0, duration, null, 4, null);
        InteractivePreviewManager interactivePreviewManager = this;
        boolean bl = false;
        Disposer.register((Disposable)this, (Disposable)((Disposable)it));
        interactivePreviewManager.ticker = controllableTicker;
    }

    public final int getFpsLimit() {
        return this.fpsLimit;
    }

    public final void setFpsLimit(int value) {
        this.fpsLimit = value;
        this.fpsCounter.resetAndStart();
    }

    public final void start() {
        Iterable $this$forEach$iv = (Iterable)this.interactiveScenesProvider.invoke();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            InteractiveSceneManager it = (InteractiveSceneManager)element$iv;
            boolean bl = false;
            it.resetInteractiveEventsCounter();
        }
        this.fpsCounter.resetAndStart();
        this.ticker.start();
        this.delegateInteractionHandler.setDelegate(this.interactiveInteractionHandler);
        this.surface.enableMouseClickDisplay();
    }

    public final void resume() {
        this.fpsCounter.resetAndStart();
        Iterable $this$forEach$iv = (Iterable)this.interactiveScenesProvider.invoke();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            InteractiveSceneManager it = (InteractiveSceneManager)element$iv;
            boolean bl = false;
            it.resumeSessionClock();
        }
        this.ticker.start();
    }

    public final void pause() {
        this.ticker.stop();
        Iterable $this$forEach$iv = (Iterable)this.interactiveScenesProvider.invoke();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            InteractiveSceneManager it = (InteractiveSceneManager)element$iv;
            boolean bl = false;
            it.pauseSessionClock();
        }
    }

    public final void stop() {
        this.surface.disableMouseClickDisplay();
        this.delegateInteractionHandler.setDelegate(this.originalInteractionHandler);
        this.ticker.stop();
        this.logMetrics();
    }

    /*
     * WARNING - void declaration
     */
    private final void logMetrics() {
        Iterable iterable = (Iterable)this.interactiveScenesProvider.invoke();
        int n = 0;
        for (Object t : iterable) {
            void it;
            InteractiveSceneManager interactiveSceneManager = (InteractiveSceneManager)t;
            int n2 = n;
            boolean bl = false;
            int n3 = it.getInteractiveEventsCount();
            n = n2 + n3;
        }
        int touchEvents = n;
        ((InteractivePreviewUsageTracker)this.usageTrackerProvider.invoke()).logInteractiveSession(this.fpsCounter.getFps(), this.fpsCounter.getDurationMs(), touchEvents);
    }

    public void dispose() {
    }

    private static final long fpsCounter$lambda$0() {
        return System.nanoTime();
    }

    private static final Unit ticker$lambda$0(InteractivePreviewManager this$0) {
        if (!RenderService.isBusy() && this$0.fpsCounter.getFps() <= this$0.fpsLimit) {
            this$0.fpsCounter.incrementFrameCounter();
            Iterable $this$forEach$iv = (Iterable)this$0.interactiveScenesProvider.invoke();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                InteractiveSceneManager it = (InteractiveSceneManager)element$iv;
                boolean bl = false;
                it.requestInteractiveRender();
            }
        }
        return Unit.INSTANCE;
    }
}

