/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.preview.animation.state;

import com.android.tools.idea.preview.animation.AnimationTracker;
import com.android.tools.idea.preview.animation.AnimationUnit;
import com.android.tools.idea.preview.animation.state.ColorPickerAction;
import com.android.tools.idea.preview.animation.state.FromToState;
import com.android.tools.idea.preview.animation.state.SwapAction;
import com.android.tools.idea.preview.animation.state.ToolbarLabel;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.ui.JBColor;
import java.awt.Color;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\b&\u0018\u0000 \u0016*\u0012\b\u0000\u0010\u0001*\f\u0012\u0002\b\u0003\u0012\u0004\u0012\u0002H\u00010\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u0001\u0016B\u001f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00028\u0000\u0012\u0006\u0010\u0007\u001a\u00028\u0000\u00a2\u0006\u0004\b\b\u0010\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\n\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00000\f0\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR!\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00108VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\u0015\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0017"}, d2={"Lcom/android/tools/idea/preview/animation/state/ColorAnimationState;", "T", "Lcom/android/tools/idea/preview/animation/AnimationUnit$Color;", "Lcom/android/tools/idea/preview/animation/state/FromToState;", "tracker", "Lcom/android/tools/idea/preview/animation/AnimationTracker;", "initialColor", "targetColor", "<init>", "(Lcom/android/tools/idea/preview/animation/AnimationTracker;Lcom/android/tools/idea/preview/animation/AnimationUnit$Color;Lcom/android/tools/idea/preview/animation/AnimationUnit$Color;)V", "state", "Lkotlinx/coroutines/flow/MutableStateFlow;", "Lkotlin/Pair;", "getState", "()Lkotlinx/coroutines/flow/MutableStateFlow;", "changeStateActions", "", "Lcom/intellij/openapi/actionSystem/AnAction;", "getChangeStateActions", "()Ljava/util/List;", "changeStateActions$delegate", "Lkotlin/Lazy;", "Companion", "intellij.android.preview-designer"})
@SourceDebugExtension(value={"SMAP\nColorAnimationState.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ColorAnimationState.kt\ncom/android/tools/idea/preview/animation/state/ColorAnimationState\n+ 2 StateFlow.kt\nkotlinx/coroutines/flow/StateFlowKt\n*L\n1#1,62:1\n230#2,5:63\n230#2,5:68\n*S KotlinDebug\n*F\n+ 1 ColorAnimationState.kt\ncom/android/tools/idea/preview/animation/state/ColorAnimationState\n*L\n52#1:63,5\n56#1:68,5\n*E\n"})
public abstract class ColorAnimationState<T extends AnimationUnit.Color<?, T>>
implements FromToState<T> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AnimationTracker tracker;
    @NotNull
    private final MutableStateFlow<Pair<T, T>> state;
    @NotNull
    private final Lazy changeStateActions$delegate;
    @NotNull
    private static final Color DEFAULT_COLOR;

    public ColorAnimationState(@NotNull AnimationTracker tracker, @NotNull T initialColor, @NotNull T targetColor) {
        Intrinsics.checkNotNullParameter((Object)tracker, (String)"tracker");
        Intrinsics.checkNotNullParameter(initialColor, (String)"initialColor");
        Intrinsics.checkNotNullParameter(targetColor, (String)"targetColor");
        this.tracker = tracker;
        this.state = StateFlowKt.MutableStateFlow((Object)TuplesKt.to(initialColor, targetColor));
        this.changeStateActions$delegate = LazyKt.lazy(() -> ColorAnimationState.changeStateActions_delegate$lambda$0(this, initialColor, targetColor));
    }

    @Override
    @NotNull
    public MutableStateFlow<Pair<T, T>> getState() {
        return this.state;
    }

    @Override
    @NotNull
    public List<AnAction> getChangeStateActions() {
        Lazy lazy = this.changeStateActions$delegate;
        return (List)lazy.getValue();
    }

    private static final List changeStateActions_delegate$lambda$0(ColorAnimationState this$0, AnimationUnit.Color $initialColor, AnimationUnit.Color $targetColor) {
        AnimationTracker animationTracker = this$0.tracker;
        Color color = $initialColor.getColor();
        if (color == null) {
            color = DEFAULT_COLOR;
        }
        ColorPickerAction initial = new ColorPickerAction(animationTracker, color, null, arg_0 -> ColorAnimationState.changeStateActions_delegate$lambda$0$0(this$0, arg_0), 4, null);
        AnimationTracker animationTracker2 = this$0.tracker;
        Color color2 = $targetColor.getColor();
        if (color2 == null) {
            color2 = DEFAULT_COLOR;
        }
        ColorPickerAction target = new ColorPickerAction(animationTracker2, color2, null, arg_0 -> ColorAnimationState.changeStateActions_delegate$lambda$0$1(this$0, arg_0), 4, null);
        Object[] objectArray = new AnAction[]{new SwapAction(this$0.tracker, (Function0<Unit>)((Function0)() -> ColorAnimationState.changeStateActions_delegate$lambda$0$2(initial, target))), initial, new ToolbarLabel("to"), target};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    private static final Unit changeStateActions_delegate$lambda$0$0(ColorAnimationState this$0, Color it) {
        Pair pair;
        AnimationUnit.Color target;
        Pair nextValue$iv;
        Object prevValue$iv;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        MutableStateFlow $this$update$iv = this$0.getState();
        boolean $i$f$update = false;
        do {
            prevValue$iv = $this$update$iv.getValue();
            pair = (Pair)prevValue$iv;
            boolean bl = false;
        } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = TuplesKt.to((target = (AnimationUnit.Color)pair.component2()).create(it), (Object)target))));
        return Unit.INSTANCE;
    }

    private static final Unit changeStateActions_delegate$lambda$0$1(ColorAnimationState this$0, Color it) {
        Pair pair;
        AnimationUnit.Color initial;
        Pair nextValue$iv;
        Object prevValue$iv;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        MutableStateFlow $this$update$iv = this$0.getState();
        boolean $i$f$update = false;
        do {
            prevValue$iv = $this$update$iv.getValue();
            pair = (Pair)prevValue$iv;
            boolean bl = false;
        } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = TuplesKt.to((Object)(initial = (AnimationUnit.Color)pair.component1()), initial.create(it)))));
        return Unit.INSTANCE;
    }

    private static final Unit changeStateActions_delegate$lambda$0$2(ColorPickerAction $initial, ColorPickerAction $target) {
        $initial.swapWith($target);
        return Unit.INSTANCE;
    }

    static {
        JBColor jBColor = JBColor.WHITE;
        Intrinsics.checkNotNullExpressionValue((Object)jBColor, (String)"WHITE");
        DEFAULT_COLOR = (Color)jBColor;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/android/tools/idea/preview/animation/state/ColorAnimationState$Companion;", "", "<init>", "()V", "DEFAULT_COLOR", "Ljava/awt/Color;", "getDEFAULT_COLOR", "()Ljava/awt/Color;", "intellij.android.preview-designer"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Color getDEFAULT_COLOR() {
            return DEFAULT_COLOR;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

