/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.preview.animation;

import com.android.tools.idea.preview.animation.AnimationTracker;
import com.android.tools.idea.preview.animation.InspectorLayout;
import com.android.tools.idea.preview.animation.InspectorPainter;
import com.android.tools.idea.preview.animation.TimelineSliderUI;
import com.android.tools.idea.preview.animation.Tooltip;
import com.android.tools.idea.preview.animation.timeline.TimelineElement;
import com.intellij.ui.components.JBSlider;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001:\u0001(B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\rJ\b\u0010\u001c\u001a\u00020\u0010H\u0016J\b\u0010\u001d\u001a\u00020\u0015H\u0016J\u0010\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u001f\u001a\u00020\rH\u0016J\b\u0010 \u001a\u00020!H\u0016J\b\u0010\"\u001a\u00020#H\u0016J\b\u0010$\u001a\u00020\u0015H\u0002J\n\u0010%\u001a\u0004\u0018\u00010&H\u0016J\n\u0010'\u001a\u0004\u0018\u00010&H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000f\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0017\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\u00190\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006)"}, d2={"Lcom/android/tools/idea/preview/animation/TimelinePanel;", "Lcom/intellij/ui/components/JBSlider;", "tooltip", "Lcom/android/tools/idea/preview/animation/Tooltip;", "tracker", "Lcom/android/tools/idea/preview/animation/AnimationTracker;", "<init>", "(Lcom/android/tools/idea/preview/animation/Tooltip;Lcom/android/tools/idea/preview/animation/AnimationTracker;)V", "getTooltip", "()Lcom/android/tools/idea/preview/animation/Tooltip;", "getTracker", "()Lcom/android/tools/idea/preview/animation/AnimationTracker;", "cachedSliderWidth", "", "cachedMax", "sliderUI", "Lcom/android/tools/idea/preview/animation/TimelineSliderUI;", "getSliderUI", "()Lcom/android/tools/idea/preview/animation/TimelineSliderUI;", "zoomValue", "scale", "", "z", "dragEndListeners", "", "Lkotlin/Function0;", "getDragEndListeners", "()Ljava/util/List;", "createSliderUI", "updateUI", "setMaximum", "maximum", "getPreferredSize", "Ljava/awt/Dimension;", "getFont", "Ljava/awt/Font;", "updateMajorTicks", "getBackground", "Ljava/awt/Color;", "getForeground", "Thumb", "intellij.android.preview-designer"})
@SourceDebugExtension(value={"SMAP\nTimelinePanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TimelinePanel.kt\ncom/android/tools/idea/preview/animation/TimelinePanel\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,400:1\n1#2:401\n*E\n"})
public class TimelinePanel
extends JBSlider {
    @NotNull
    private final Tooltip tooltip;
    @NotNull
    private final AnimationTracker tracker;
    private int cachedSliderWidth;
    private int cachedMax;
    private int zoomValue;
    @NotNull
    private final List<Function0<Unit>> dragEndListeners;

    public TimelinePanel(@NotNull Tooltip tooltip, @NotNull AnimationTracker tracker) {
        Intrinsics.checkNotNullParameter((Object)tooltip, (String)"tooltip");
        Intrinsics.checkNotNullParameter((Object)tracker, (String)"tracker");
        super(0, 10000, 0);
        this.tooltip = tooltip;
        this.tracker = tracker;
        this.setPaintTicks(false);
        this.setPaintLabels(true);
        this.updateMajorTicks();
        this.setUI(this.createSliderUI());
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                this.updateMajorTicks();
            }
        });
        Thumb it = new Thumb();
        boolean bl = false;
        this.add(it);
        it.resizeThumb();
        this.setComponentZOrder(it, 0);
        this.addComponentListener(it.getResizeAdapter());
        this.zoomValue = 1;
        this.dragEndListeners = new ArrayList();
    }

    @NotNull
    public final Tooltip getTooltip() {
        return this.tooltip;
    }

    @NotNull
    public final AnimationTracker getTracker() {
        return this.tracker;
    }

    @NotNull
    public final TimelineSliderUI getSliderUI() {
        ComponentUI componentUI = this.ui;
        Intrinsics.checkNotNull((Object)componentUI, (String)"null cannot be cast to non-null type com.android.tools.idea.preview.animation.TimelineSliderUI");
        return (TimelineSliderUI)componentUI;
    }

    public final void scale(int z) {
        this.zoomValue = z;
    }

    @NotNull
    public final List<Function0<Unit>> getDragEndListeners() {
        return this.dragEndListeners;
    }

    @NotNull
    public TimelineSliderUI createSliderUI() {
        return new TimelineSliderUI(this);
    }

    public void updateUI() {
        this.updateLabelUIs();
    }

    public void setMaximum(int maximum) {
        super.setMaximum(maximum);
        this.updateMajorTicks();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Dimension getPreferredSize() {
        int n;
        Iterable iterable = this.getSliderUI().getElements();
        int n2 = InspectorLayout.INSTANCE.timelineHeaderHeightScaled();
        int n3 = this.zoomValue * this.getWidth() - 50;
        int n4 = 0;
        for (Object t : iterable) {
            void it;
            TimelineElement timelineElement = (TimelineElement)t;
            n = n4;
            boolean bl = false;
            int n5 = it.heightScaled();
            n4 = n + n5;
        }
        n = n4;
        int n6 = n2 + n;
        int n7 = n3;
        return new Dimension(n7, n6);
    }

    @NotNull
    public Font getFont() {
        Font font = UIUtil.getFont((UIUtil.FontSize)UIUtil.FontSize.SMALL, null);
        Intrinsics.checkNotNullExpressionValue((Object)font, (String)"getFont(...)");
        return font;
    }

    private final void updateMajorTicks() {
        if (this.getWidth() == this.cachedSliderWidth && this.getMaximum() == this.cachedMax) {
            return;
        }
        this.cachedSliderWidth = this.getWidth();
        this.cachedMax = this.getMaximum();
        int tickIncrement = InspectorPainter.Slider.getTickIncrement$default(InspectorPainter.Slider.INSTANCE, (JSlider)((Object)this), 0, 2, null);
        this.setMajorTickSpacing(tickIncrement);
        this.setLabelTable(tickIncrement == 0 ? this.getLabelTable() : (Dictionary)this.createStandardLabels(tickIncrement));
    }

    @Nullable
    public Color getBackground() {
        Object object = UIManager.get("Slider.background");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type java.awt.Color");
        return (Color)object;
    }

    @Nullable
    public Color getForeground() {
        Object object = UIManager.get("Slider.foreground");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type java.awt.Color");
        return (Color)object;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0014J\u0006\u0010\b\u001a\u00020\u0005R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lcom/android/tools/idea/preview/animation/TimelinePanel$Thumb;", "Ljavax/swing/JPanel;", "<init>", "(Lcom/android/tools/idea/preview/animation/TimelinePanel;)V", "paintComponent", "", "g", "Ljava/awt/Graphics;", "resizeThumb", "resizeAdapter", "Ljava/awt/event/ComponentAdapter;", "getResizeAdapter", "()Ljava/awt/event/ComponentAdapter;", "intellij.android.preview-designer"})
    public final class Thumb
    extends JPanel {
        @NotNull
        private final ComponentAdapter resizeAdapter = new ComponentAdapter(this){
            final /* synthetic */ Thumb this$0;
            {
                this.this$0 = $receiver;
            }

            public void componentResized(ComponentEvent e) {
                this.this$0.resizeThumb();
            }
        };

        public Thumb() {
            this.setBackground(UIUtil.TRANSPARENT_COLOR);
            this.setBorder((Border)new JBEmptyBorder(0));
            this.setOpaque(false);
        }

        @Override
        protected void paintComponent(@Nullable Graphics g) {
            super.paintComponent(g);
            Intrinsics.checkNotNull((Object)g, (String)"null cannot be cast to non-null type java.awt.Graphics2D");
            InspectorPainter.Thumb.INSTANCE.paintThumbForHorizSlider((Graphics2D)g, ((Rectangle)TimelinePanel.this.getSliderUI().getPanelThumbRect().invoke()).x + ((Rectangle)TimelinePanel.this.getSliderUI().getPanelThumbRect().invoke()).width / 2, InspectorLayout.INSTANCE.timelineHeaderHeightScaled(), ((Rectangle)TimelinePanel.this.getSliderUI().getPanelThumbRect().invoke()).height);
        }

        public final void resizeThumb() {
            this.setSize(new Dimension(TimelinePanel.this.getWidth(), TimelinePanel.this.getHeight()));
            this.setLocation(new Point(0, 0));
        }

        @NotNull
        public final ComponentAdapter getResizeAdapter() {
            return this.resizeAdapter;
        }
    }
}

