/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.preview.analytics;

import com.android.tools.idea.common.layout.SurfaceLayoutOption;
import com.android.tools.idea.preview.analytics.PreviewCanvasTracker;
import com.android.tools.idea.preview.analytics.PreviewCanvasTrackerKt;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.ComposePreviewCanvasEvent;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/android/tools/idea/preview/analytics/PreviewCanvasTrackerImpl;", "Lcom/android/tools/idea/preview/analytics/PreviewCanvasTracker;", "myExecutor", "Ljava/util/concurrent/Executor;", "myEventLogger", "Ljava/util/function/Consumer;", "Lcom/google/wireless/android/sdk/stats/AndroidStudioEvent$Builder;", "<init>", "(Ljava/util/concurrent/Executor;Ljava/util/function/Consumer;)V", "logSwitchLayout", "", "layoutType", "Lcom/android/tools/idea/common/layout/SurfaceLayoutOption$LayoutType;", "intellij.android.preview-designer"})
public final class PreviewCanvasTrackerImpl
implements PreviewCanvasTracker {
    @NotNull
    private final Executor myExecutor;
    @NotNull
    private final Consumer<AndroidStudioEvent.Builder> myEventLogger;

    public PreviewCanvasTrackerImpl(@NotNull Executor myExecutor, @NotNull Consumer<AndroidStudioEvent.Builder> myEventLogger) {
        Intrinsics.checkNotNullParameter((Object)myExecutor, (String)"myExecutor");
        Intrinsics.checkNotNullParameter(myEventLogger, (String)"myEventLogger");
        this.myExecutor = myExecutor;
        this.myEventLogger = myEventLogger;
    }

    @Override
    public void logSwitchLayout(@NotNull SurfaceLayoutOption.LayoutType layoutType) {
        Intrinsics.checkNotNullParameter((Object)((Object)layoutType), (String)"layoutType");
        try {
            ComposePreviewCanvasEvent.LayoutName layoutName = switch (WhenMappings.$EnumSwitchMapping$0[layoutType.ordinal()]) {
                case 1 -> ComposePreviewCanvasEvent.LayoutName.GALLERY;
                case 2 -> ComposePreviewCanvasEvent.LayoutName.LIST;
                case 3 -> ComposePreviewCanvasEvent.LayoutName.ORGANIZATION_GRID;
                case 4 -> ComposePreviewCanvasEvent.LayoutName.UNKNOWN_LAYOUT_NAME;
                default -> throw new NoWhenBranchMatchedException();
            };
            this.myExecutor.execute(() -> PreviewCanvasTrackerImpl.logSwitchLayout$lambda$0(layoutName, this));
        }
        catch (RejectedExecutionException e) {
            PreviewCanvasTrackerKt.access$getLOG().debug("Failed to report compose preview canvas metrics", (Throwable)e);
        }
    }

    private static final void logSwitchLayout$lambda$0(ComposePreviewCanvasEvent.LayoutName $layoutName, PreviewCanvasTrackerImpl this$0) {
        ComposePreviewCanvasEvent event = ComposePreviewCanvasEvent.newBuilder().setEventType(ComposePreviewCanvasEvent.EventType.SELECT_LAYOUT).setLayoutName($layoutName).build();
        AndroidStudioEvent.Builder studioEvent = AndroidStudioEvent.newBuilder().setKind(AndroidStudioEvent.EventKind.COMPOSE_PREVIEW_CANVAS_EVENT).setComposePreviewCanvasEvent(event);
        this$0.myEventLogger.accept(studioEvent);
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SurfaceLayoutOption.LayoutType.values().length];
            try {
                nArray[SurfaceLayoutOption.LayoutType.Focus.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SurfaceLayoutOption.LayoutType.SingleDirection.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SurfaceLayoutOption.LayoutType.OrganizationGrid.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SurfaceLayoutOption.LayoutType.Default.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

