/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.preview.analytics;

import com.android.tools.idea.preview.analytics.InteractivePreviewUsageTracker;
import com.android.tools.idea.preview.analytics.InteractivePreviewUsageTrackerKt;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.InteractivePreviewEvent;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\fH\u0016J\u0018\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\fH\u0016J$\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u00142\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\n0\u0016H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/android/tools/idea/preview/analytics/InteractivePreviewUsageTrackerImpl;", "Lcom/android/tools/idea/preview/analytics/InteractivePreviewUsageTracker;", "myExecutor", "Ljava/util/concurrent/Executor;", "myEventLogger", "Ljava/util/function/Consumer;", "Lcom/google/wireless/android/sdk/stats/AndroidStudioEvent$Builder;", "<init>", "(Ljava/util/concurrent/Executor;Ljava/util/function/Consumer;)V", "logInteractiveSession", "", "fps", "", "durationMs", "userInteractions", "logStartupTime", "timeMs", "peers", "logInteractiveEvent", "type", "Lcom/google/wireless/android/sdk/stats/InteractivePreviewEvent$InteractivePreviewEventType;", "consumer", "Lkotlin/Function1;", "Lcom/google/wireless/android/sdk/stats/InteractivePreviewEvent$Builder;", "intellij.android.preview-designer"})
public final class InteractivePreviewUsageTrackerImpl
implements InteractivePreviewUsageTracker {
    @NotNull
    private final Executor myExecutor;
    @NotNull
    private final Consumer<AndroidStudioEvent.Builder> myEventLogger;

    public InteractivePreviewUsageTrackerImpl(@NotNull Executor myExecutor, @NotNull Consumer<AndroidStudioEvent.Builder> myEventLogger) {
        Intrinsics.checkNotNullParameter((Object)myExecutor, (String)"myExecutor");
        Intrinsics.checkNotNullParameter(myEventLogger, (String)"myEventLogger");
        this.myExecutor = myExecutor;
        this.myEventLogger = myEventLogger;
    }

    @Override
    public void logInteractiveSession(int fps, int durationMs, int userInteractions) {
        this.logInteractiveEvent(InteractivePreviewEvent.InteractivePreviewEventType.REPORT_FPS, (Function1<? super InteractivePreviewEvent.Builder, Unit>)((Function1)arg_0 -> InteractivePreviewUsageTrackerImpl.logInteractiveSession$lambda$0(fps, durationMs, userInteractions, arg_0)));
    }

    @Override
    public void logStartupTime(int timeMs, int peers) {
        this.logInteractiveEvent(InteractivePreviewEvent.InteractivePreviewEventType.REPORT_STARTUP_TIME, (Function1<? super InteractivePreviewEvent.Builder, Unit>)((Function1)arg_0 -> InteractivePreviewUsageTrackerImpl.logStartupTime$lambda$0(timeMs, peers, arg_0)));
    }

    private final void logInteractiveEvent(InteractivePreviewEvent.InteractivePreviewEventType type, Function1<? super InteractivePreviewEvent.Builder, Unit> consumer) {
        try {
            this.myExecutor.execute(() -> InteractivePreviewUsageTrackerImpl.logInteractiveEvent$lambda$0(type, consumer, this));
        }
        catch (RejectedExecutionException e) {
            InteractivePreviewUsageTrackerKt.access$getLOG().debug("Failed to report interactive preview metrics", (Throwable)e);
        }
    }

    private static final Unit logInteractiveSession$lambda$0(int $fps, int $durationMs, int $userInteractions, InteractivePreviewEvent.Builder it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.setFps($fps);
        it.setDurationMs($durationMs);
        it.setActions($userInteractions);
        return Unit.INSTANCE;
    }

    private static final Unit logStartupTime$lambda$0(int $timeMs, int $peers, InteractivePreviewEvent.Builder it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.setStartupTimeMs($timeMs);
        it.setPeerPreviews($peers);
        return Unit.INSTANCE;
    }

    private static final void logInteractiveEvent$lambda$0(InteractivePreviewEvent.InteractivePreviewEventType $type, Function1 $consumer, InteractivePreviewUsageTrackerImpl this$0) {
        InteractivePreviewEvent.Builder builder = InteractivePreviewEvent.newBuilder().setType($type);
        Intrinsics.checkNotNull((Object)builder);
        $consumer.invoke((Object)builder);
        AndroidStudioEvent.Builder event = AndroidStudioEvent.newBuilder().setKind(AndroidStudioEvent.EventKind.INTERACTIVE_PREVIEW_EVENT).setInteractivePreviewEvent(builder.build());
        this$0.myEventLogger.accept(event);
    }
}

