/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.preview;

import com.android.tools.compile.fast.CompilationResult;
import com.android.tools.idea.editors.fast.FastPreviewManager;
import com.android.tools.idea.preview.essentials.PreviewEssentialsModeManager;
import com.android.tools.idea.rendering.BuildListener;
import com.android.tools.idea.rendering.BuildListenerKt;
import com.android.tools.idea.rendering.BuildTargetReference;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPsiElementPointer;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.android.uipreview.ModuleClassLoaderOverlays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\t\u0010\nJ<\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u000e\b\u0002\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00030\u00052\u000e\b\u0002\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005J\u001a\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u00032\b\b\u0002\u0010\u001c\u001a\u00020\u0003H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000b\u001a\u00070\f\u00a2\u0006\u0002\b\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u000f\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u00038\u0006@BX\u0087\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001d"}, d2={"Lcom/android/tools/idea/preview/PreviewBuildListenersManager;", "", "isFastPreviewSupported", "", "invalidate", "Lkotlin/Function0;", "", "refresh", "requestVisibilityAndNotificationsUpdate", "<init>", "(ZLkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;)V", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "value", "buildListenerSetupFinished", "getBuildListenerSetupFinished", "()Z", "setupPreviewBuildListeners", "disposable", "Lcom/intellij/openapi/Disposable;", "psiFilePointer", "Lcom/intellij/psi/SmartPsiElementPointer;", "Lcom/intellij/psi/PsiFile;", "shouldRefreshAfterBuildFailed", "onBuildStarted", "afterBuildComplete", "isSuccessful", "refreshOnFail", "intellij.android.preview-designer"})
@SourceDebugExtension(value={"SMAP\nPreviewBuildListenersManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PreviewBuildListenersManager.kt\ncom/android/tools/idea/preview/PreviewBuildListenersManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,150:1\n1#2:151\n*E\n"})
public final class PreviewBuildListenersManager {
    private final boolean isFastPreviewSupported;
    @NotNull
    private final Function0<Unit> invalidate;
    @NotNull
    private final Function0<Unit> refresh;
    @NotNull
    private final Function0<Unit> requestVisibilityAndNotificationsUpdate;
    @NotNull
    private final Logger log;
    @VisibleForTesting
    private boolean buildListenerSetupFinished;

    public PreviewBuildListenersManager(boolean isFastPreviewSupported, @NotNull Function0<Unit> invalidate, @NotNull Function0<Unit> refresh2, @NotNull Function0<Unit> requestVisibilityAndNotificationsUpdate2) {
        Intrinsics.checkNotNullParameter(invalidate, (String)"invalidate");
        Intrinsics.checkNotNullParameter(refresh2, (String)"refresh");
        Intrinsics.checkNotNullParameter(requestVisibilityAndNotificationsUpdate2, (String)"requestVisibilityAndNotificationsUpdate");
        this.isFastPreviewSupported = isFastPreviewSupported;
        this.invalidate = invalidate;
        this.refresh = refresh2;
        this.requestVisibilityAndNotificationsUpdate = requestVisibilityAndNotificationsUpdate2;
        Logger logger = Logger.getInstance(PreviewBuildListenersManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.log = logger;
    }

    public /* synthetic */ PreviewBuildListenersManager(boolean bl, Function0 function0, Function0 function02, Function0 function03, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            function03 = PreviewBuildListenersManager::_init_$lambda$0;
        }
        this(bl, (Function0<Unit>)function0, (Function0<Unit>)function02, (Function0<Unit>)function03);
    }

    public final boolean getBuildListenerSetupFinished() {
        return this.buildListenerSetupFinished;
    }

    public final void setupPreviewBuildListeners(@NotNull Disposable disposable, @NotNull SmartPsiElementPointer<PsiFile> psiFilePointer, @NotNull Function0<Boolean> shouldRefreshAfterBuildFailed, @NotNull Function0<Unit> onBuildStarted) {
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        Intrinsics.checkNotNullParameter(psiFilePointer, (String)"psiFilePointer");
        Intrinsics.checkNotNullParameter(shouldRefreshAfterBuildFailed, (String)"shouldRefreshAfterBuildFailed");
        Intrinsics.checkNotNullParameter(onBuildStarted, (String)"onBuildStarted");
        PsiFile psiFile = (PsiFile)ActionsKt.runReadAction(() -> PreviewBuildListenersManager.setupPreviewBuildListeners$lambda$2(psiFilePointer));
        if (psiFile == null) {
            boolean $i$a$-requireNotNull-PreviewBuildListenersManager$setupPreviewBuildListeners$42 = false;
            String $i$a$-requireNotNull-PreviewBuildListenersManager$setupPreviewBuildListeners$42 = "PsiFile was disposed before the preview initialization completed.";
            throw new IllegalArgumentException($i$a$-requireNotNull-PreviewBuildListenersManager$setupPreviewBuildListeners$42.toString());
        }
        BuildTargetReference buildTargetReference = BuildTargetReference.Companion.from(psiFile);
        if (buildTargetReference == null) {
            return;
        }
        BuildTargetReference buildTargetReference2 = buildTargetReference;
        BuildListenerKt.setupBuildListener((BuildTargetReference)buildTargetReference2, (BuildListener)new BuildListener(this, buildTargetReference2, shouldRefreshAfterBuildFailed, onBuildStarted){
            private boolean refreshAfterBuildFailed;
            final /* synthetic */ PreviewBuildListenersManager this$0;
            final /* synthetic */ BuildTargetReference $buildTargetReference;
            final /* synthetic */ Function0<Boolean> $shouldRefreshAfterBuildFailed;
            final /* synthetic */ Function0<Unit> $onBuildStarted;
            {
                this.this$0 = $receiver;
                this.$buildTargetReference = $buildTargetReference;
                this.$shouldRefreshAfterBuildFailed = $shouldRefreshAfterBuildFailed;
                this.$onBuildStarted = $onBuildStarted;
            }

            public void startedListening() {
                PreviewBuildListenersManager.access$setBuildListenerSetupFinished$p(this.this$0, true);
            }

            public void buildSucceeded() {
                PreviewBuildListenersManager.access$getLog$p(this.this$0).debug("buildSucceeded");
                Module module = this.$buildTargetReference.getModuleIfNotDisposed();
                if (PreviewBuildListenersManager.access$isFastPreviewSupported$p(this.this$0) && module != null) {
                    if (this.this$0.getBuildListenerSetupFinished()) {
                        ModuleClassLoaderOverlays.Companion.getInstance(this.$buildTargetReference).invalidateOverlayPaths();
                    }
                    Project project = module.getProject();
                    Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                    FastPreviewManager fastPreviewManager = FastPreviewManager.Companion.getInstance(project);
                    BuildTargetReference buildTargetReference = this.$buildTargetReference;
                    FastPreviewManager it = fastPreviewManager;
                    boolean bl = false;
                    if (it.isEnabled() && !PreviewEssentialsModeManager.INSTANCE.isEssentialsModeEnabled()) {
                        it.preStartDaemon(buildTargetReference);
                    }
                }
                PreviewBuildListenersManager.afterBuildComplete$default(this.this$0, true, false, 2, null);
            }

            public void buildFailed() {
                PreviewBuildListenersManager.access$getLog$p(this.this$0).debug("buildFailed");
                PreviewBuildListenersManager.access$afterBuildComplete(this.this$0, false, this.refreshAfterBuildFailed);
            }

            public void buildCleaned() {
                PreviewBuildListenersManager.access$getLog$p(this.this$0).debug("buildCleaned");
                this.buildFailed();
            }

            public void buildStarted() {
                PreviewBuildListenersManager.access$getLog$p(this.this$0).debug("buildStarted");
                this.refreshAfterBuildFailed = (Boolean)this.$shouldRefreshAfterBuildFailed.invoke();
                this.$onBuildStarted.invoke();
            }
        }, (Disposable)disposable);
        if (this.isFastPreviewSupported) {
            Project project = psiFile.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            FastPreviewManager.Companion.getInstance(project).addListener(disposable, new FastPreviewManager.Companion.FastPreviewManagerListener(psiFile, onBuildStarted, this){
                final /* synthetic */ PsiFile $psiFile;
                final /* synthetic */ Function0<Unit> $onBuildStarted;
                final /* synthetic */ PreviewBuildListenersManager this$0;
                {
                    this.$psiFile = $psiFile;
                    this.$onBuildStarted = $onBuildStarted;
                    this.this$0 = $receiver;
                }

                public void onCompilationStarted(Collection<? extends PsiFile> files) {
                    boolean bl;
                    Function0<Unit> function0;
                    block4: {
                        Intrinsics.checkNotNullParameter(files, (String)"files");
                        PsiFile psiFile = this.$psiFile;
                        function0 = this.$onBuildStarted;
                        PsiFile editorFile = psiFile;
                        boolean bl2 = false;
                        Iterable $this$any$iv = files;
                        boolean $i$f$any = false;
                        if (((Collection)$this$any$iv).isEmpty()) {
                            bl = false;
                        } else {
                            for (T element$iv : $this$any$iv) {
                                PsiFile it = (PsiFile)element$iv;
                                boolean bl3 = false;
                                if (!it.isEquivalentTo((PsiElement)editorFile)) continue;
                                bl = true;
                                break block4;
                            }
                            bl = false;
                        }
                    }
                    if (bl) {
                        function0.invoke();
                    }
                }

                public void onCompilationComplete(CompilationResult result, Collection<? extends PsiFile> files) {
                    Intrinsics.checkNotNullParameter((Object)result, (String)"result");
                    Intrinsics.checkNotNullParameter(files, (String)"files");
                    PreviewBuildListenersManager.afterBuildComplete$default(this.this$0, Intrinsics.areEqual((Object)result, (Object)CompilationResult.Success.INSTANCE), false, 2, null);
                }
            });
        }
    }

    public static /* synthetic */ void setupPreviewBuildListeners$default(PreviewBuildListenersManager previewBuildListenersManager2, Disposable disposable, SmartPsiElementPointer smartPsiElementPointer, Function0 function0, Function0 function02, int n, Object object) {
        if ((n & 4) != 0) {
            function0 = PreviewBuildListenersManager::setupPreviewBuildListeners$lambda$0;
        }
        if ((n & 8) != 0) {
            function02 = PreviewBuildListenersManager::setupPreviewBuildListeners$lambda$1;
        }
        previewBuildListenersManager2.setupPreviewBuildListeners(disposable, (SmartPsiElementPointer<PsiFile>)smartPsiElementPointer, (Function0<Boolean>)function0, (Function0<Unit>)function02);
    }

    private final void afterBuildComplete(boolean isSuccessful, boolean refreshOnFail) {
        if (isSuccessful) {
            this.invalidate.invoke();
            this.refresh.invoke();
        } else {
            this.requestVisibilityAndNotificationsUpdate.invoke();
            if (refreshOnFail) {
                this.refresh.invoke();
            }
        }
    }

    static /* synthetic */ void afterBuildComplete$default(PreviewBuildListenersManager previewBuildListenersManager2, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 2) != 0) {
            bl2 = false;
        }
        previewBuildListenersManager2.afterBuildComplete(bl, bl2);
    }

    private static final Unit _init_$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final boolean setupPreviewBuildListeners$lambda$0() {
        return false;
    }

    private static final Unit setupPreviewBuildListeners$lambda$1() {
        return Unit.INSTANCE;
    }

    private static final PsiFile setupPreviewBuildListeners$lambda$2(SmartPsiElementPointer $psiFilePointer) {
        return (PsiFile)$psiFilePointer.getElement();
    }

    public static final /* synthetic */ void access$setBuildListenerSetupFinished$p(PreviewBuildListenersManager $this, boolean bl) {
        $this.buildListenerSetupFinished = bl;
    }

    public static final /* synthetic */ Logger access$getLog$p(PreviewBuildListenersManager $this) {
        return $this.log;
    }

    public static final /* synthetic */ boolean access$isFastPreviewSupported$p(PreviewBuildListenersManager $this) {
        return $this.isFastPreviewSupported;
    }

    public static final /* synthetic */ void access$afterBuildComplete(PreviewBuildListenersManager $this, boolean isSuccessful, boolean refreshOnFail) {
        $this.afterBuildComplete(isSuccessful, refreshOnFail);
    }
}

