/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.naveditor.surface;

import com.android.annotations.concurrency.UiThread;
import com.android.tools.adtui.actions.ZoomType;
import com.android.tools.idea.common.analytics.DesignerAnalyticsManager;
import com.android.tools.idea.common.model.Coordinates;
import com.android.tools.idea.common.model.SelectionModel;
import com.android.tools.idea.common.surface.DesignSurfaceZoomController;
import com.android.tools.idea.common.surface.SceneView;
import com.android.tools.idea.common.surface.ScenesOwner;
import com.android.tools.idea.common.surface.ZoomChange;
import com.android.tools.idea.common.surface.ZoomListener;
import com.android.tools.idea.common.surface.layout.DesignSurfaceViewport;
import com.android.tools.idea.naveditor.scene.NavSceneManager;
import java.awt.Dimension;
import java.awt.Point;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001Bc\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u0012\u000e\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0003\u0012\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00040\n\u0012\b\u0010\f\u001a\u0004\u0018\u00010\r\u0012\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0004\b\u0012\u0010\u0013J\b\u0010\u001f\u001a\u00020\u0015H\u0016J\b\u0010 \u001a\u00020!H\u0016J\b\u0010\"\u001a\u00020!H\u0002J\u0010\u0010#\u001a\u00020\u00152\u0006\u0010$\u001a\u00020\u0004H\u0002J \u0010%\u001a\u00020!2\u0006\u0010&\u001a\u00020\u00152\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020(H\u0016J\u000e\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020\u001eJ \u0010-\u001a\u00020!2\u0006\u0010.\u001a\u00020/2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020(H\u0017R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00040\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0017R\u0014\u0010\u001a\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lcom/android/tools/idea/naveditor/surface/NavDesignSurfaceZoomController;", "Lcom/android/tools/idea/common/surface/DesignSurfaceZoomController;", "surfaceSizeProvider", "Lkotlin/Function0;", "Ljava/awt/Dimension;", "viewPortProvider", "Lcom/android/tools/idea/common/surface/layout/DesignSurfaceViewport;", "sceneManager", "Lcom/android/tools/idea/naveditor/scene/NavSceneManager;", "sceneViewDimensionProvider", "Lkotlin/Function1;", "Lcom/android/tools/idea/common/surface/SceneView;", "analyticsManager", "Lcom/android/tools/idea/common/analytics/DesignerAnalyticsManager;", "navSelectionModel", "Lcom/android/tools/idea/common/model/SelectionModel;", "scenesOwner", "Lcom/android/tools/idea/common/surface/ScenesOwner;", "<init>", "(Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function1;Lcom/android/tools/idea/common/analytics/DesignerAnalyticsManager;Lcom/android/tools/idea/common/model/SelectionModel;Lcom/android/tools/idea/common/surface/ScenesOwner;)V", "minScale", "", "getMinScale", "()D", "maxScale", "getMaxScale", "viewPort", "getViewPort", "()Lcom/android/tools/idea/common/surface/layout/DesignSurfaceViewport;", "zoomListener", "Lcom/android/tools/idea/common/surface/ZoomListener;", "getFitScale", "canZoomToFit", "", "isEmpty", "getFitContentIntoWindowScale", "contentSize", "setScale", "scale", "x", "", "y", "setZoomListener", "", "listener", "zoom", "type", "Lcom/android/tools/adtui/actions/ZoomType;", "intellij.android.nav.editor"})
@SourceDebugExtension(value={"SMAP\nNavDesignSurfaceZoomController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NavDesignSurfaceZoomController.kt\ncom/android/tools/idea/naveditor/surface/NavDesignSurfaceZoomController\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,160:1\n1#2:161\n*E\n"})
public final class NavDesignSurfaceZoomController
extends DesignSurfaceZoomController {
    @NotNull
    private final Function0<Dimension> surfaceSizeProvider;
    @NotNull
    private final Function0<DesignSurfaceViewport> viewPortProvider;
    @NotNull
    private final Function0<NavSceneManager> sceneManager;
    @NotNull
    private final Function1<SceneView, Dimension> sceneViewDimensionProvider;
    @Nullable
    private ZoomListener zoomListener;

    public NavDesignSurfaceZoomController(@NotNull Function0<? extends Dimension> surfaceSizeProvider, @NotNull Function0<? extends DesignSurfaceViewport> viewPortProvider, @NotNull Function0<NavSceneManager> sceneManager, @NotNull Function1<? super SceneView, ? extends Dimension> sceneViewDimensionProvider, @Nullable DesignerAnalyticsManager analyticsManager, @Nullable SelectionModel navSelectionModel, @NotNull ScenesOwner scenesOwner) {
        Intrinsics.checkNotNullParameter(surfaceSizeProvider, (String)"surfaceSizeProvider");
        Intrinsics.checkNotNullParameter(viewPortProvider, (String)"viewPortProvider");
        Intrinsics.checkNotNullParameter(sceneManager, (String)"sceneManager");
        Intrinsics.checkNotNullParameter(sceneViewDimensionProvider, (String)"sceneViewDimensionProvider");
        Intrinsics.checkNotNullParameter((Object)scenesOwner, (String)"scenesOwner");
        super(analyticsManager, navSelectionModel, scenesOwner);
        this.surfaceSizeProvider = surfaceSizeProvider;
        this.viewPortProvider = viewPortProvider;
        this.sceneManager = sceneManager;
        this.sceneViewDimensionProvider = sceneViewDimensionProvider;
    }

    @Override
    public double getMinScale() {
        return this.isEmpty() ? 1.0 : 0.1;
    }

    @Override
    public double getMaxScale() {
        return this.isEmpty() ? 1.0 : 3.0;
    }

    private final DesignSurfaceViewport getViewPort() {
        return (DesignSurfaceViewport)this.viewPortProvider.invoke();
    }

    @Override
    public double getFitScale() {
        Object object;
        NavDesignSurfaceZoomController navDesignSurfaceZoomController;
        block3: {
            block2: {
                navDesignSurfaceZoomController = this;
                object = this.getFocusedSceneView();
                if (object == null) break block2;
                SceneView it = object;
                NavDesignSurfaceZoomController navDesignSurfaceZoomController2 = navDesignSurfaceZoomController;
                boolean bl = false;
                Dimension dimension = (Dimension)this.sceneViewDimensionProvider.invoke((Object)it);
                navDesignSurfaceZoomController = navDesignSurfaceZoomController2;
                object = dimension;
                if (dimension != null) break block3;
            }
            object = new Dimension();
        }
        return navDesignSurfaceZoomController.getFitContentIntoWindowScale((Dimension)object);
    }

    @Override
    public boolean canZoomToFit() {
        double scale;
        if (this.isEmpty()) {
            return false;
        }
        double fitScale = this.getFitScale();
        return Math.abs(fitScale - (scale = this.getScale())) > 0.005;
    }

    private final boolean isEmpty() {
        NavSceneManager sceneManager = (NavSceneManager)this.sceneManager.invoke();
        return sceneManager == null || sceneManager.isEmpty();
    }

    private final double getFitContentIntoWindowScale(Dimension contentSize) {
        Dimension surfaceSize = (Dimension)this.surfaceSizeProvider.invoke();
        int availableWidth = this.getViewPort().getExtentSize().width;
        int availableHeight = this.getViewPort().getExtentSize().height;
        if (Intrinsics.areEqual((Object)contentSize, (Object)new Dimension(0, 0))) {
            return 1.0;
        }
        if (availableHeight == 0 && availableWidth == 0) {
            return 1.0;
        }
        double scaleX = surfaceSize.width == 0 ? 1.0 : (double)availableWidth / (double)contentSize.width;
        double scaleY = surfaceSize.getSize().height == 0 ? 1.0 : (double)availableHeight / (double)contentSize.height;
        return Math.min(scaleX, Math.min(scaleY, this.getMaxScale()));
    }

    @Override
    public boolean setScale(double scale, int x, int y) {
        int newX = x;
        int newY = y;
        SceneView sceneView = this.getFocusedSceneView();
        if (sceneView == null) {
            return false;
        }
        SceneView view = sceneView;
        Point oldViewPosition = this.getViewPort().getViewPosition();
        if (newX < 0 || newY < 0) {
            newX = oldViewPosition.x + this.getViewPort().getViewportComponent().getWidth() / 2;
            newY = oldViewPosition.y + this.getViewPort().getViewportComponent().getHeight() / 2;
        }
        int androidX = Coordinates.getAndroidXDip(view, newX);
        int androidY = Coordinates.getAndroidYDip(view, newY);
        boolean ret = super.setScale(scale, newX, newY);
        int shiftedX = Coordinates.getSwingXDip(view, androidX);
        int shiftedY = Coordinates.getSwingYDip(view, androidY);
        this.getViewPort().setViewPosition(new Point(oldViewPosition.x + shiftedX - newX, oldViewPosition.y + shiftedY - newY));
        return ret;
    }

    public final void setZoomListener(@NotNull ZoomListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.zoomListener = listener2;
    }

    @Override
    @UiThread
    public boolean zoom(@NotNull ZoomType type, int x, int y) {
        boolean scaled;
        block0: {
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            scaled = super.zoom(type, x, y);
            ZoomListener zoomListener = this.zoomListener;
            if (zoomListener == null) break block0;
            zoomListener.onZoomChange(new ZoomChange(type, scaled, null, 4, null));
        }
        return scaled;
    }
}

