/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.compose.preview.navigation;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.ide.common.rendering.api.ViewInfo;
import com.android.tools.idea.common.model.Coordinates;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.surface.SceneView;
import com.android.tools.idea.compose.preview.ComposeViewInfo;
import com.android.tools.idea.compose.preview.ComposeViewInfoKt;
import com.android.tools.idea.compose.preview.ComposeViewInfoParserKt;
import com.android.tools.idea.compose.preview.SourceLocation;
import com.android.tools.idea.compose.preview.navigation.ComponentBounds;
import com.android.tools.idea.compose.preview.navigation.PreviewNavigation;
import com.android.tools.idea.compose.preview.navigation.PreviewNavigationKt;
import com.android.tools.idea.preview.navigation.AbstractPreviewNavigationHandler;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.android.tools.idea.uibuilder.surface.PreviewNavigatableWrapper;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.pom.Navigatable;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J>\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\rH\u0014J&\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\nH\u0014\u00a8\u0006\u0014"}, d2={"Lcom/android/tools/idea/compose/preview/navigation/ComposePreviewNavigationHandler;", "Lcom/android/tools/idea/preview/navigation/AbstractPreviewNavigationHandler;", "<init>", "()V", "findNavigatableComponents", "", "Lcom/android/tools/idea/uibuilder/surface/PreviewNavigatableWrapper;", "sceneView", "Lcom/android/tools/idea/common/surface/SceneView;", "hitX", "", "hitY", "requestFocus", "", "fileName", "", "shouldFindAllNavigatables", "findBoundsOfComponentsInFile", "Ljava/awt/Rectangle;", "lineNumber", "intellij.android.compose-designer"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nPreviewNavigation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PreviewNavigation.kt\ncom/android/tools/idea/compose/preview/navigation/ComposePreviewNavigationHandler\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,216:1\n61#2,5:217\n774#3:222\n865#3,2:223\n1563#3:225\n1634#3,3:226\n774#3:229\n865#3,2:230\n1563#3:232\n1634#3,3:233\n*S KotlinDebug\n*F\n+ 1 PreviewNavigation.kt\ncom/android/tools/idea/compose/preview/navigation/ComposePreviewNavigationHandler\n*L\n165#1:217,5\n182#1:222\n182#1:223,2\n184#1:225\n184#1:226,3\n212#1:229\n212#1:230,2\n213#1:232\n213#1:233,3\n*E\n"})
public final class ComposePreviewNavigationHandler
extends AbstractPreviewNavigationHandler {
    public static final int $stable = 8;

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    protected List<PreviewNavigatableWrapper> findNavigatableComponents(@NotNull SceneView sceneView, int hitX, int hitY, boolean requestFocus, @NotNull String fileName, boolean shouldFindAllNavigatables) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)sceneView, (String)"sceneView");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        int x = Coordinates.getAndroidX(sceneView, hitX);
        int y = Coordinates.getAndroidY(sceneView, hitY);
        Logger $this$debug_u24default$iv = PreviewNavigation.INSTANCE.getLOG();
        Throwable e$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            object = $this$debug_u24default$iv;
            boolean bl = false;
            object.debug("handleNavigate x=" + x + ", y=" + y, e$iv);
        }
        NlModel model = sceneView.getSceneManager().getModel();
        NlComponent nlComponent = (NlComponent)CollectionsKt.firstOrNull((List)((List)model.getTreeReader().getComponents()));
        if (nlComponent == null) {
            return CollectionsKt.emptyList();
        }
        NlComponent root = nlComponent;
        ViewInfo viewInfo = NlComponentHelperKt.getViewInfo(root);
        if (viewInfo == null) {
            return CollectionsKt.emptyList();
        }
        ViewInfo viewInfo2 = viewInfo;
        Module module = model.getModule();
        List<ComposeViewInfo> allViewInfos = ComposeViewInfoParserKt.parseViewInfo(viewInfo2, PreviewNavigation.INSTANCE.getLOG());
        if (PreviewNavigation.INSTANCE.getLOG().isDebugEnabled()) {
            PreviewNavigationKt.dumpViewInfosToLog$default(module, allViewInfos, 0, 4, null);
        }
        if (shouldFindAllNavigatables) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            ComposeViewInfo it;
            void $this$filterTo$iv$iv;
            Object $this$filter$iv;
            Iterable iterable = ComposeViewInfoKt.findAllHitsWithPoint(allViewInfos, x, y);
            boolean $i$f$filter = false;
            void var16_20 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (ComposeViewInfo)element$iv$iv;
                boolean bl = false;
                if (!(PreviewNavigationKt.access$toNavigatable(it.getSourceLocation(), module) != null)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = new Function1[]{ComposePreviewNavigationHandler::findNavigatableComponents$lambda$2, ComposePreviewNavigationHandler::findNavigatableComponents$lambda$3};
            $this$filter$iv = CollectionsKt.sortedWith((Iterable)((List)destination$iv$iv), (Comparator)ComparisonsKt.compareBy((Function1[])$this$filter$iv));
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (ComposeViewInfo)item$iv$iv;
                object = destination$iv$iv;
                boolean bl = false;
                Object name = it.getName();
                if (!StringsKt.isBlank((CharSequence)((CharSequence)name))) {
                    name = (String)name + ", ";
                }
                String string = (String)name + " " + it.getSourceLocation().getFileName() + ": " + it.getSourceLocation().getLineNumber();
                Navigatable navigatable = PreviewNavigationKt.access$toNavigatable(it.getSourceLocation(), module);
                Intrinsics.checkNotNull((Object)navigatable);
                object.add(new PreviewNavigatableWrapper(string, navigatable));
            }
            return (List)destination$iv$iv;
        }
        Navigatable navigatable = PreviewNavigationKt.findNavigatableComponentHit(module, allViewInfos, x, y, (Function1<? super SourceLocation, Boolean>)((Function1)arg_0 -> ComposePreviewNavigationHandler.findNavigatableComponents$lambda$5(requestFocus, fileName, arg_0)));
        if (navigatable != null) {
            return CollectionsKt.listOf((Object)new PreviewNavigatableWrapper("", navigatable));
        }
        return CollectionsKt.emptyList();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    protected List<Rectangle> findBoundsOfComponentsInFile(@NotNull SceneView sceneView, @NotNull String fileName, int lineNumber) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        ComponentBounds componentBounds;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)sceneView, (String)"sceneView");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Iterable iterable = PreviewNavigationKt.access$findAllBoundsOfComponentsInFile(sceneView, fileName);
        boolean $i$f$filter = false;
        void var6_6 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            componentBounds = (ComponentBounds)element$iv$iv;
            boolean bl = false;
            ComposeViewInfo viewInfo = componentBounds.component1();
            if (!(viewInfo.getSourceLocation().getLineNumber() == lineNumber)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            componentBounds = (ComponentBounds)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Rectangle rect = componentBounds.component2();
            collection.add(rect);
        }
        return (List)destination$iv$iv;
    }

    private static final Comparable findNavigatableComponents$lambda$2(ComposeViewInfo it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (Comparable)((Object)it.getSourceLocation().getFileName());
    }

    private static final Comparable findNavigatableComponents$lambda$3(ComposeViewInfo it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Integer.valueOf(it.getSourceLocation().getLineNumber());
    }

    private static final boolean findNavigatableComponents$lambda$5(boolean $requestFocus, String $fileName, SourceLocation it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return $requestFocus || Intrinsics.areEqual((Object)it.getFileName(), (Object)$fileName);
    }
}

