/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.compose.preview.analytics;

import androidx.compose.runtime.internal.StabilityInferred;
import com.google.common.hash.Hashing;
import com.google.wireless.android.sdk.stats.ComposeMultiPreviewEvent;
import com.intellij.openapi.diagnostic.Logger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\f\u001a\u00020\rJ\u0006\u0010\u000e\u001a\u00020\rJ\b\u0010\u000f\u001a\u00020\rH\u0002J\b\u0010\u0010\u001a\u00020\rH\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\u001e\u0010\u0013\u001a\u00020\u00002\u000e\u0010\u0014\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00000\u00152\u0006\u0010\u0016\u001a\u00020\u0017J\u000e\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u0017J\u000e\u0010\u001a\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\u001cJ\u0006\u0010\u001d\u001a\u00020\u001eJ\b\u0010\u001f\u001a\u00020\u0017H\u0016J\u0013\u0010 \u001a\u00020\r2\b\u0010!\u001a\u0004\u0018\u00010\u0001H\u0096\u0002R\u0013\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/android/tools/idea/compose/preview/analytics/MultiPreviewNodeInfo;", "", "type", "Lcom/google/wireless/android/sdk/stats/ComposeMultiPreviewEvent$ComposeMultiPreviewNodeInfo$NodeType;", "<init>", "(Lcom/google/wireless/android/sdk/stats/ComposeMultiPreviewEvent$ComposeMultiPreviewNodeInfo$NodeType;)V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "nodeInfoBuilder", "Lcom/google/wireless/android/sdk/stats/ComposeMultiPreviewEvent$ComposeMultiPreviewNodeInfo$Builder;", "kotlin.jvm.PlatformType", "isUseless", "", "isPreviewType", "isMultiPreviewType", "isRootComposableType", "clearCounters", "", "withChildNodes", "multiPreviewChildNodes", "", "previewChildrenCount", "", "withDepthLevel", "depthLevel", "withComposableFqn", "composableFqn", "", "build", "Lcom/google/wireless/android/sdk/stats/ComposeMultiPreviewEvent$ComposeMultiPreviewNodeInfo;", "hashCode", "equals", "other", "intellij.android.compose-designer"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nMultiPreviewUsageTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MultiPreviewUsageTracker.kt\ncom/android/tools/idea/compose/preview/analytics/MultiPreviewNodeInfo\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,235:1\n774#2:236\n865#2,2:237\n1869#2,2:239\n*S KotlinDebug\n*F\n+ 1 MultiPreviewUsageTracker.kt\ncom/android/tools/idea/compose/preview/analytics/MultiPreviewNodeInfo\n*L\n183#1:236\n183#1:237,2\n189#1:239,2\n*E\n"})
public final class MultiPreviewNodeInfo {
    @NotNull
    private final Logger LOG;
    private final ComposeMultiPreviewEvent.ComposeMultiPreviewNodeInfo.Builder nodeInfoBuilder;
    public static final int $stable = 8;

    public MultiPreviewNodeInfo(@NotNull ComposeMultiPreviewEvent.ComposeMultiPreviewNodeInfo.NodeType type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Logger logger = Logger.getInstance(MultiPreviewNodeInfo.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.LOG = logger;
        this.nodeInfoBuilder = ComposeMultiPreviewEvent.ComposeMultiPreviewNodeInfo.newBuilder().setNodeType(type);
    }

    public final boolean isUseless() {
        return this.nodeInfoBuilder.getSubtreePreviewsCount() == 0;
    }

    public final boolean isPreviewType() {
        return this.nodeInfoBuilder.getNodeType() == ComposeMultiPreviewEvent.ComposeMultiPreviewNodeInfo.NodeType.PREVIEW_NODE;
    }

    private final boolean isMultiPreviewType() {
        return this.nodeInfoBuilder.getNodeType() == ComposeMultiPreviewEvent.ComposeMultiPreviewNodeInfo.NodeType.MULTIPREVIEW_NODE;
    }

    private final boolean isRootComposableType() {
        return this.nodeInfoBuilder.getNodeType() == ComposeMultiPreviewEvent.ComposeMultiPreviewNodeInfo.NodeType.ROOT_COMPOSABLE_FUNCTION_NODE;
    }

    private final void clearCounters() {
        this.nodeInfoBuilder.clearPreviewChildsCount();
        this.nodeInfoBuilder.clearMultiPreviewChildsCount();
        this.nodeInfoBuilder.clearSubtreePreviewsCount();
        this.nodeInfoBuilder.clearSubtreeMultiPreviewsCount();
        this.nodeInfoBuilder.clearSubtreeUselessNodesCount();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final MultiPreviewNodeInfo withChildNodes(@NotNull Collection<MultiPreviewNodeInfo> multiPreviewChildNodes, int previewChildrenCount) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(multiPreviewChildNodes, (String)"multiPreviewChildNodes");
        if (!this.isMultiPreviewType() && !this.isRootComposableType()) {
            this.LOG.error("Nodes of a type different that MultiPreview and RootComposable shouldn't have child nodes");
            return this;
        }
        this.clearCounters();
        Iterable $this$filter$iv = CollectionsKt.filterNotNull((Iterable)multiPreviewChildNodes);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            MultiPreviewNodeInfo it = (MultiPreviewNodeInfo)element$iv$iv;
            boolean bl = false;
            if (!it.isMultiPreviewType()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List childNodes = (List)destination$iv$iv;
        this.nodeInfoBuilder.setPreviewChildsCount(previewChildrenCount);
        this.nodeInfoBuilder.setSubtreePreviewsCount(previewChildrenCount);
        Iterable $this$forEach$iv = childNodes;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ComposeMultiPreviewEvent.ComposeMultiPreviewNodeInfo.Builder builder;
            MultiPreviewNodeInfo it = (MultiPreviewNodeInfo)element$iv;
            boolean bl = false;
            if (!it.isUseless()) {
                builder = this.nodeInfoBuilder;
                int n = builder.getMultiPreviewChildsCount();
                builder.setMultiPreviewChildsCount(n + 1);
            }
            builder = this.nodeInfoBuilder;
            builder.setSubtreePreviewsCount(builder.getSubtreePreviewsCount() + it.nodeInfoBuilder.getSubtreePreviewsCount());
            builder = this.nodeInfoBuilder;
            builder.setSubtreeMultiPreviewsCount(builder.getSubtreeMultiPreviewsCount() + it.nodeInfoBuilder.getSubtreeMultiPreviewsCount());
            builder = this.nodeInfoBuilder;
            builder.setSubtreeUselessNodesCount(builder.getSubtreeUselessNodesCount() + it.nodeInfoBuilder.getSubtreeUselessNodesCount());
        }
        if (this.isMultiPreviewType()) {
            if (this.isUseless()) {
                var4_3 = this.nodeInfoBuilder;
                var5_4 = var4_3.getSubtreeUselessNodesCount();
                var4_3.setSubtreeUselessNodesCount(var5_4 + 1);
            } else {
                var4_3 = this.nodeInfoBuilder;
                var5_4 = var4_3.getSubtreeMultiPreviewsCount();
                var4_3.setSubtreeMultiPreviewsCount(var5_4 + 1);
            }
        }
        return this;
    }

    @NotNull
    public final MultiPreviewNodeInfo withDepthLevel(int depthLevel) {
        this.nodeInfoBuilder.setDepthLevel(depthLevel);
        return this;
    }

    @NotNull
    public final MultiPreviewNodeInfo withComposableFqn(@NotNull String composableFqn) {
        Intrinsics.checkNotNullParameter((Object)composableFqn, (String)"composableFqn");
        this.nodeInfoBuilder.setAnonymizedComposableId(Hashing.farmHashFingerprint64().newHasher().putString((CharSequence)composableFqn, Charsets.UTF_8).hash().asLong());
        return this;
    }

    @NotNull
    public final ComposeMultiPreviewEvent.ComposeMultiPreviewNodeInfo build() {
        ComposeMultiPreviewEvent.ComposeMultiPreviewNodeInfo composeMultiPreviewNodeInfo = this.nodeInfoBuilder.build();
        Intrinsics.checkNotNullExpressionValue((Object)composeMultiPreviewNodeInfo, (String)"build(...)");
        return composeMultiPreviewNodeInfo;
    }

    public int hashCode() {
        return this.nodeInfoBuilder.build().hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof MultiPreviewNodeInfo && Intrinsics.areEqual(this.getClass(), other.getClass()) && Intrinsics.areEqual((Object)this.nodeInfoBuilder.build(), (Object)((MultiPreviewNodeInfo)other).nodeInfoBuilder.build());
    }
}

