/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.surface;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.tools.adtui.stdui.GraphicsUtilKt;
import com.android.tools.idea.common.surface.MouseClickDisplayPanelKt;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002B9\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\b\u0010\u0014\u001a\u00020\u0015H\u0002J\b\u0010\u0016\u001a\u00020\u0015H\u0002J\u0010\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u000eH\u0016J\u0010\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u001bH\u0014J\b\u0010\u001c\u001a\u00020\u0015H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/android/tools/idea/common/surface/MouseClickDisplayPanel;", "Ljavax/swing/JComponent;", "Lcom/intellij/openapi/Disposable;", "parentDisposable", "durationMs", "", "decorationColor", "Ljava/awt/Color;", "startRadius", "", "endRadius", "<init>", "(Lcom/intellij/openapi/Disposable;JLjava/awt/Color;II)V", "isMouseTrackingEnabled", "", "endTimeMillis", "clickPosition", "Ljava/awt/Point;", "clickListener", "Ljava/awt/event/AWTEventListener;", "enableMouseClickDisplay", "", "disableMouseClickDisplay", "setEnabled", "enabled", "paintComponent", "g", "Ljava/awt/Graphics;", "dispose", "intellij.android.designer"})
@StabilityInferred(parameters=0)
public final class MouseClickDisplayPanel
extends JComponent
implements Disposable {
    private final long durationMs;
    @NotNull
    private final Color decorationColor;
    private final int startRadius;
    private final int endRadius;
    private boolean isMouseTrackingEnabled;
    private long endTimeMillis;
    @Nullable
    private Point clickPosition;
    @NotNull
    private final AWTEventListener clickListener;
    public static final int $stable = 8;

    @JvmOverloads
    public MouseClickDisplayPanel(@NotNull Disposable parentDisposable, long durationMs, @NotNull Color decorationColor, int startRadius, int endRadius) {
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        Intrinsics.checkNotNullParameter((Object)decorationColor, (String)"decorationColor");
        this.durationMs = durationMs;
        this.decorationColor = decorationColor;
        this.startRadius = startRadius;
        this.endRadius = endRadius;
        this.endTimeMillis = Long.MAX_VALUE;
        this.clickListener = arg_0 -> MouseClickDisplayPanel.clickListener$lambda$0(this, arg_0);
        Disposer.register((Disposable)parentDisposable, (Disposable)this);
        this.setOpaque(false);
        this.setFocusable(false);
        this.setEnabled(false);
    }

    public /* synthetic */ MouseClickDisplayPanel(Disposable disposable, long l, Color color, int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 2) != 0) {
            l = 100L;
        }
        if ((n3 & 4) != 0) {
            color = MouseClickDisplayPanelKt.access$getDEFAULT_DECORATION_COLOR$p();
        }
        if ((n3 & 8) != 0) {
            n = 10;
        }
        if ((n3 & 0x10) != 0) {
            n2 = 20;
        }
        this(disposable, l, color, n, n2);
    }

    private final void enableMouseClickDisplay() {
        if (!this.isMouseTrackingEnabled) {
            Toolkit.getDefaultToolkit().addAWTEventListener(this.clickListener, 16L);
            this.isMouseTrackingEnabled = true;
        }
    }

    private final void disableMouseClickDisplay() {
        Toolkit.getDefaultToolkit().removeAWTEventListener(this.clickListener);
        this.isMouseTrackingEnabled = false;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (enabled) {
            this.enableMouseClickDisplay();
        } else {
            this.disableMouseClickDisplay();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void paintComponent(@NotNull Graphics g) {
        block5: {
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            Point point = this.clickPosition;
            if (point == null) break block5;
            Point it = point;
            boolean bl = false;
            long animationTime = this.endTimeMillis - System.currentTimeMillis();
            if (animationTime < 0L) {
                this.clickPosition = null;
                return;
            }
            float animationPosition = (float)(this.durationMs - animationTime) / (float)this.durationMs;
            Graphics graphics = g.create();
            Intrinsics.checkNotNull((Object)graphics, (String)"null cannot be cast to non-null type java.awt.Graphics2D");
            Graphics2D g2d = (Graphics2D)graphics;
            try {
                GraphicsUtilKt.setColorAndAlpha((Graphics2D)g2d, (Color)this.decorationColor);
                int radius = this.startRadius + (int)((float)this.endRadius * animationPosition);
                g2d.fillOval(it.x - radius, it.y - radius, radius * 2, radius * 2);
            }
            finally {
                g2d.dispose();
            }
            this.repaint();
        }
    }

    public void dispose() {
        this.disableMouseClickDisplay();
    }

    @JvmOverloads
    public MouseClickDisplayPanel(@NotNull Disposable parentDisposable, long durationMs, @NotNull Color decorationColor, int startRadius) {
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        Intrinsics.checkNotNullParameter((Object)decorationColor, (String)"decorationColor");
        this(parentDisposable, durationMs, decorationColor, startRadius, 0, 16, null);
    }

    @JvmOverloads
    public MouseClickDisplayPanel(@NotNull Disposable parentDisposable, long durationMs, @NotNull Color decorationColor) {
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        Intrinsics.checkNotNullParameter((Object)decorationColor, (String)"decorationColor");
        this(parentDisposable, durationMs, decorationColor, 0, 0, 24, null);
    }

    @JvmOverloads
    public MouseClickDisplayPanel(@NotNull Disposable parentDisposable, long durationMs) {
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        this(parentDisposable, durationMs, null, 0, 0, 28, null);
    }

    @JvmOverloads
    public MouseClickDisplayPanel(@NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        this(parentDisposable, 0L, null, 0, 0, 30, null);
    }

    private static final void clickListener$lambda$0(MouseClickDisplayPanel this$0, AWTEvent it) {
        Point clickPoint;
        if (!(it instanceof MouseEvent)) {
            return;
        }
        if (((MouseEvent)it).getID() == 500 && ((MouseEvent)it).getClickCount() == 1 && this$0.isEnabled() && this$0.isVisible() && this$0.contains(clickPoint = SwingUtilities.convertPoint(((MouseEvent)it).getComponent(), ((MouseEvent)it).getPoint(), this$0))) {
            this$0.clickPosition = clickPoint;
            this$0.endTimeMillis = System.currentTimeMillis() + this$0.durationMs;
            this$0.repaint();
        }
    }
}

