/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.scene.target;

import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.scene.draw.ColorSet;
import com.android.tools.idea.common.scene.draw.DrawRegion;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.Stroke;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\"\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012H&J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H&J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u0012H&R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/android/tools/idea/common/scene/target/BasePlaceholderDrawRegion;", "Lcom/android/tools/idea/common/scene/draw/DrawRegion;", "x1", "", "y1", "x2", "y2", "<init>", "(IIII)V", "paint", "", "g", "Ljava/awt/Graphics2D;", "sceneContext", "Lcom/android/tools/idea/common/scene/SceneContext;", "getBackgroundColor", "Ljava/awt/Color;", "colorSet", "Lcom/android/tools/idea/common/scene/draw/ColorSet;", "getBorderColor", "getBorderStroke", "Ljava/awt/Stroke;", "intellij.android.designer"})
abstract class BasePlaceholderDrawRegion
extends DrawRegion {
    private final int x1;
    private final int y1;
    private final int x2;
    private final int y2;

    public BasePlaceholderDrawRegion(int x1, int y1, int x2, int y2) {
        this.x1 = x1;
        this.y1 = y1;
        this.x2 = x2;
        this.y2 = y2;
    }

    @Override
    public final void paint(@NotNull Graphics2D g, @NotNull SceneContext sceneContext) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)sceneContext, (String)"sceneContext");
        Color defColor = g.getColor();
        Stroke defStroke = g.getStroke();
        Shape defClip = g.getClip();
        g.setClip(sceneContext.getRenderableBounds());
        this.setBounds(sceneContext.getSwingXDip(this.x1), sceneContext.getSwingYDip(this.y1), sceneContext.getSwingDimensionDip(this.x2 - this.x1), sceneContext.getSwingDimensionDip(this.y2 - this.y1));
        ColorSet colorSet = sceneContext.getColorSet();
        Intrinsics.checkNotNullExpressionValue((Object)colorSet, (String)"getColorSet(...)");
        Color color = this.getBackgroundColor(colorSet);
        if (color != null) {
            Color it = color;
            boolean bl = false;
            g.setColor(it);
            g.fill(this);
        }
        ColorSet colorSet2 = sceneContext.getColorSet();
        Intrinsics.checkNotNullExpressionValue((Object)colorSet2, (String)"getColorSet(...)");
        g.setStroke(this.getBorderStroke(colorSet2));
        ColorSet colorSet3 = sceneContext.getColorSet();
        Intrinsics.checkNotNullExpressionValue((Object)colorSet3, (String)"getColorSet(...)");
        g.setColor(this.getBorderColor(colorSet3));
        g.draw(this);
        g.setColor(defColor);
        g.setStroke(defStroke);
        g.setClip(defClip);
    }

    @Nullable
    public abstract Color getBackgroundColor(@NotNull ColorSet var1);

    @NotNull
    public abstract Color getBorderColor(@NotNull ColorSet var1);

    @NotNull
    public abstract Stroke getBorderStroke(@NotNull ColorSet var1);
}

