/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.scene.draw;

import java.awt.BasicStroke;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.FlatteningPathIterator;
import java.awt.geom.GeneralPath;

public class FancyStroke
implements Stroke {
    private static final float FLATNESS = 0.1f;
    private final float mSize;
    private final float mSpacing;
    private static final float CHAIN_RATIO = 0.6f;
    float[] mPoint = new float[6];
    Stroke myBasicStroke;
    Type myType;

    public FancyStroke(Type type, float size, int spacing, float width) {
        this.myType = type;
        this.mSize = size;
        this.mSpacing = spacing;
        this.myBasicStroke = new BasicStroke(width, 1, 2);
    }

    public FancyStroke(float size, int spacing, Stroke stroke) {
        this.mSize = size;
        this.mSpacing = spacing;
        this.myBasicStroke = stroke;
    }

    @Override
    public Shape createStrokedShape(Shape shape) {
        switch (this.myType.ordinal()) {
            case 1: {
                return this.createSpring(shape);
            }
            case 0: {
                return this.createSine(shape);
            }
            case 2: {
                return this.createRope(shape);
            }
            case 3: {
                return this.createChain(shape, 2);
            }
            case 4: {
                return this.createChain(shape, 0);
            }
            case 5: {
                return this.createChain(shape, 1);
            }
        }
        return shape;
    }

    public Shape createSpring(Shape shape) {
        GeneralPath result = new GeneralPath();
        FlatteningPathIterator it = new FlatteningPathIterator(shape.getPathIterator(null), 0.1f);
        float dist = 0.0f;
        float x1 = 0.0f;
        float x2 = 0.0f;
        float y1 = 0.0f;
        float y2 = 0.0f;
        int sign = 1;
        result.reset();
        while (!it.isDone()) {
            int type = it.currentSegment(this.mPoint);
            switch (type) {
                case 0: {
                    x1 = this.mPoint[0];
                    y1 = this.mPoint[1];
                    result.moveTo(x1, y1);
                    dist = 0.0f;
                    break;
                }
                case 1: 
                case 4: {
                    x2 = x1;
                    y2 = y1;
                    x1 = this.mPoint[0];
                    y1 = this.mPoint[1];
                    float dx = x1 - x2;
                    float dy = y1 - y2;
                    float dv = (float)Math.hypot(dx, dy);
                    float rem = dist;
                    dist += dv;
                    dx /= dv;
                    dy /= dv;
                    float px = x2;
                    float py = y2;
                    while (dist > this.mSpacing) {
                        rem = 0.0f;
                        float cx = (px += dx * (this.mSpacing - rem)) - dy * this.mSize * (float)(sign *= -1);
                        float cy = (py += dy * (this.mSpacing - rem)) + dx * this.mSize * (float)sign;
                        result.lineTo(cx, cy);
                        dist -= this.mSpacing;
                    }
                    if (type != 4) break;
                    px += dx * dist;
                    py += dy * dist;
                    result.closePath();
                    break;
                }
            }
            it.next();
        }
        result.lineTo(x1, y1);
        return this.myBasicStroke.createStrokedShape(result);
    }

    public Shape createSine(Shape shape) {
        GeneralPath result = new GeneralPath();
        FlatteningPathIterator it = new FlatteningPathIterator(shape.getPathIterator(null), 0.1f);
        float dist = 0.0f;
        float x1 = 0.0f;
        float y1 = 0.0f;
        int sign = 1;
        result.reset();
        while (!it.isDone()) {
            int type = it.currentSegment(this.mPoint);
            switch (type) {
                case 0: {
                    x1 = this.mPoint[0];
                    y1 = this.mPoint[1];
                    result.moveTo(x1, y1);
                    dist = 0.0f;
                    break;
                }
                case 1: 
                case 4: {
                    float x2 = x1;
                    float y2 = y1;
                    x1 = this.mPoint[0];
                    y1 = this.mPoint[1];
                    float dx = x1 - x2;
                    float dy = y1 - y2;
                    float dv = (float)Math.hypot(dx, dy);
                    float rem = dist;
                    dist += dv;
                    dx /= dv;
                    dy /= dv;
                    float px = x2;
                    float py = y2;
                    while (dist > this.mSpacing) {
                        float lastX = px - dx * rem;
                        float lastY = py - dy * rem;
                        rem = 0.0f;
                        float cx = (px += dx * (this.mSpacing - rem)) - dy * this.mSize * (float)(sign *= -1);
                        float cy = (py += dy * (this.mSpacing - rem)) + dx * this.mSize * (float)sign;
                        float cx1 = lastX + dx * this.mSpacing / 2.0f + dy * this.mSize * (float)sign;
                        float cy1 = lastY + dy * this.mSpacing / 2.0f - dx * this.mSize * (float)sign;
                        result.curveTo(cx1, cy1, cx - dx * this.mSpacing / 2.0f, cy - dy * this.mSpacing / 2.0f, cx, cy);
                        dist -= this.mSpacing;
                    }
                    if (type != 4) break;
                    result.closePath();
                    break;
                }
            }
            it.next();
        }
        return this.myBasicStroke.createStrokedShape(result);
    }

    public Shape createRope(Shape shape) {
        GeneralPath result = new GeneralPath();
        result.reset();
        for (int flip = -1; flip < 2; flip += 2) {
            FlatteningPathIterator it = new FlatteningPathIterator(shape.getPathIterator(null), 0.1f);
            float dist = 0.0f;
            float x1 = 0.0f;
            float y1 = 0.0f;
            int sign = 1;
            while (!it.isDone()) {
                int type = it.currentSegment(this.mPoint);
                switch (type) {
                    case 0: {
                        x1 = this.mPoint[0];
                        y1 = this.mPoint[1];
                        result.moveTo(x1, y1);
                        dist = 0.0f;
                        break;
                    }
                    case 1: 
                    case 4: {
                        float x2 = x1;
                        float y2 = y1;
                        x1 = this.mPoint[0];
                        y1 = this.mPoint[1];
                        float dx = x1 - x2;
                        float dy = y1 - y2;
                        float dv = (float)Math.hypot(dx, dy);
                        float rem = dist;
                        dist += dv;
                        dx /= dv;
                        dy /= dv;
                        float px = x2;
                        float py = y2;
                        while (dist > this.mSpacing) {
                            float lastX = px - dx * rem;
                            float lastY = py - dy * rem;
                            rem = 0.0f;
                            float cx = (px += dx * (this.mSpacing - rem)) - dy * this.mSize * (float)(sign *= -1) * (float)flip;
                            float cy = (py += dy * (this.mSpacing - rem)) + dx * this.mSize * (float)sign * (float)flip;
                            float cx1 = lastX + dx * this.mSpacing / 2.0f + dy * this.mSize * (float)sign * (float)flip;
                            float cy1 = lastY + dy * this.mSpacing / 2.0f - dx * this.mSize * (float)sign * (float)flip;
                            result.curveTo(cx1, cy1, cx - dx * this.mSpacing / 2.0f, cy - dy * this.mSpacing / 2.0f, cx, cy);
                            dist -= this.mSpacing;
                        }
                        if (type != 4) break;
                        result.closePath();
                        break;
                    }
                }
                it.next();
            }
        }
        return this.myBasicStroke.createStrokedShape(result);
    }

    public Shape createChain(Shape shape, int sides) {
        GeneralPath result = new GeneralPath();
        result.reset();
        int start = sides == 1 ? 1 : -1;
        int end = sides == 0 ? 1 : 2;
        for (int flip = start; flip < end; flip += 2) {
            FlatteningPathIterator it = new FlatteningPathIterator(shape.getPathIterator(null), 0.1f);
            float dist = 0.0f;
            float x1 = 0.0f;
            float x2 = 0.0f;
            float y1 = 0.0f;
            float y2 = 0.0f;
            float dx = 0.0f;
            float dy = 0.0f;
            float px = 0.0f;
            float py = 0.0f;
            float rem = 0.0f;
            boolean link = true;
            while (!it.isDone()) {
                int type = it.currentSegment(this.mPoint);
                switch (type) {
                    case 0: {
                        x1 = this.mPoint[0];
                        y1 = this.mPoint[1];
                        result.moveTo(x1, y1);
                        dist = 0.0f;
                        break;
                    }
                    case 1: 
                    case 4: {
                        float cy1;
                        float cx1;
                        float cy;
                        float cx;
                        float sign;
                        float space;
                        float lastY;
                        float lastX;
                        x2 = x1;
                        y2 = y1;
                        x1 = this.mPoint[0];
                        y1 = this.mPoint[1];
                        dx = x1 - x2;
                        dy = y1 - y2;
                        float dv = (float)Math.hypot(dx, dy);
                        rem = dist;
                        dist += dv;
                        dx /= dv;
                        dy /= dv;
                        px = x2;
                        py = y2;
                        while (dist > this.mSpacing) {
                            lastX = px - dx * rem;
                            lastY = py - dy * rem;
                            space = link ? this.mSpacing : this.mSpacing * 0.6f;
                            rem = 0.0f;
                            link = !link;
                            sign = link ? 0.2f : 1.0f;
                            cx = (px += dx * (space - rem)) - dy * this.mSize * sign * (float)flip;
                            cy = (py += dy * (space - rem)) + dx * this.mSize * sign * (float)flip;
                            cx1 = lastX + -dy * this.mSize * sign * (float)flip;
                            cy1 = lastY + dx * this.mSize * sign * (float)flip;
                            result.curveTo(cx1, cy1, cx, cy, px, py);
                            dist -= space;
                        }
                        if (type != 4) break;
                        lastX = px - dx * rem;
                        lastY = py - dy * rem;
                        space = dist;
                        px += dx * (space - rem);
                        py += dy * (space - rem);
                        rem = 0.0f;
                        link = !link;
                        sign = link ? 0.2f : 1.0f;
                        cx = px - dy * this.mSize * sign * (float)flip;
                        cy = py + dx * this.mSize * sign * (float)flip;
                        cx1 = lastX + -dy * this.mSize * sign * (float)flip;
                        cy1 = lastY + dx * this.mSize * sign * (float)flip;
                        result.curveTo(cx1, cy1, cx, cy, px, py);
                        dist -= space;
                        result.closePath();
                        break;
                    }
                }
                it.next();
            }
            if (!((double)dist > 0.5)) continue;
            float lastX = px - dx * rem;
            float lastY = py - dy * rem;
            float space = link ? this.mSpacing : this.mSpacing * 0.6f;
            link = !link;
            float sign = link ? 0.2f : 1.0f;
            float cx = (px += dx * (space - rem)) - dy * this.mSize * sign * (float)flip;
            float cy = (py += dy * (space - rem)) + dx * this.mSize * sign * (float)flip;
            float cx1 = lastX + -dy * this.mSize * sign * (float)flip;
            float cy1 = lastY + dx * this.mSize * sign * (float)flip;
            result.curveTo(cx1, cy1, cx, cy, x1, y1);
        }
        return this.myBasicStroke.createStrokedShape(result);
    }

    public static enum Type {
        SINE,
        SPRING,
        ROPE,
        CHAIN,
        HALF_CHAIN1,
        HALF_CHAIN2;

    }
}

