/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.scene;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.SceneComponentHierarchyProvider;
import com.android.tools.idea.common.scene.SceneManager;
import com.android.tools.idea.common.scene.TemporarySceneComponent;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0006H\u0016\u00a8\u0006\u000e"}, d2={"Lcom/android/tools/idea/common/scene/DefaultSceneManagerHierarchyProvider;", "Lcom/android/tools/idea/common/scene/SceneComponentHierarchyProvider;", "<init>", "()V", "createHierarchy", "", "Lcom/android/tools/idea/common/scene/SceneComponent;", "manager", "Lcom/android/tools/idea/common/scene/SceneManager;", "component", "Lcom/android/tools/idea/common/model/NlComponent;", "syncFromNlComponent", "", "sceneComponent", "intellij.android.designer"})
@StabilityInferred(parameters=1)
public class DefaultSceneManagerHierarchyProvider
implements SceneComponentHierarchyProvider {
    public static final int $stable;

    @Override
    @NotNull
    public List<SceneComponent> createHierarchy(@NotNull SceneManager manager, @NotNull NlComponent component) {
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        SceneComponent sceneComponent = manager.getScene().getSceneComponent(component);
        if (sceneComponent == null) {
            sceneComponent = new SceneComponent(manager.getScene(), component, manager.getHitProvider(component));
        }
        SceneComponent sceneComponent2 = sceneComponent;
        List<SceneComponent> list = sceneComponent2.getChildren();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getChildren(...)");
        Set oldChildren = new HashSet(CollectionsKt.filterNotNull((Iterable)list));
        List<NlComponent> list2 = component.getChildren();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"getChildren(...)");
        for (NlComponent nlChild : CollectionsKt.filterNotNull((Iterable)list2)) {
            List<SceneComponent> children = this.createHierarchy(manager, nlChild);
            oldChildren.removeAll(CollectionsKt.toSet((Iterable)children));
            for (SceneComponent child : children) {
                child.removeFromParent();
                sceneComponent2.addChild(child);
            }
        }
        for (SceneComponent child : oldChildren) {
            if (child instanceof TemporarySceneComponent && child.getParent() == sceneComponent2 || child.getParent() != sceneComponent2) continue;
            child.removeFromParent();
        }
        return CollectionsKt.listOf((Object)sceneComponent2);
    }

    @Override
    public void syncFromNlComponent(@NotNull SceneComponent sceneComponent) {
        Intrinsics.checkNotNullParameter((Object)sceneComponent, (String)"sceneComponent");
    }
}

