/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.model;

import com.android.tools.idea.common.model.BaseSelectionModel;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.SelectionListener;
import com.android.tools.idea.util.ListenerCollection;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultSelectionModel
extends BaseSelectionModel {
    @NotNull
    private ImmutableList<NlComponent> mySelection = ImmutableList.of();
    private NlComponent myPrimary;
    private final ListenerCollection<SelectionListener> myListeners = ListenerCollection.createWithDirectExecutor();
    @Nullable
    Object mySecondarySelection;
    @Nullable
    private ImmutableList<NlComponent> myHighlightSelection = null;

    @NotNull
    public ImmutableList<NlComponent> getSelection() {
        return this.mySelection;
    }

    @Override
    @Nullable
    public NlComponent getPrimary() {
        return this.myPrimary;
    }

    @Override
    public void setSelection(@NotNull List<? extends NlComponent> components, @Nullable NlComponent primary) {
        if (this.setSelectionInternal(components, primary)) {
            this.notifySelectionChanged();
        }
    }

    private boolean setSelectionInternal(@NotNull List<? extends NlComponent> components, @Nullable NlComponent primary) {
        if (components.equals(this.mySelection)) {
            return false;
        }
        this.mySelection = ImmutableList.copyOf(components);
        this.myHighlightSelection = null;
        this.mySecondarySelection = null;
        this.myPrimary = primary;
        return true;
    }

    @Override
    public void clear() {
        if (this.mySelection.isEmpty()) {
            return;
        }
        this.mySelection = ImmutableList.of();
        this.myPrimary = null;
        this.mySecondarySelection = null;
        this.myHighlightSelection = null;
        this.notifySelectionChanged();
    }

    @Override
    public void clearSecondary() {
        if (this.mySecondarySelection == null) {
            return;
        }
        this.mySecondarySelection = null;
        this.notifySelectionChanged();
    }

    @Override
    public void toggle(@NotNull NlComponent component) {
        NlComponent newPrimary;
        ImmutableList newSelection;
        int size = this.mySelection.size();
        if (size == 0) {
            newSelection = ImmutableList.of((Object)component);
            newPrimary = component;
        } else if (this.mySelection.contains((Object)component)) {
            if (size == 1) {
                newSelection = ImmutableList.of();
                newPrimary = null;
            } else {
                newSelection = (ImmutableList)this.mySelection.stream().filter(selection -> !selection.equals(component)).collect(ImmutableList.toImmutableList());
                newPrimary = this.myPrimary == component ? null : this.myPrimary;
            }
        } else {
            ImmutableList.Builder builder = ImmutableList.builder();
            builder.addAll(this.mySelection);
            builder.add((Object)component);
            newSelection = builder.build();
            newPrimary = this.myPrimary;
        }
        this.myHighlightSelection = null;
        this.mySecondarySelection = null;
        this.setSelection((List<? extends NlComponent>)newSelection, newPrimary);
    }

    private void notifySelectionChanged() {
        this.myListeners.forEach(l -> l.selectionChanged(this, (List<NlComponent>)this.mySelection));
    }

    @Override
    public void addListener(@NotNull SelectionListener listener2) {
        this.myListeners.add((Object)listener2);
    }

    @Override
    public void removeListener(@Nullable SelectionListener listener2) {
        this.myListeners.remove((Object)listener2);
    }

    @Override
    public void setSecondarySelection(NlComponent component, Object secondary) {
        if (component == null) {
            this.mySelection = ImmutableList.of();
            this.myPrimary = null;
            this.mySecondarySelection = null;
        } else {
            this.mySecondarySelection = secondary;
            this.mySelection = ImmutableList.of((Object)component);
            this.myPrimary = component;
        }
        this.myHighlightSelection = null;
        this.notifySelectionChanged();
    }

    @Override
    @Nullable
    public Object getSecondarySelection() {
        return this.mySecondarySelection;
    }

    @Override
    public boolean isHighlighted(@NotNull NlComponent component) {
        return this.myHighlightSelection != null && this.myHighlightSelection.contains((Object)component);
    }

    @Override
    public void setHighlightSelection(@NotNull List<? extends NlComponent> highlighted, @NotNull List<? extends NlComponent> selected) {
        boolean updated = this.setSelectionInternal(selected, null);
        if (!updated && highlighted.equals(this.myHighlightSelection)) {
            return;
        }
        this.myHighlightSelection = ImmutableList.copyOf(highlighted);
        this.notifySelectionChanged();
    }
}

