/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.layout.scroller;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.tools.idea.common.layout.scroller.DesignSurfaceViewportScroller;
import com.android.tools.idea.common.surface.SceneView;
import com.android.tools.idea.common.surface.layout.DesignSurfaceViewport;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\b\u0017\u0018\u00002\u00020\u0001B_\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0016\b\u0002\u0010\n\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u00010\r0\u000b\u0012\u0016\b\u0002\u0010\u000e\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u00010\r0\u000f\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J(\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0004\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u0018H\u0002J\u0018\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\u0018H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\n\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u00010\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000e\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u00010\r0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/android/tools/idea/common/layout/scroller/ReferencePointScroller;", "Lcom/android/tools/idea/common/layout/scroller/DesignSurfaceViewportScroller;", "oldViewSize", "Ljava/awt/Dimension;", "oldScrollPosition", "Ljava/awt/Point;", "oldReferencePoint", "oldScale", "", "newScale", "oldRectangles", "", "Lcom/android/tools/idea/common/surface/SceneView;", "Ljava/awt/Rectangle;", "newRectangleProvider", "Lkotlin/Function1;", "<init>", "(Ljava/awt/Dimension;Ljava/awt/Point;Ljava/awt/Point;DDLjava/util/Map;Lkotlin/jvm/functions/Function1;)V", "scaleChange", "scroll", "", "port", "Lcom/android/tools/idea/common/surface/layout/DesignSurfaceViewport;", "getNewScrollPosition", "", "oldReference", "newReference", "maxDistance", "expectedPositionAfterZoom", "x", "y", "intellij.android.designer"})
@StabilityInferred(parameters=0)
public class ReferencePointScroller
implements DesignSurfaceViewportScroller {
    @NotNull
    private final Dimension oldViewSize;
    @NotNull
    private final Point oldScrollPosition;
    @NotNull
    private final Point oldReferencePoint;
    @NotNull
    private final Map<SceneView, Rectangle> oldRectangles;
    @NotNull
    private final Function1<SceneView, Rectangle> newRectangleProvider;
    private final double scaleChange;
    public static final int $stable = 8;

    public ReferencePointScroller(@NotNull Dimension oldViewSize, @NotNull Point oldScrollPosition, @NotNull Point oldReferencePoint, double oldScale, double newScale, @NotNull Map<SceneView, ? extends Rectangle> oldRectangles, @NotNull Function1<? super SceneView, ? extends Rectangle> newRectangleProvider) {
        Intrinsics.checkNotNullParameter((Object)oldViewSize, (String)"oldViewSize");
        Intrinsics.checkNotNullParameter((Object)oldScrollPosition, (String)"oldScrollPosition");
        Intrinsics.checkNotNullParameter((Object)oldReferencePoint, (String)"oldReferencePoint");
        Intrinsics.checkNotNullParameter(oldRectangles, (String)"oldRectangles");
        Intrinsics.checkNotNullParameter(newRectangleProvider, (String)"newRectangleProvider");
        this.oldViewSize = oldViewSize;
        this.oldScrollPosition = oldScrollPosition;
        this.oldReferencePoint = oldReferencePoint;
        this.oldRectangles = oldRectangles;
        this.newRectangleProvider = newRectangleProvider;
        this.scaleChange = newScale / Math.max(oldScale, 1.0E-6);
    }

    public /* synthetic */ ReferencePointScroller(Dimension dimension, Point point, Point point2, double d, double d2, Map map2, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x20) != 0) {
            map2 = MapsKt.emptyMap();
        }
        if ((n & 0x40) != 0) {
            function1 = 1.INSTANCE;
        }
        this(dimension, point, point2, d, d2, map2, (Function1<? super SceneView, ? extends Rectangle>)function1);
    }

    @Override
    public void scroll(@NotNull DesignSurfaceViewport port) {
        Intrinsics.checkNotNullParameter((Object)port, (String)"port");
        Dimension newViewSize = port.getViewComponent().getPreferredSize();
        if (newViewSize.width == 0 || newViewSize.height == 0) {
            return;
        }
        if (this.oldViewSize.width == 0 || this.oldViewSize.height == 0) {
            return;
        }
        Dimension portSize = port.getExtentSize();
        Point newReferencePoint = this.expectedPositionAfterZoom(this.oldReferencePoint.x, this.oldReferencePoint.y);
        int newViewPositionX = portSize.width >= newViewSize.width ? 0 : this.getNewScrollPosition(this.oldScrollPosition.x, this.oldReferencePoint.x, newReferencePoint.x, portSize.width);
        int newViewPositionY = portSize.height >= newViewSize.height ? 0 : this.getNewScrollPosition(this.oldScrollPosition.y, this.oldReferencePoint.y, newReferencePoint.y, portSize.height);
        port.setViewPosition(new Point(newViewPositionX, newViewPositionY));
    }

    private final int getNewScrollPosition(int oldScrollPosition, int oldReference, int newReference, int maxDistance) {
        int distance = RangesKt.coerceIn((int)(oldReference - oldScrollPosition), (int)0, (int)maxDistance);
        return RangesKt.coerceAtLeast((int)(newReference - distance), (int)0);
    }

    private final Point expectedPositionAfterZoom(int x, int y) {
        SceneView closestSceneView = null;
        int bestDistance = -1;
        for (Map.Entry<SceneView, Rectangle> entry : this.oldRectangles.entrySet()) {
            SceneView sceneView = entry.getKey();
            Rectangle rect = entry.getValue();
            if (rect == null) continue;
            int currentDistance = RangesKt.coerceAtLeast((int)(rect.x - x), (int)0) + RangesKt.coerceAtLeast((int)(x - (rect.x + rect.width)), (int)0) + RangesKt.coerceAtLeast((int)(rect.y - y), (int)0) + RangesKt.coerceAtLeast((int)(y - (rect.y + rect.height)), (int)0);
            if (closestSceneView != null && currentDistance >= bestDistance) continue;
            bestDistance = currentDistance;
            closestSceneView = sceneView;
        }
        if (closestSceneView == null) {
            return new Point((int)((double)x * this.scaleChange), (int)((double)y * this.scaleChange));
        }
        Rectangle oldRectangle = this.oldRectangles.get(closestSceneView);
        Rectangle newRectangle = (Rectangle)this.newRectangleProvider.invoke(closestSceneView);
        if (oldRectangle == null || newRectangle == null) {
            return new Point((int)((double)x * this.scaleChange), (int)((double)y * this.scaleChange));
        }
        int dx = (int)((double)(x - oldRectangle.x) * this.scaleChange);
        int dy = (int)((double)(y - oldRectangle.y) * this.scaleChange);
        return new Point(newRectangle.x + dx, newRectangle.y + dy);
    }
}

