/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.error;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.tools.idea.common.command.NlWriteCommandActionUtil;
import com.android.tools.idea.common.error.IssueSource;
import com.android.tools.idea.common.model.NlAttributesHolder;
import com.android.tools.idea.common.model.NlComponent;
import com.intellij.openapi.vfs.VirtualFile;
import java.lang.ref.WeakReference;
import java.util.Objects;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001c\u0010\u0015\u001a\u0004\u0018\u00010\u00102\b\u0010\u0016\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0017\u001a\u00020\u0010H\u0016J$\u0010\u0018\u001a\u00020\u00192\b\u0010\u0016\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0017\u001a\u00020\u00102\b\u0010\u001a\u001a\u0004\u0018\u00010\u0010H\u0016J\u0013\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0096\u0002J\b\u0010\u001f\u001a\u00020 H\u0016R\u001c\u0010\u0007\u001a\u0010\u0012\f\u0012\n \t*\u0004\u0018\u00010\u00040\u00040\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0013\u0010\u0003\u001a\u0004\u0018\u00010\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006!"}, d2={"Lcom/android/tools/idea/common/error/NlComponentIssueSource;", "Lcom/android/tools/idea/common/error/IssueSource;", "Lcom/android/tools/idea/common/model/NlAttributesHolder;", "component", "Lcom/android/tools/idea/common/model/NlComponent;", "<init>", "(Lcom/android/tools/idea/common/model/NlComponent;)V", "componentRef", "Ljava/lang/ref/WeakReference;", "kotlin.jvm.PlatformType", "files", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "getFiles", "()Ljava/util/Set;", "displayText", "", "getDisplayText", "()Ljava/lang/String;", "getComponent", "()Lcom/android/tools/idea/common/model/NlComponent;", "getAttribute", "namespace", "attribute", "setAttribute", "", "value", "equals", "", "other", "", "hashCode", "", "intellij.android.designer"})
@StabilityInferred(parameters=0)
public final class NlComponentIssueSource
implements IssueSource,
NlAttributesHolder {
    @NotNull
    private final WeakReference<NlComponent> componentRef;
    @NotNull
    private final Set<VirtualFile> files;
    @NotNull
    private final String displayText;
    public static final int $stable = 8;

    public NlComponentIssueSource(@NotNull NlComponent component) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        this.componentRef = new WeakReference<NlComponent>(component);
        this.files = SetsKt.setOf((Object)component.getModel().getVirtualFile());
        Object[] objectArray = new String[]{component.getModel().getDisplaySettings().getModelDisplayName().getValue(), component.getId(), "<" + component.getTagName() + ">"};
        this.displayText = CollectionsKt.joinToString$default((Iterable)CollectionsKt.listOfNotNull((Object[])objectArray), (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
    }

    @Override
    @NotNull
    public Set<VirtualFile> getFiles() {
        return this.files;
    }

    @Override
    @NotNull
    public String getDisplayText() {
        return this.displayText;
    }

    @Nullable
    public final NlComponent getComponent() {
        return (NlComponent)this.componentRef.get();
    }

    @Override
    @Nullable
    public String getAttribute(@Nullable String namespace, @NotNull String attribute) {
        Intrinsics.checkNotNullParameter((Object)attribute, (String)"attribute");
        NlComponent nlComponent = this.getComponent();
        return nlComponent != null ? nlComponent.getAttribute(namespace, attribute) : null;
    }

    @Override
    public void setAttribute(@Nullable String namespace, @NotNull String attribute, @Nullable String value) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)attribute, (String)"attribute");
            NlComponent nlComponent = this.getComponent();
            if (nlComponent == null) break block0;
            NlComponent component = nlComponent;
            boolean bl = false;
            NlWriteCommandActionUtil.run(component, "Update issue source", () -> NlComponentIssueSource.setAttribute$lambda$0$0(component, namespace, attribute, value));
        }
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof NlComponentIssueSource)) {
            return false;
        }
        NlComponent nlComponent = (NlComponent)this.componentRef.get();
        if (nlComponent == null) {
            return false;
        }
        NlComponent component = nlComponent;
        NlComponent nlComponent2 = (NlComponent)((NlComponentIssueSource)other).componentRef.get();
        if (nlComponent2 == null) {
            return false;
        }
        NlComponent otherComponent = nlComponent2;
        if (!Intrinsics.areEqual((Object)component, (Object)otherComponent)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.getFiles(), ((NlComponentIssueSource)other).getFiles())) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.getDisplayText(), (Object)((NlComponentIssueSource)other).getDisplayText());
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{this.getComponent(), this.getFiles(), this.getDisplayText()};
        return Objects.hash(objectArray);
    }

    private static final void setAttribute$lambda$0$0(NlComponent $component, String $namespace, String $attribute, String $value) {
        $component.setAttribute($namespace, $attribute, $value);
    }
}

