/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.error;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.tools.idea.common.error.DesignerCommonIssueNode;
import com.android.tools.idea.common.error.DesignerCommonIssueRoot;
import com.android.tools.idea.common.error.Issue;
import com.android.tools.idea.common.error.IssueNode;
import com.android.tools.idea.common.error.IssuedFileNode;
import com.android.tools.idea.common.error.NoFileNode;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.uibuilder.visual.visuallint.VisualLintRenderIssue;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.ui.tree.TreeVisitor;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.swing.tree.TreePath;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u001c\u0010\n\u001a\u00020\u00072\b\u0010\u000b\u001a\u0004\u0018\u00010\u00032\b\u0010\f\u001a\u0004\u0018\u00010\u0003H\u0002J\u0018\u0010\r\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\u000eH\u0002J\u0018\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\u0010H\u0002J\u0018\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/android/tools/idea/common/error/DesignerIssueNodeVisitor;", "Lcom/intellij/ui/tree/TreeVisitor;", "node", "Lcom/android/tools/idea/common/error/DesignerCommonIssueNode;", "<init>", "(Lcom/android/tools/idea/common/error/DesignerCommonIssueNode;)V", "visit", "Lcom/intellij/ui/tree/TreeVisitor$Action;", "path", "Ljavax/swing/tree/TreePath;", "compareNode", "node1", "node2", "visitIssuedFileNode", "Lcom/android/tools/idea/common/error/IssuedFileNode;", "visitNoFileNode", "Lcom/android/tools/idea/common/error/NoFileNode;", "visitIssueNode", "Lcom/android/tools/idea/common/error/IssueNode;", "createIndexString", "", "component", "Lcom/android/tools/idea/common/model/NlComponent;", "intellij.android.designer"})
@StabilityInferred(parameters=0)
public final class DesignerIssueNodeVisitor
implements TreeVisitor {
    @NotNull
    private final DesignerCommonIssueNode node;
    public static final int $stable = 8;

    public DesignerIssueNodeVisitor(@NotNull DesignerCommonIssueNode node) {
        Intrinsics.checkNotNullParameter((Object)((Object)node), (String)"node");
        this.node = node;
    }

    @NotNull
    public TreeVisitor.Action visit(@NotNull TreePath path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Object visitedNode = path.getLastPathComponent();
        return !(visitedNode instanceof DesignerCommonIssueNode) ? TreeVisitor.Action.CONTINUE : this.compareNode((DesignerCommonIssueNode)((Object)visitedNode), this.node);
    }

    private final TreeVisitor.Action compareNode(DesignerCommonIssueNode node1, DesignerCommonIssueNode node2) {
        if (node1 == null || node2 == null) {
            return node1 == null && node2 == null ? TreeVisitor.Action.INTERRUPT : TreeVisitor.Action.CONTINUE;
        }
        if (((Object)((Object)node1)).getClass() != ((Object)((Object)node2)).getClass()) {
            return TreeVisitor.Action.CONTINUE;
        }
        DesignerCommonIssueNode designerCommonIssueNode = node1;
        return designerCommonIssueNode instanceof IssuedFileNode ? this.visitIssuedFileNode((IssuedFileNode)node1, (IssuedFileNode)node2) : (designerCommonIssueNode instanceof NoFileNode ? this.visitNoFileNode((NoFileNode)node1, (NoFileNode)node2) : (designerCommonIssueNode instanceof IssueNode ? this.visitIssueNode((IssueNode)node1, (IssueNode)node2) : (designerCommonIssueNode instanceof DesignerCommonIssueRoot ? (node1 == node2 ? TreeVisitor.Action.INTERRUPT : TreeVisitor.Action.CONTINUE) : TreeVisitor.Action.CONTINUE)));
    }

    private final TreeVisitor.Action visitIssuedFileNode(IssuedFileNode node1, IssuedFileNode node2) {
        TreeVisitor.Action action2;
        if (!Intrinsics.areEqual((Object)node1.getFile(), (Object)node2.getFile())) {
            action2 = TreeVisitor.Action.CONTINUE;
        } else {
            NodeDescriptor nodeDescriptor = node1.getParentDescriptor();
            Object object = nodeDescriptor != null ? nodeDescriptor.getElement() : null;
            DesignerCommonIssueNode designerCommonIssueNode = object instanceof DesignerCommonIssueNode ? (DesignerCommonIssueNode)((Object)object) : null;
            NodeDescriptor nodeDescriptor2 = node2.getParentDescriptor();
            object = nodeDescriptor2 != null ? nodeDescriptor2.getElement() : null;
            action2 = this.compareNode(designerCommonIssueNode, object instanceof DesignerCommonIssueNode ? (DesignerCommonIssueNode)((Object)object) : null);
        }
        return action2;
    }

    private final TreeVisitor.Action visitNoFileNode(NoFileNode node1, NoFileNode node2) {
        TreeVisitor.Action action2;
        if (!Intrinsics.areEqual((Object)node1.getName(), (Object)node2.getName())) {
            action2 = TreeVisitor.Action.CONTINUE;
        } else {
            NodeDescriptor nodeDescriptor = node1.getParentDescriptor();
            Object object = nodeDescriptor != null ? nodeDescriptor.getElement() : null;
            DesignerCommonIssueNode designerCommonIssueNode = object instanceof DesignerCommonIssueNode ? (DesignerCommonIssueNode)((Object)object) : null;
            NodeDescriptor nodeDescriptor2 = node2.getParentDescriptor();
            object = nodeDescriptor2 != null ? nodeDescriptor2.getElement() : null;
            action2 = this.compareNode(designerCommonIssueNode, object instanceof DesignerCommonIssueNode ? (DesignerCommonIssueNode)((Object)object) : null);
        }
        return action2;
    }

    private final TreeVisitor.Action visitIssueNode(IssueNode node1, IssueNode node2) {
        Issue issue1 = node1.getIssue();
        Issue issue2 = node2.getIssue();
        NodeDescriptor nodeDescriptor = node1.getParentDescriptor();
        Object object = nodeDescriptor != null ? nodeDescriptor.getElement() : null;
        NodeDescriptor nodeDescriptor2 = node2.getParentDescriptor();
        TreeVisitor.Action actionAfterComparingParents = this.compareNode(object instanceof DesignerCommonIssueNode ? (DesignerCommonIssueNode)((Object)object) : null, (object = nodeDescriptor2 != null ? nodeDescriptor2.getElement() : null) instanceof DesignerCommonIssueNode ? (DesignerCommonIssueNode)((Object)object) : null);
        if (actionAfterComparingParents == TreeVisitor.Action.CONTINUE) {
            return TreeVisitor.Action.CONTINUE;
        }
        if (issue1 instanceof VisualLintRenderIssue || issue2 instanceof VisualLintRenderIssue) {
            List files2;
            if (!(issue1 instanceof VisualLintRenderIssue) || !(issue2 instanceof VisualLintRenderIssue)) {
                return TreeVisitor.Action.CONTINUE;
            }
            if (!Intrinsics.areEqual((Object)((VisualLintRenderIssue)issue1).getSummary(), (Object)((VisualLintRenderIssue)issue2).getSummary())) {
                return TreeVisitor.Action.CONTINUE;
            }
            List files1 = CollectionsKt.toList((Iterable)((VisualLintRenderIssue)issue1).getModels());
            if (!Intrinsics.areEqual((Object)files1, (Object)(files2 = CollectionsKt.toList((Iterable)((VisualLintRenderIssue)issue2).getModels())))) {
                return TreeVisitor.Action.CONTINUE;
            }
            Function1[] function1Array = new Function1[]{DesignerIssueNodeVisitor::visitIssueNode$lambda$0, DesignerIssueNodeVisitor::visitIssueNode$lambda$1, arg_0 -> DesignerIssueNodeVisitor.visitIssueNode$lambda$2(this, arg_0)};
            Comparator comparator = ComparisonsKt.compareBy((Function1[])function1Array);
            Iterator visitedNodeIterator = CollectionsKt.sortedWith((Iterable)((VisualLintRenderIssue)issue1).getComponents(), (Comparator)comparator).iterator();
            Iterator nodeIterator = CollectionsKt.sortedWith((Iterable)((VisualLintRenderIssue)issue2).getComponents(), (Comparator)comparator).iterator();
            while (visitedNodeIterator.hasNext() && nodeIterator.hasNext()) {
                if (comparator.compare(visitedNodeIterator.next(), nodeIterator.next()) == 0) continue;
                return TreeVisitor.Action.CONTINUE;
            }
            return visitedNodeIterator.hasNext() || nodeIterator.hasNext() ? TreeVisitor.Action.CONTINUE : TreeVisitor.Action.INTERRUPT;
        }
        return Intrinsics.areEqual((Object)issue1, (Object)issue2) ? TreeVisitor.Action.INTERRUPT : TreeVisitor.Action.CONTINUE;
    }

    private final String createIndexString(NlComponent component) {
        NlComponent nlComponent;
        List orders = new ArrayList();
        NlComponent current = component;
        while ((nlComponent = current) != null && (nlComponent = nlComponent.getParent()) != null) {
            NlComponent parent = nlComponent;
            int order = parent.getChildren().indexOf(current);
            orders.add(order);
            current = parent;
        }
        return CollectionsKt.joinToString$default((Iterable)CollectionsKt.reversed((Iterable)orders), (CharSequence)",", null, null, (int)0, null, null, (int)62, null);
    }

    private static final Comparable visitIssueNode$lambda$0(NlComponent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (Comparable)((Object)it.getId());
    }

    private static final Comparable visitIssueNode$lambda$1(NlComponent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (Comparable)((Object)it.getTagName());
    }

    private static final Comparable visitIssueNode$lambda$2(DesignerIssueNodeVisitor this$0, NlComponent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (Comparable)((Object)this$0.createIndexString(it));
    }
}

