/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.command;

import com.android.tools.idea.common.model.AttributesTransaction;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.uibuilder.api.ViewGroupHandler;
import com.android.tools.idea.uibuilder.handlers.ViewHandlerManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.PsiFile;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class NlWriteCommandActionUtil {
    private NlWriteCommandActionUtil() {
    }

    public static void run(@NotNull NlComponent component, @NotNull String name, @NotNull Runnable runnable) {
        NlWriteCommandActionUtil.run(Collections.singletonList(component), name, runnable);
    }

    public static void run(@NotNull List<NlComponent> components, @NotNull String name, @NotNull Runnable runnable) {
        NlWriteCommandActionUtil.run(components, name, null, runnable);
    }

    public static void run(@NotNull List<NlComponent> components, @NotNull String name, @Nullable String groupId, @NotNull Runnable runnable) {
        NlModel model = NlWriteCommandActionUtil.checkComponents(components);
        Runnable withCleanUp = () -> {
            runnable.run();
            NlWriteCommandActionUtil.cleanUp(components);
        };
        WriteCommandAction.runWriteCommandAction((Project)model.getProject(), (String)name, (String)groupId, (Runnable)withCleanUp, (PsiFile[])new PsiFile[]{model.getFile()});
    }

    public static <T> T compute(@NotNull NlComponent component, @NotNull String name, @NotNull Computable<T> computable) {
        return NlWriteCommandActionUtil.compute(Collections.singletonList(component), name, computable);
    }

    public static <T> T compute(@NotNull List<NlComponent> components, @NotNull String name, @NotNull Computable<T> computable) {
        NlModel model = NlWriteCommandActionUtil.checkComponents(components);
        Computable withCleanUp = () -> {
            Object result = computable.compute();
            NlWriteCommandActionUtil.cleanUp(components);
            return result;
        };
        return (T)WriteCommandAction.writeCommandAction((Project)model.getProject(), (PsiFile[])new PsiFile[]{model.getFile()}).withName(name).compute(() -> withCleanUp.compute());
    }

    @NotNull
    private static NlModel checkComponents(@NotNull List<NlComponent> components) {
        if (components.isEmpty()) {
            throw new IllegalArgumentException();
        }
        NlModel model = components.get(0).getModel();
        for (NlComponent component : components.subList(1, components.size())) {
            if (component.getModel() == model) continue;
            throw new IllegalArgumentException();
        }
        return model;
    }

    private static void cleanUp(@NotNull List<NlComponent> components) {
        components.forEach(component -> {
            NlWriteCommandActionUtil.cleanUpAttributes(component);
            component.getBackend().reformatAndRearrange();
        });
    }

    private static void cleanUpAttributes(@NotNull NlComponent component) {
        Project project = component.getModel().getProject();
        ViewGroupHandler handler = ViewHandlerManager.get(project).findLayoutHandler(component, true, () -> {});
        if (handler == null) {
            return;
        }
        AttributesTransaction transaction = component.startAttributeTransaction();
        handler.cleanUpAttributes(component, transaction);
        transaction.commit();
    }
}

