/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.actions;

import com.android.tools.idea.actions.DesignerDataKeys;
import com.android.tools.idea.common.actions.DesignerActionUtils;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.rendering.RenderUtils;
import com.android.tools.idea.uibuilder.surface.NlDesignSurface;
import com.android.tools.idea.uibuilder.surface.NlSupportedActions;
import com.android.tools.idea.uibuilder.surface.NlSupportedActionsKt;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import org.jetbrains.annotations.NotNull;

public class RefreshRenderAction
extends AnAction {
    private RefreshRenderAction() {
    }

    @NotNull
    public static RefreshRenderAction getInstance() {
        return (RefreshRenderAction)ActionManager.getInstance().getAction("Android.Designer.ForceRefreshPreview");
    }

    public void update(@NotNull AnActionEvent e) {
        if (DesignerActionUtils.isActionEventFromJTextField(e)) {
            e.getPresentation().setEnabled(false);
            return;
        }
        DesignSurface designSurface2 = (DesignSurface)e.getData(DesignerDataKeys.DESIGN_SURFACE);
        boolean enabled = designSurface2 != null ? !(designSurface2 instanceof NlDesignSurface) || NlSupportedActionsKt.isActionSupported(designSurface2, NlSupportedActions.REFRESH) : false;
        e.getPresentation().setEnabled(enabled);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        DesignSurface surface2 = (DesignSurface)e.getData(DesignerDataKeys.DESIGN_SURFACE);
        if (surface2 == null) {
            return;
        }
        RenderUtils.clearCache(surface2.getConfigurations());
        surface2.forceUserRequestedRefresh();
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.EDT;
    }
}

