/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.actions;

import com.android.tools.idea.actions.DesignerDataKeys;
import com.android.tools.idea.common.actions.DesignerActionUtils;
import com.android.tools.idea.common.error.Issue;
import com.android.tools.idea.common.error.IssueModel;
import com.android.tools.idea.common.error.IssuePanelService;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.uibuilder.surface.NlDesignSurface;
import com.android.tools.idea.uibuilder.surface.NlSupportedActions;
import com.android.tools.idea.uibuilder.surface.NlSupportedActionsKt;
import com.android.tools.idea.uibuilder.visual.visuallint.VisualLintRenderIssue;
import com.intellij.analysis.problemsView.toolWindow.ProblemsView;
import com.intellij.analysis.problemsView.toolWindow.ProblemsViewToolWindowUtils;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.util.IconUtil;
import icons.StudioIcons;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

public class IssueNotificationAction
extends ToggleAction {
    public static final String NO_ISSUE = "No Issue";
    public static final String SHOW_ISSUE = "Show Warnings and Errors";
    private static final String DEFAULT_TOOLTIP = "Toggle visibility of issue panel";
    @VisibleForTesting
    public static final Icon DISABLED_ICON = IconUtil.desaturate((Icon)StudioIcons.Common.ERROR_INLINE);

    @NotNull
    public static IssueNotificationAction getInstance() {
        return (IssueNotificationAction)ActionManager.getInstance().getAction("Android.Designer.IssueNotificationAction");
    }

    public void update(@NotNull AnActionEvent event) {
        if (DesignerActionUtils.isActionEventFromJTextField(event)) {
            event.getPresentation().setEnabled(false);
            return;
        }
        super.update(event);
        DesignSurface surface2 = (DesignSurface)event.getData(DesignerDataKeys.DESIGN_SURFACE);
        Presentation presentation = event.getPresentation();
        if (surface2 == null || !NlSupportedActionsKt.isActionSupported(surface2, NlSupportedActions.TOGGLE_ISSUE_PANEL)) {
            event.getPresentation().setEnabledAndVisible(false);
            presentation.setText(SHOW_ISSUE);
            presentation.setDescription(DEFAULT_TOOLTIP);
            presentation.setIcon(DISABLED_ICON);
        } else {
            event.getPresentation().setEnabledAndVisible(true);
            IssueModel issueModel = surface2.getIssueModel();
            boolean hasIssues = issueModel.hasIssues();
            List<VisualLintRenderIssue> visualLintIssues = ((NlDesignSurface)surface2).getVisualLintIssueProvider().getUnsuppressedIssues();
            if (hasIssues || !visualLintIssues.isEmpty()) {
                presentation.setDescription(SHOW_ISSUE);
                presentation.setIcon(IssueNotificationAction.getIssueTypeIcon(issueModel, visualLintIssues));
                presentation.setText(DEFAULT_TOOLTIP);
            } else {
                presentation.setDescription(NO_ISSUE);
                presentation.setIcon(DISABLED_ICON);
            }
        }
    }

    public boolean isSelected(@NotNull AnActionEvent e) {
        DesignSurface surface2 = (DesignSurface)e.getData(DesignerDataKeys.DESIGN_SURFACE);
        if (surface2 == null) {
            return false;
        }
        return IssuePanelService.getInstance(surface2.getProject()).isIssuePanelVisible();
    }

    public void setSelected(@NotNull AnActionEvent e, boolean state) {
        ToolWindow problemsWindow;
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        if (!state && (problemsWindow = ProblemsView.getToolWindow((Project)project)) != null) {
            problemsWindow.hide();
            return;
        }
        DesignSurface surface2 = (DesignSurface)e.getData(DesignerDataKeys.DESIGN_SURFACE);
        String tabId = null;
        if (surface2 instanceof NlDesignSurface) {
            tabId = ((NlDesignSurface)surface2).getVisualLintIssueProvider().getUiCheckInstanceId();
        }
        if (tabId != null) {
            ProblemsViewToolWindowUtils.INSTANCE.selectTab(project, tabId);
        } else {
            IssuePanelService issuePanelService = IssuePanelService.getInstance(project);
            issuePanelService.showSharedIssuePanel(true, null);
        }
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.EDT;
    }

    @NotNull
    private static Icon getIssueTypeIcon(@NotNull IssueModel issueModel, @NotNull List<VisualLintRenderIssue> visualLintIssues) {
        Set visualLintSeverities = visualLintIssues.stream().map(Issue::getSeverity).collect(Collectors.toSet());
        Icon icon2 = issueModel.getErrorCount() > 0 || visualLintSeverities.contains(HighlightSeverity.ERROR) ? StudioIcons.Common.ERROR_INLINE : (issueModel.getWarningCount() > 0 || visualLintSeverities.contains(HighlightSeverity.WARNING) ? StudioIcons.Common.WARNING_INLINE : (issueModel.getIssueCount() > 0 || !visualLintSeverities.isEmpty() ? StudioIcons.Common.INFO_INLINE : DISABLED_ICON));
        return icon2;
    }
}

