/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.actions;

import com.android.tools.adtui.common.AdtUiUtils;
import com.android.tools.idea.actions.DesignerDataKeys;
import com.android.tools.idea.common.editor.DesignToolsSplitEditor;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.model.SelectionModel;
import com.android.tools.idea.common.surface.DesignSurface;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.PsiNavigateUtil;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GotoComponentAction
extends DumbAwareAction {
    private final Function<Project, FileEditor> mySelectedEditorProvider;

    @VisibleForTesting
    GotoComponentAction(@NotNull Function<Project, FileEditor> selectedEditorProvider) {
        super("Go to XML");
        this.mySelectedEditorProvider = selectedEditorProvider;
    }

    public GotoComponentAction() {
        this(project -> FileEditorManager.getInstance((Project)project).getSelectedEditor());
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        ImmutableList<NlComponent> components;
        DesignToolsSplitEditor splitEditor;
        DesignSurface surface2 = (DesignSurface)e.getData(DesignerDataKeys.DESIGN_SURFACE);
        if (surface2 == null) {
            return;
        }
        InputEvent inputEvent = e.getInputEvent();
        if (inputEvent instanceof MouseEvent && (surface2.getGuiInputHandler().interceptPanInteraction((MouseEvent)inputEvent) || AdtUiUtils.isActionKeyDown((InputEvent)inputEvent))) {
            return;
        }
        FileEditor selectedEditor = this.mySelectedEditorProvider.apply(surface2.getProject());
        if (selectedEditor instanceof DesignToolsSplitEditor && (splitEditor = (DesignToolsSplitEditor)selectedEditor).isDesignMode(e)) {
            splitEditor.selectSplitMode(false);
        }
        SelectionModel selectionModel = surface2.getSelectionModel();
        NlComponent primary = selectionModel.getPrimary();
        NlModel model = (NlModel)Iterables.getFirst(surface2.getModels(), null);
        NlComponent componentToNavigate = null;
        if (primary != null) {
            componentToNavigate = primary;
        } else if (!selectionModel.getSelection().isEmpty()) {
            componentToNavigate = selectionModel.getSelection().get(0);
        } else if (model != null && !(components = model.getTreeReader().getComponents()).isEmpty()) {
            componentToNavigate = (NlComponent)components.get(0);
        }
        if (model != null && !GotoComponentAction.navigateToXml(componentToNavigate)) {
            this.switchTab(surface2, model);
        }
    }

    private static boolean navigateToXml(@Nullable NlComponent component) {
        if (component == null) {
            return false;
        }
        XmlTag tag = component.getTag();
        if (tag == null) {
            return false;
        }
        PsiNavigateUtil.navigate((PsiElement)tag);
        return true;
    }

    private void switchTab(@NotNull DesignSurface<?> surface2, @NotNull NlModel model) {
        FileEditorManager editorManager = FileEditorManager.getInstance((Project)surface2.getProject());
        editorManager.openTextEditor(new OpenFileDescriptor(model.getProject(), model.getVirtualFile(), 0), true);
    }
}

