/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.actions;

import com.android.resources.UiMode;
import com.android.sdklib.devices.Device;
import com.android.sdklib.devices.State;
import com.android.tools.adtui.actions.DropDownAction;
import com.android.tools.configurations.Configuration;
import com.android.tools.idea.actions.ConfigurationAction;
import com.android.tools.idea.actions.DesignerDataKeys;
import com.android.tools.idea.configurations.ConfigurationFileUtil;
import com.android.tools.idea.configurations.ConfigurationManager;
import com.android.tools.idea.configurations.ConfigurationMatcher;
import com.android.tools.idea.configurations.ConfigurationProjectState;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Iterables;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Toggleable;
import com.intellij.openapi.vfs.VirtualFile;
import icons.StudioIcons;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class OrientationMenuAction
extends DropDownAction {
    private final boolean myIncludeUiMode;

    public OrientationMenuAction(boolean includeUiMode) {
        super("Orientation for Preview", "Orientation for Preview", StudioIcons.LayoutEditor.Toolbar.ROTATE_BUTTON);
        this.myIncludeUiMode = includeUiMode;
    }

    public void updateActionsImmediately(@NotNull DataContext dataContext) {
        this.updateActions(dataContext);
    }

    protected boolean updateActions(@NotNull DataContext context) {
        this.removeAll();
        Collection configurations = (Collection)context.getData(DesignerDataKeys.CONFIGURATIONS);
        if (configurations == null) {
            return true;
        }
        Configuration configuration = (Configuration)Iterables.getFirst((Iterable)configurations, null);
        if (configuration != null) {
            String title;
            Device device = configuration.getCachedDevice();
            if (device != null) {
                boolean showSetOrientationOptions;
                State currentDeviceState = configuration.getDeviceState();
                boolean bl = showSetOrientationOptions = !Device.isWear((Device)device);
                if (showSetOrientationOptions) {
                    List states = device.getAllStates();
                    for (State state : states) {
                        String stateName;
                        title = stateName = state.getName();
                        VirtualFile better = ConfigurationMatcher.getBetterMatch((Configuration)configuration, null, (String)stateName, null, null);
                        if (better != null) {
                            title = ConfigurationAction.getBetterMatchLabel(stateName, better, ConfigurationFileUtil.getVirtualFile((Configuration)configuration));
                        }
                        SetDeviceStateAction action2 = new SetDeviceStateAction(title, state, state == currentDeviceState);
                        this.add(action2);
                    }
                }
            }
            if (this.myIncludeUiMode) {
                this.addSeparator();
                DefaultActionGroup uiModeGroup = new DefaultActionGroup("_UI Mode", true);
                UiMode currentUiMode = configuration.getUiMode();
                for (UiMode uiMode : UiMode.values()) {
                    title = uiMode.getShortDisplayValue();
                    boolean checked = uiMode == currentUiMode;
                    uiModeGroup.add((AnAction)new SetUiModeAction(title, uiMode, checked));
                }
                this.add((AnAction)uiModeGroup);
            }
        }
        return true;
    }

    @VisibleForTesting
    static class SetDeviceStateAction
    extends ConfigurationAction {
        @NotNull
        private final State myState;

        private SetDeviceStateAction(@NotNull String title, @NotNull State state, boolean isCurrentState) {
            super(title);
            this.myState = state;
            Toggleable.setSelected((Presentation)this.getTemplatePresentation(), (boolean)isCurrentState);
        }

        @Override
        protected void updateConfiguration(@NotNull Configuration configuration, boolean commit) {
            configuration.setDeviceState(this.myState);
            if (!Device.isWear((Device)configuration.getDevice())) {
                ConfigurationManager configManager = ConfigurationManager.getFromConfiguration((Configuration)configuration);
                ConfigurationProjectState projectState = configManager.getStateManager().getProjectState();
                projectState.setNonWearDeviceLastSelectedStateName(this.myState.getName(), this.myState.isDefaultState());
            }
        }
    }

    private static class SetUiModeAction
    extends ConfigurationAction {
        @NotNull
        private final UiMode myUiMode;

        private SetUiModeAction(@NotNull String title, @NotNull UiMode uiMode, boolean checked) {
            super(title);
            this.myUiMode = uiMode;
            Toggleable.setSelected((Presentation)this.getTemplatePresentation(), (boolean)checked);
        }

        @Override
        protected void updateConfiguration(@NotNull Configuration configuration, boolean commit) {
            configuration.setUiMode(this.myUiMode);
        }
    }
}

