/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.types.visitors;

import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.symbols.OCSymbolReference;
import com.jetbrains.cidr.lang.types.OCArrayType;
import com.jetbrains.cidr.lang.types.OCAutoType;
import com.jetbrains.cidr.lang.types.OCBlockPointerType;
import com.jetbrains.cidr.lang.types.OCBracedInitListType;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCDeferredType;
import com.jetbrains.cidr.lang.types.OCEllipsisType;
import com.jetbrains.cidr.lang.types.OCExpansionPackType;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCIdType;
import com.jetbrains.cidr.lang.types.OCIntType;
import com.jetbrains.cidr.lang.types.OCMagicType;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCRealType;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCReferenceTypeBuilder;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCStructuredBindingType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeParameterType;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import com.jetbrains.cidr.lang.types.OCVariadicType;
import com.jetbrains.cidr.lang.types.OCVoidType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeVisitor;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCTypeCloneVisitor
implements OCTypeVisitor<OCType> {
    private final boolean isShallow;
    @Nullable
    private final OCType myRootType;
    private final Boolean myForcedConst;
    private final Boolean myForcedVolatile;
    private int myDepth;

    public OCTypeCloneVisitor(boolean shallow) {
        this(shallow, null, null, null);
    }

    public OCTypeCloneVisitor(boolean shallow, @Nullable OCType rootType, @Nullable Boolean forcedConstValue, @Nullable Boolean forcedVolatileValue) {
        this.isShallow = shallow;
        this.myRootType = rootType;
        this.myForcedConst = forcedConstValue;
        this.myForcedVolatile = forcedVolatileValue;
    }

    public static OCType cloneType(OCType type, OCTypeCloneVisitor cloner) {
        OCType clone = type.accept(cloner);
        if (type.hasGuessedType()) {
            clone.attachGuessedType(type.getGuessedType());
        }
        clone.attachAliasName(type.getAliasName());
        clone.attachNullability(type.getNullability());
        return clone;
    }

    private OCType cloneKid(OCType kid) {
        if (this.isShallow || this.myDepth >= 256) {
            return kid;
        }
        ++this.myDepth;
        OCType result = kid.transformType(this);
        --this.myDepth;
        return result;
    }

    protected boolean isConstCopy(@NotNull OCType original) {
        boolean allowedToForceConst;
        if (original == null) {
            OCTypeCloneVisitor.$$$reportNull$$$0(0);
        }
        boolean bl = allowedToForceConst = this.myRootType != null && this.myRootType.getArrayElementType() == original.getArrayElementType();
        if (allowedToForceConst && this.myForcedConst != null) {
            return this.myForcedConst;
        }
        return original.isConst();
    }

    protected boolean isVolatileCopy(@NotNull OCType original) {
        if (original == null) {
            OCTypeCloneVisitor.$$$reportNull$$$0(1);
        }
        return this.myForcedVolatile != null ? this.myForcedVolatile.booleanValue() : original.isVolatile();
    }

    @Override
    public OCType visitEllipsisReferenceType(OCEllipsisType type) {
        return OCEllipsisType.instance();
    }

    @Override
    public OCType visitFunctionType(OCFunctionType type) {
        List<OCType> oldParamTypes = type.getParameterTypes(true);
        List<String> oldParamNames = type.getParameterNames(true);
        ArrayList<OCType> clonedArgs = new ArrayList<OCType>(oldParamTypes.size());
        for (OCType argumentType : oldParamTypes) {
            clonedArgs.add(this.cloneKid(argumentType));
        }
        ArrayList<String> clonedNames = oldParamNames != null ? new ArrayList<String>(oldParamNames) : null;
        return new OCFunctionType(this.cloneKid(type.getReturnType()), clonedArgs, clonedNames, this.isConstCopy(type), this.isVolatileCopy(type), type.isLValueRef(), type.isRValueRef(), type.getExceptionSpecification());
    }

    @Override
    public OCType visitMagicType(OCMagicType type) {
        if (type == OCMagicType.SEVERAL_UNRELATED_STRUCTS) {
            return type;
        }
        return new OCMagicType(type.getName(), type.getGuessedType(), false, false);
    }

    @Override
    public OCType visitObjectType(OCObjectType type) {
        OCObjectType result = new OCObjectType(type.getInterface(), type.getImplementation(), type.getAllProtocols(), type.getAugmentedProtocols(), type.getCategoryInterfaces(), type.getCategoryImplementations(), type.getSuperType(), this.isConstCopy(type), this.isVolatileCopy(type), type.isKindof());
        result.attachNullability(type.getNullability());
        return result;
    }

    @Override
    public OCType visitArrayType(OCArrayType type) {
        OCType forcedClone = type.getRefType().transformType(this);
        return new OCArrayType(forcedClone, type.getLengthSymbol(), false, false, type.getARCAttribute(), type.getSubstitution());
    }

    @Override
    public OCType visitPointerType(OCPointerType type) {
        OCType qualifier = type.getClassQualifier() != null ? this.cloneKid(type.getClassQualifier()) : null;
        OCPointerType clone = OCPointerType.to(this.cloneKid(type.getRefType()), type.getARCAttribute(), qualifier, type.getNullability(), this.isConstCopy(type), this.isVolatileCopy(type));
        clone.setLengthOrNull(type.getLengthOrNull());
        return clone;
    }

    @Override
    public OCType visitBlockPointerType(OCBlockPointerType type) {
        return OCBlockPointerType.blockPtr(this.cloneKid(type.getRefType()), type.getARCAttribute(), type.getNullability(), this.isConstCopy(type), this.isVolatileCopy(type));
    }

    @Override
    public OCType visitCppReferenceType(OCCppReferenceType type) {
        OCType inner = this.cloneKid(type.getRefType());
        boolean isConst = this.isConstCopy(type);
        boolean isVolatile = this.isVolatileCopy(type);
        return type.isRvalueRef() ? OCCppReferenceType.to(inner, true, isConst, isVolatile) : OCCppReferenceType.to(inner, false, isConst, isVolatile);
    }

    @Override
    public OCType visitIdType(OCIdType type) {
        OCIdType result = new OCIdType(type.getAllProtocols(), type.getAugmentedProtocols(), this.isConstCopy(type), this.isVolatileCopy(type));
        result.attachNullability(type.getNullability());
        return result;
    }

    @Override
    public OCType visitIntType(OCIntType type) {
        return type.cloneType(this.isConstCopy(type), this.isVolatileCopy(type));
    }

    @Override
    public OCType visitRealType(OCRealType type) {
        return type.cloneType(this.isConstCopy(type), this.isVolatileCopy(type));
    }

    @Override
    public OCType visitReferenceType(OCReferenceType type) {
        return this.cloneReferenceType(type, type.getReference());
    }

    @NotNull
    protected OCType cloneReferenceType(@NotNull OCReferenceType type, @NotNull OCSymbolReference reference) {
        if (type == null) {
            OCTypeCloneVisitor.$$$reportNull$$$0(2);
        }
        if (reference == null) {
            OCTypeCloneVisitor.$$$reportNull$$$0(3);
        }
        OCReferenceTypeBuilder resultBuilder = new OCReferenceTypeBuilder(reference);
        resultBuilder.setProtocolSubstitutionARCFromType(type);
        resultBuilder.setConstVolatile(this.isConstCopy(type), this.isVolatileCopy(type));
        resultBuilder.setFunctionParameterType(type.isFunctionParameterType());
        resultBuilder.setIsKindof(type.isKindof());
        resultBuilder.setNullability(type.getNullability());
        resultBuilder.setSubstitution(type.getSubstitution());
        OCReferenceType oCReferenceType = resultBuilder.build();
        if (oCReferenceType == null) {
            OCTypeCloneVisitor.$$$reportNull$$$0(4);
        }
        return oCReferenceType;
    }

    @Override
    public OCType visitStructType(OCStructType type) {
        return new OCStructType(type.getStructs(), type.getTypedefName(), this.isConstCopy(type), this.isVolatileCopy(type), type.getArguments());
    }

    @Override
    public OCType visitUnknownType(OCUnknownType type) {
        return OCUnknownType.INSTANCE;
    }

    @Override
    public OCType visitVoidType(OCVoidType type) {
        return OCVoidType.instance(this.isConstCopy(type), this.isVolatileCopy(type));
    }

    @Override
    public OCType visitTypeParameterType(OCTypeParameterType type) {
        return new OCTypeParameterType(type.getSymbol(), this.isConstCopy(type), this.isVolatileCopy(type));
    }

    @Override
    public OCType visitAutoType(OCAutoType type) {
        return new OCAutoType(type.getExpressionSymbol(), type.getExpressionElement(), type.getIncompleteType(), type.getSubstitution(), type.getLambdaExpression(), type.getParameterIndex(), type.needsAutoParamsResolving(), this.isConstCopy(type), this.isVolatileCopy(type), type.getTypeConstraintName());
    }

    @Override
    public OCType visitVariadicType(OCVariadicType type) {
        return new OCVariadicType(this.cloneKid(type.getUnderlyingType()));
    }

    @Override
    public OCType visitExpansionPackType(OCExpansionPackType type) {
        return new OCExpansionPackType(ContainerUtil.map(type.getExpansions(), typeArgument -> typeArgument instanceof OCType ? ((OCType)typeArgument).transformType(new OCTypeCloneVisitor(this.isShallow, (OCType)typeArgument, this.myForcedConst, this.myForcedVolatile)) : typeArgument));
    }

    @Override
    public OCType visitBracedInitListType(OCBracedInitListType type) {
        return OCBracedInitListType.INSTANCE;
    }

    @Override
    public OCType visitStructuredBindingType(OCStructuredBindingType type) {
        return new OCStructuredBindingType(type.getInitializerSymbol(), type.getInitializerElement(), type.getDeclaratorIndex(), type.isConst(), type.isVolatile(), type.isInForeachStatement());
    }

    @Override
    public OCType visitDeferredType(OCDeferredType type) {
        return type.clone(this);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/types/visitors/OCTypeCloneVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/types/visitors/OCTypeCloneVisitor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "cloneReferenceType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isConstCopy";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isVolatileCopy";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "cloneReferenceType";
                break;
            }
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }
}

