/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.search.scopes;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.AtomicNotNullLazyValue;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.DelegatingGlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.preprocessor.OCFileUtil;
import com.jetbrains.cidr.lang.preprocessor.OCImportGraph;
import com.jetbrains.cidr.lang.search.scopes.OCExplicitSourcesSearchScope;
import com.jetbrains.cidr.lang.search.scopes.ProjectSourcesScopeProvider;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTableHelper;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
public final class OCSearchScopeService {
    @NotNull
    private final Project myProject;
    @NotNull
    private final AtomicNotNullLazyValue<GlobalSearchScope> myProjectSearchScope;
    @NotNull
    private final CachedValue<Map<VirtualFile, Boolean>> myImportedHeaders;

    @NotNull
    public static OCSearchScopeService getInstance(@NotNull Project project) {
        if (project == null) {
            OCSearchScopeService.$$$reportNull$$$0(0);
        }
        OCSearchScopeService oCSearchScopeService = (OCSearchScopeService)project.getService(OCSearchScopeService.class);
        if (oCSearchScopeService == null) {
            OCSearchScopeService.$$$reportNull$$$0(1);
        }
        return oCSearchScopeService;
    }

    public OCSearchScopeService(@NotNull Project project) {
        if (project == null) {
            OCSearchScopeService.$$$reportNull$$$0(2);
        }
        this.myProject = project;
        this.myImportedHeaders = CachedValuesManager.getManager((Project)this.myProject).createCachedValue(() -> CachedValueProvider.Result.create(new ConcurrentHashMap(), this.getProjectSourcesCacheDependencies()));
        this.myProjectSearchScope = AtomicNotNullLazyValue.createValue(() -> this.createProjectSourcesScope());
    }

    @NotNull
    public GlobalSearchScope getGotoSymbolScope(boolean includeNonProjectFiles) {
        GlobalSearchScope globalSearchScope = includeNonProjectFiles ? ProjectScope.getAllScope((Project)this.myProject) : this.getProjectSourcesScope();
        if (globalSearchScope == null) {
            OCSearchScopeService.$$$reportNull$$$0(3);
        }
        return globalSearchScope;
    }

    @NotNull
    public GlobalSearchScope getProjectSourcesScope() {
        GlobalSearchScope globalSearchScope = (GlobalSearchScope)this.myProjectSearchScope.getValue();
        if (globalSearchScope == null) {
            OCSearchScopeService.$$$reportNull$$$0(4);
        }
        return globalSearchScope;
    }

    @NotNull
    private DelegatingGlobalSearchScope createProjectSourcesScope() {
        ProjectFileIndex index = ProjectRootManager.getInstance((Project)this.myProject).getFileIndex();
        final Condition sourceCondition = file -> OCSearchScopeService.isInExplicitProjectSources(index, file);
        final Condition projectCondition = file -> OCSearchScopeService.isInProject(index, file);
        return new DelegatingGlobalSearchScope(ProjectScope.getContentScope((Project)this.myProject)){

            @NotNull
            public String getDisplayName() {
                String string = ProjectSourcesScopeProvider.SourceFilesScope.presentableName();
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            public boolean contains(@NotNull VirtualFile file) {
                if (file == null) {
                    1.$$$reportNull$$$0(1);
                }
                return (Boolean)ReadAction.compute(() -> sourceCondition.value((Object)file) || projectCondition.value((Object)file) && OCSearchScopeService.this.isImportedFromSource(file, (Condition<VirtualFile>)sourceCondition));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 2;
                    case 1 -> 3;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/cidr/lang/search/scopes/OCSearchScopeService$1";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getDisplayName";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/cidr/lang/search/scopes/OCSearchScopeService$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "contains";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalStateException(string);
                    case 1 -> new IllegalArgumentException(string);
                };
            }
        };
    }

    private boolean isImportedFromSource(@NotNull VirtualFile header, @NotNull Condition<VirtualFile> sourceCondition) {
        Map cache;
        if (header == null) {
            OCSearchScopeService.$$$reportNull$$$0(5);
        }
        if (sourceCondition == null) {
            OCSearchScopeService.$$$reportNull$$$0(6);
        }
        if (!(cache = (Map)this.myImportedHeaders.getValue()).containsKey(header)) {
            boolean imported = FileSymbolTableHelper.isSourceFile(header, this.myProject) && !OCImportGraph.getInstance(this.myProject).processIncludingFiles(header, false, true, (Processor<? super VirtualFile>)((Processor)includer -> !sourceCondition.value(includer)));
            cache.put(header, imported);
        }
        return (Boolean)cache.get(header);
    }

    @NotNull
    private Collection<?> getProjectSourcesCacheDependencies() {
        List<ModificationTracker> baseDeps = Arrays.asList(OCExplicitSourcesSearchScope.getProjectSourcesCacheDependenciesExplicitRootsOnly((Project)this.myProject));
        List list = ContainerUtil.append(baseDeps, (Object[])new ModificationTracker[]{OCImportGraph.getInstance(this.myProject).getModificationTracker()});
        if (list == null) {
            OCSearchScopeService.$$$reportNull$$$0(7);
        }
        return list;
    }

    @Contract(value="null -> false")
    public boolean isInProjectSources(@Nullable OCSymbol symbol) {
        return this.isInProjectSources((PsiElement)this.getContainingFile(symbol));
    }

    @Nullable
    private PsiFile getContainingFile(@Nullable OCSymbol symbol) {
        if (symbol == null || symbol.getKind() == OCSymbolKind.BUILTIN_SYMBOL) {
            return null;
        }
        return symbol.getContainingPsiFile(this.myProject);
    }

    @Contract(value="null->false")
    public boolean isInProjectSources(@Nullable PsiElement element) {
        return element != null && this.isInProjectSources(OCSearchScopeService.getVirtualFile(element));
    }

    public boolean isInProjectSources(@Nullable VirtualFile file) {
        return file != null && this.getProjectSourcesScope().contains(file);
    }

    private static boolean isInExplicitProjectSources(@NotNull ProjectFileIndex index, @NotNull VirtualFile file) {
        if (index == null) {
            OCSearchScopeService.$$$reportNull$$$0(8);
        }
        if (file == null) {
            OCSearchScopeService.$$$reportNull$$$0(9);
        }
        return OCExplicitSourcesSearchScope.isInExplicitProjectSources((ProjectFileIndex)index, (VirtualFile)file);
    }

    private static boolean isInProject(@NotNull ProjectFileIndex index, @NotNull VirtualFile file) {
        if (index == null) {
            OCSearchScopeService.$$$reportNull$$$0(10);
        }
        if (file == null) {
            OCSearchScopeService.$$$reportNull$$$0(11);
        }
        return index.isInContent(file) && !index.isInLibrary(file);
    }

    public boolean isInProjectNonSources(@Nullable VirtualFile file) {
        if (file == null) {
            return false;
        }
        ProjectFileIndex index = ProjectRootManager.getInstance((Project)this.myProject).getFileIndex();
        return OCSearchScopeService.isInProject(index, file) && !this.getProjectSourcesScope().contains(file);
    }

    public boolean isInProject(@Nullable VirtualFile file) {
        if (file == null) {
            return false;
        }
        ProjectFileIndex index = ProjectRootManager.getInstance((Project)this.myProject).getFileIndex();
        return OCSearchScopeService.isInProject(index, file);
    }

    @NotNull
    public GlobalSearchScope getProjectSourcesOrLibrariesScope() {
        GlobalSearchScope globalSearchScope = this.getProjectSourcesScope().uniteWith(ProjectScope.getLibrariesScope((Project)this.myProject));
        if (globalSearchScope == null) {
            OCSearchScopeService.$$$reportNull$$$0(12);
        }
        return globalSearchScope;
    }

    @Contract(value="null->false")
    public boolean isInProjectSourcesOrLibraries(@Nullable PsiElement element) {
        return element != null && this.isInProjectSourcesOrLibraries(OCSearchScopeService.getVirtualFile(element));
    }

    public boolean isInProjectSourcesOrLibraries(@Nullable VirtualFile file) {
        if (file == null) {
            return false;
        }
        return this.getProjectSourcesOrLibrariesScope().contains(file);
    }

    public boolean isInProjectSourcesOrLibraries(@Nullable OCSymbol symbol) {
        return this.isInProjectSourcesOrLibraries((PsiElement)this.getContainingFile(symbol));
    }

    @Contract(value="null -> false")
    public boolean isInLibraries(@Nullable OCSymbol symbol) {
        return this.isInLibraries((PsiElement)this.getContainingFile(symbol));
    }

    @Contract(value="null->false")
    public boolean isInLibraries(@Nullable PsiElement element) {
        VirtualFile file = OCSearchScopeService.getVirtualFile(element);
        if (file == null) {
            return false;
        }
        return this.isInLibraries(file);
    }

    public boolean isInLibraries(@NotNull VirtualFile file) {
        if (file == null) {
            OCSearchScopeService.$$$reportNull$$$0(13);
        }
        return ProjectScope.getLibrariesScope((Project)this.myProject).contains(file);
    }

    @Nullable
    private static VirtualFile getVirtualFile(@Nullable PsiElement element) {
        if (element == null || !element.isValid()) {
            return null;
        }
        PsiFile file = element.getContainingFile();
        if (file instanceof PsiCodeFragment) {
            PsiElement context = file.getContext();
            file = context == null ? null : context.getContainingFile();
        }
        return file == null ? null : OCFileUtil.getVirtualFile(file);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3, 4, 7, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/search/scopes/OCSearchScopeService";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "header";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceCondition";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "index";
                break;
            }
            case 9: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/search/scopes/OCSearchScopeService";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getGotoSymbolScope";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectSourcesScope";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectSourcesCacheDependencies";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectSourcesOrLibrariesScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 7: 
            case 12: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isImportedFromSource";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isInExplicitProjectSources";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isInProject";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isInLibraries";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3, 4, 7, 12 -> new IllegalStateException(string);
        };
    }
}

