/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.search.constructors;

import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.psi.OCCompoundInitializer;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.types.OCType;
import org.jetbrains.annotations.NotNull;

public abstract class OCBaseConstructorReference
implements PsiReference {
    @NotNull
    protected final PsiElement myElement;
    @NotNull
    protected final PsiElement myField;
    @NotNull
    protected final OCFunctionSymbol myTargetConstructor;

    public OCBaseConstructorReference(@NotNull PsiElement element, @NotNull OCCompoundInitializer compoundInitializer, @NotNull OCFunctionSymbol targetConstructor) {
        if (element == null) {
            OCBaseConstructorReference.$$$reportNull$$$0(0);
        }
        if (compoundInitializer == null) {
            OCBaseConstructorReference.$$$reportNull$$$0(1);
        }
        if (targetConstructor == null) {
            OCBaseConstructorReference.$$$reportNull$$$0(2);
        }
        this.myElement = element;
        this.myField = compoundInitializer;
        this.myTargetConstructor = targetConstructor;
    }

    public OCBaseConstructorReference(@NotNull PsiElement element, @NotNull OCSymbolDeclarator field, @NotNull OCFunctionSymbol targetConstructor) {
        if (element == null) {
            OCBaseConstructorReference.$$$reportNull$$$0(3);
        }
        if (field == null) {
            OCBaseConstructorReference.$$$reportNull$$$0(4);
        }
        if (targetConstructor == null) {
            OCBaseConstructorReference.$$$reportNull$$$0(5);
        }
        this.myElement = element;
        this.myField = field;
        this.myTargetConstructor = targetConstructor;
    }

    @NotNull
    public PsiElement getElement() {
        PsiElement psiElement = this.myElement;
        if (psiElement == null) {
            OCBaseConstructorReference.$$$reportNull$$$0(6);
        }
        return psiElement;
    }

    public PsiElement resolve() {
        return this.myTargetConstructor.locateDefinition(this.myElement.getProject());
    }

    @NotNull
    public OCFunctionSymbol getTargetConstructor() {
        OCFunctionSymbol oCFunctionSymbol = this.myTargetConstructor;
        if (oCFunctionSymbol == null) {
            OCBaseConstructorReference.$$$reportNull$$$0(7);
        }
        return oCFunctionSymbol;
    }

    @NotNull
    public PsiElement getField() {
        PsiElement psiElement = this.myField;
        if (psiElement == null) {
            OCBaseConstructorReference.$$$reportNull$$$0(8);
        }
        return psiElement;
    }

    @NotNull
    public String getCanonicalText() {
        String string = this.myElement.getText();
        if (string == null) {
            OCBaseConstructorReference.$$$reportNull$$$0(9);
        }
        return string;
    }

    public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
        if (newElementName == null) {
            OCBaseConstructorReference.$$$reportNull$$$0(10);
        }
        return null;
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            OCBaseConstructorReference.$$$reportNull$$$0(11);
        }
        return null;
    }

    public boolean isReferenceTo(@NotNull PsiElement element) {
        if (element == null) {
            OCBaseConstructorReference.$$$reportNull$$$0(12);
        }
        if (!(element instanceof OCFunctionDeclaration)) {
            return false;
        }
        OCSymbolWithQualifiedName symbol = (OCSymbolWithQualifiedName)((OCFunctionDeclaration)element).getSymbol();
        if (Comparing.equal((Object)this.myTargetConstructor, (Object)symbol)) {
            return true;
        }
        if (symbol != null && symbol.isGlobal()) {
            OCQualifiedName symbolName;
            OCResolveContext context = OCResolveContext.forPsi(element);
            OCQualifiedName thisName = this.myTargetConstructor.getResolvedQualifiedName(context);
            if (Comparing.equal((Object)thisName, (Object)(symbolName = symbol.getResolvedQualifiedName(context)))) {
                OCType symbolType;
                OCType thisResolvedType;
                return !(symbol instanceof OCFunctionSymbol) || (thisResolvedType = this.myTargetConstructor.getResolvedType(context)).equals(symbolType = symbol.getResolvedType(context), context);
            }
            return false;
        }
        return false;
    }

    public boolean isSoft() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 7, 8, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compoundInitializer";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetConstructor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/search/constructors/OCBaseConstructorReference";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElementName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/search/constructors/OCBaseConstructorReference";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getElement";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetConstructor";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getField";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "handleElementRename";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "bindToElement";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isReferenceTo";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 7, 8, 9 -> new IllegalStateException(string);
        };
    }
}

