/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.quickfixes;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.psi.OCQualifiedExpression;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCCreateDefinitionIntentionAction
implements IntentionAction {
    protected OCSymbolKind mySymbolKind;
    @NotNull
    protected PsiElement myUsage;
    @NotNull
    protected final Project myProject;
    protected OCSymbol myParent;

    public OCCreateDefinitionIntentionAction(OCSymbolKind symbolKind, @NotNull PsiElement usage, OCSymbol parent) {
        if (usage == null) {
            OCCreateDefinitionIntentionAction.$$$reportNull$$$0(0);
        }
        this.mySymbolKind = symbolKind;
        this.myUsage = usage;
        this.myProject = usage.getProject();
        this.myParent = parent;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            OCCreateDefinitionIntentionAction.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile psiFile) {
        if (project == null) {
            OCCreateDefinitionIntentionAction.$$$reportNull$$$0(2);
        }
        if (!OCCodeInsightUtil.isValid(this.myUsage) || this.myParent != null && !OCSearchScope.isInProjectSources(this.myParent, project)) {
            return false;
        }
        return switch (this.mySymbolKind) {
            case OCSymbolKind.FUNCTION_DECLARATION, OCSymbolKind.METHOD, OCSymbolKind.GLOBAL_VARIABLE, OCSymbolKind.LOCAL_VARIABLE, OCSymbolKind.PROPERTY, OCSymbolKind.MACRO -> true;
            case OCSymbolKind.STRUCT_FIELD -> {
                if (this.myParent != null) {
                    yield true;
                }
                yield false;
            }
            case OCSymbolKind.ENUM_CONST -> {
                if (this.myParent != null && this.myParent.getKind() == OCSymbolKind.ENUM) {
                    yield true;
                }
                yield false;
            }
            case OCSymbolKind.INSTANCE_VARIABLE -> {
                OCMethod method = (OCMethod)PsiTreeUtil.getParentOfType((PsiElement)this.myUsage, OCMethod.class);
                if (method == null || this.myUsage instanceof OCQualifiedExpression || method.isInstanceMethod()) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    @Nullable
    protected abstract PsiElement getDefinition(Project var1, Editor var2, PsiFile var3);

    public void invoke(@NotNull Project project, Editor editor, PsiFile psiFile) throws IncorrectOperationException {
        if (project == null) {
            OCCreateDefinitionIntentionAction.$$$reportNull$$$0(3);
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        ArrayList<PsiFile> filesToWrite = new ArrayList<PsiFile>();
        filesToWrite.add(psiFile);
        if (this.mySymbolKind == OCSymbolKind.STRUCT_FIELD || this.mySymbolKind == OCSymbolKind.ENUM_CONST) {
            filesToWrite.add(this.myParent.getContainingOCFile(project));
        }
        if (FileModificationService.getInstance().preparePsiElementsForWrite(filesToWrite)) {
            this.doCreate(project, editor, psiFile);
        }
    }

    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile psiFile) {
        PsiElement definition;
        if (project == null) {
            OCCreateDefinitionIntentionAction.$$$reportNull$$$0(4);
        }
        if (editor == null) {
            OCCreateDefinitionIntentionAction.$$$reportNull$$$0(5);
        }
        if (psiFile == null) {
            OCCreateDefinitionIntentionAction.$$$reportNull$$$0(6);
        }
        Object object = (definition = this.getDefinition(project, editor, psiFile)) != null ? new IntentionPreviewInfo.CustomDiff(psiFile.getFileType(), "", definition.getText()) : IntentionPreviewInfo.EMPTY;
        if (object == null) {
            OCCreateDefinitionIntentionAction.$$$reportNull$$$0(7);
        }
        return object;
    }

    protected boolean doCreate(Project project, Editor editor, PsiFile file) {
        PsiElement result;
        PsiElement parentElement = this.myParent != null ? this.myParent.locateDefinition(project) : null;
        PsiElement definition = this.getDefinition(project, editor, file);
        if (definition == null) {
            return false;
        }
        if (this.mySymbolKind == OCSymbolKind.FUNCTION_DECLARATION || this.mySymbolKind == OCSymbolKind.METHOD || this.mySymbolKind == OCSymbolKind.GLOBAL_VARIABLE || this.mySymbolKind == OCSymbolKind.LOCAL_VARIABLE || this.mySymbolKind == OCSymbolKind.MACRO || this.mySymbolKind == OCSymbolKind.ENUM_CONST && this.myParent != null) {
            PsiElement parent = this.myParent != null ? this.myParent.locateDefinition(project) : OCChangeUtil.getAppropriateParent(this.mySymbolKind, this.myUsage);
            if (parent == null) {
                return false;
            }
            result = OCChangeUtil.addBefore(parent, definition, this.myUsage);
            OCChangeUtil.addNewLineIfNeed(result, true);
        } else if (this.mySymbolKind == OCSymbolKind.STRUCT_FIELD || this.mySymbolKind == OCSymbolKind.PROPERTY) {
            if (this.myParent == null || parentElement == null) {
                return false;
            }
            result = OCChangeUtil.add(parentElement, definition);
        } else if (this.mySymbolKind == OCSymbolKind.INSTANCE_VARIABLE) {
            if (this.myParent == null || parentElement == null) {
                return false;
            }
            result = OCChangeUtil.add(((OCClassDeclaration)parentElement).getInstanceVariablesList(), definition);
        } else {
            return false;
        }
        if (result != null && this.mySymbolKind != OCSymbolKind.FUNCTION_DECLARATION && this.mySymbolKind != OCSymbolKind.METHOD) {
            if (editor != null && this.mySymbolKind == OCSymbolKind.GLOBAL_VARIABLE && definition instanceof OCDeclaration) {
                editor.getCaretModel().moveToOffset(((OCDeclaration)result).getDeclarators().get(0).getTextRange().getEndOffset());
                editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
            } else {
                OCCodeInsightUtil.selectElement(result);
            }
        }
        return true;
    }

    public boolean startInWriteAction() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usage";
                break;
            }
            case 1: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/quickfixes/OCCreateDefinitionIntentionAction";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/quickfixes/OCCreateDefinitionIntentionAction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "generatePreview";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 7: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "generatePreview";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 7 -> new IllegalStateException(string);
        };
    }
}

