/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.qualifiedName;

import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.openapi.util.NlsSafe;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.qualifiedName.QualifiedNameComparator;
import com.jetbrains.cidr.lang.qualifiedName.QualifiedNameInternerKt;
import com.jetbrains.cidr.lang.symbols.symtable.OCNameInternerKt;
import com.jetbrains.cidr.lang.symbols.symtable.OCNamesInterner;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@FileModifier.SafeTypeForPreview
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0087\b\u0018\u0000 ,2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001,B\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u000b\u001a\u00020\u0004H\u0017J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0004J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00002\b\u0010\u0015\u001a\u0004\u0018\u00010\u0000J\u0018\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0011\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u0015\u001a\u00020\u0000H\u0096\u0002J\u000e\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u0000J\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00000#J\u0011\u0010$\u001a\u00020\u00002\u0006\u0010%\u001a\u00020\u0000H\u0086\u0002J\u000b\u0010&\u001a\u0004\u0018\u00010\u0000H\u00c6\u0003J\t\u0010'\u001a\u00020\u0004H\u00c6\u0003J\u001f\u0010(\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u0004H\u00c6\u0001J\u0013\u0010)\u001a\u00020\u00122\b\u0010\u0015\u001a\u0004\u0018\u00010*H\u00d6\u0003J\t\u0010+\u001a\u00020\u0018H\u00d6\u0001R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0018\u0010\f\u001a\u00060\rj\u0002`\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0019\u001a\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\bR\u0017\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00040\u001f8F\u00a2\u0006\u0006\u001a\u0004\b \u0010!\u00a8\u0006-"}, d2={"Lcom/jetbrains/cidr/lang/qualifiedName/QualifiedName;", "", "qualifier", "name", "", "<init>", "(Lcom/jetbrains/cidr/lang/qualifiedName/QualifiedName;Ljava/lang/String;)V", "getQualifier", "()Lcom/jetbrains/cidr/lang/qualifiedName/QualifiedName;", "getName", "()Ljava/lang/String;", "toString", "qualifiedNameBuilder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "getQualifiedNameBuilder", "()Ljava/lang/StringBuilder;", "equalsToString", "", "string", "removingSuffixThatIsCommonWithStartOf", "other", "checkQualified", "length", "", "leftmostModuleName", "getLeftmostModuleName", "compareTo", "startsWith", "prefix", "parts", "", "getParts", "()Ljava/util/List;", "sequenceOfQualifiers", "Lkotlin/sequences/Sequence;", "plus", "right", "component1", "component2", "copy", "equals", "", "hashCode", "Companion", "intellij.c.core"})
@SourceDebugExtension(value={"SMAP\nQualifiedName.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QualifiedName.kt\ncom/jetbrains/cidr/lang/qualifiedName/QualifiedName\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,135:1\n1878#2,3:136\n*S KotlinDebug\n*F\n+ 1 QualifiedName.kt\ncom/jetbrains/cidr/lang/qualifiedName/QualifiedName\n*L\n67#1:136,3\n*E\n"})
public final class QualifiedName
implements Comparable<QualifiedName> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final QualifiedName qualifier;
    @NotNull
    private final String name;
    @NotNull
    private static final QualifiedName[] EMPTY_ARRAY = new QualifiedName[0];
    @NotNull
    private static final QualifiedName EMPTY = new QualifiedName(null, "");

    public QualifiedName(@Nullable QualifiedName qualifier, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.qualifier = qualifier;
        this.name = name;
        if (StringsKt.contains$default((CharSequence)this.name, (CharSequence)".", (boolean)false, (int)2, null)) {
            OCLog.LOG.error("Name part should not contain '.', but \"" + this.name + "\" was provided.");
        }
    }

    @Nullable
    public final QualifiedName getQualifier() {
        return this.qualifier;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NlsSafe
    @NotNull
    public String toString() {
        String string;
        if (this.qualifier == null) {
            string = this.name;
        } else {
            String string2 = this.getQualifiedNameBuilder().toString();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        }
        return string;
    }

    private final StringBuilder getQualifiedNameBuilder() {
        Comparable<QualifiedName> comparable = this.qualifier;
        if (comparable == null || (comparable = ((QualifiedName)comparable).getQualifiedNameBuilder()) == null || (comparable = ((StringBuilder)comparable).append('.')) == null || (comparable = ((StringBuilder)comparable).append(this.name)) == null) {
            comparable = new StringBuilder(this.name);
        }
        return comparable;
    }

    public final boolean equalsToString(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        if (this.qualifier == null) {
            return Intrinsics.areEqual((Object)this.name, (Object)string);
        }
        return this.checkQualified(string, string.length());
    }

    @Nullable
    public final QualifiedName removingSuffixThatIsCommonWithStartOf(@Nullable QualifiedName other) {
        QualifiedName qualifiedName;
        if (other == null) {
            qualifiedName = this;
        } else if (Intrinsics.areEqual((Object)other.name, (Object)this.name)) {
            QualifiedName qualifiedName2 = this.qualifier;
            qualifiedName = qualifiedName2 != null ? qualifiedName2.removingSuffixThatIsCommonWithStartOf(other.qualifier) : null;
        } else {
            qualifiedName = this.removingSuffixThatIsCommonWithStartOf(other.qualifier);
        }
        return qualifiedName;
    }

    private final boolean checkQualified(String string, int length) {
        if (this.qualifier == null) {
            return length == this.name.length() && StringsKt.startsWith$default((String)string, (String)this.name, (boolean)false, (int)2, null);
        }
        if (length < this.name.length() + 1) {
            return false;
        }
        int dotIndex = length - this.name.length() - 1;
        if (string.charAt(dotIndex) != '.') {
            return false;
        }
        if (!StringsKt.startsWith$default((String)string, (String)this.name, (int)(dotIndex + 1), (boolean)false, (int)4, null)) {
            return false;
        }
        return this.qualifier.checkQualified(string, dotIndex);
    }

    @NotNull
    public final QualifiedName getLeftmostModuleName() {
        QualifiedName qualifiedName = this.qualifier;
        if (qualifiedName == null || (qualifiedName = qualifiedName.getLeftmostModuleName()) == null) {
            qualifiedName = this;
        }
        return qualifiedName;
    }

    @Override
    public int compareTo(@NotNull QualifiedName other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return QualifiedNameComparator.INSTANCE.compareQualifiedNames(this, other);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean startsWith(@NotNull QualifiedName prefix) {
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        List<String> parts = this.getParts();
        List<String> prefixParts = prefix.getParts();
        if (prefixParts.size() > parts.size()) {
            return false;
        }
        Iterable $this$forEachIndexed$iv = prefixParts;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void prefixPart;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            String string = (String)item$iv;
            int index = n;
            boolean bl = false;
            String part = parts.get(index);
            if (Intrinsics.areEqual((Object)prefixPart, (Object)part)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public final List<String> getParts() {
        return CollectionsKt.asReversed((List)SequencesKt.toList((Sequence)SequencesKt.map(this.sequenceOfQualifiers(), QualifiedName::_get_parts_$lambda$1)));
    }

    @NotNull
    public final Sequence<QualifiedName> sequenceOfQualifiers() {
        return SequencesKt.generateSequence((Object)this, QualifiedName::sequenceOfQualifiers$lambda$2);
    }

    @NotNull
    public final QualifiedName plus(@NotNull QualifiedName right) {
        Intrinsics.checkNotNullParameter((Object)right, (String)"right");
        if (right.qualifier == null) {
            return new QualifiedName(this, right.name);
        }
        return new QualifiedName(this.plus(right.qualifier), right.name);
    }

    @Nullable
    public final QualifiedName component1() {
        return this.qualifier;
    }

    @NotNull
    public final String component2() {
        return this.name;
    }

    @NotNull
    public final QualifiedName copy(@Nullable QualifiedName qualifier, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return new QualifiedName(qualifier, name);
    }

    public static /* synthetic */ QualifiedName copy$default(QualifiedName qualifiedName, QualifiedName qualifiedName2, String string, int n, Object object) {
        if ((n & 1) != 0) {
            qualifiedName2 = qualifiedName.qualifier;
        }
        if ((n & 2) != 0) {
            string = qualifiedName.name;
        }
        return qualifiedName.copy(qualifiedName2, string);
    }

    public int hashCode() {
        int result = this.qualifier == null ? 0 : this.qualifier.hashCode();
        result = result * 31 + this.name.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof QualifiedName)) {
            return false;
        }
        QualifiedName qualifiedName = (QualifiedName)other;
        if (!Intrinsics.areEqual((Object)this.qualifier, (Object)qualifiedName.qualifier)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.name, (Object)qualifiedName.name);
    }

    private static final String _get_parts_$lambda$1(QualifiedName it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.name;
    }

    private static final QualifiedName sequenceOfQualifiers$lambda$2(QualifiedName it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.qualifier;
    }

    @JvmStatic
    @NotNull
    public static final QualifiedName of(@NotNull String name) {
        return Companion.of(name);
    }

    @JvmStatic
    @NotNull
    public static final QualifiedName of(@NotNull String qualifier, @NotNull String name) {
        return Companion.of(qualifier, name);
    }

    @JvmStatic
    @NotNull
    public static final QualifiedName of(String ... names) {
        return Companion.of(names);
    }

    @JvmStatic
    @NotNull
    public static final QualifiedName of(@NotNull List<String> names) {
        return Companion.of(names);
    }

    @JvmStatic
    @NotNull
    public static final QualifiedName interned(@NotNull String name) {
        return Companion.interned(name);
    }

    @JvmStatic
    @NotNull
    public static final QualifiedName interned(@NotNull String qualifier, @NotNull String name) {
        return Companion.interned(qualifier, name);
    }

    @JvmStatic
    @NotNull
    public static final QualifiedName interned(String ... names) {
        return Companion.interned(names);
    }

    @JvmStatic
    @NotNull
    public static final QualifiedName interned(@NotNull List<String> names) {
        return Companion.interned(names);
    }

    @JvmStatic
    @NotNull
    public static final QualifiedName asQualifiedName(@NotNull String $this$asQualifiedName) {
        return Companion.asQualifiedName($this$asQualifiedName);
    }

    @JvmStatic
    @NotNull
    public static final QualifiedName asInternedQualifiedName(@NotNull String $this$asInternedQualifiedName) {
        return Companion.asInternedQualifiedName($this$asInternedQualifiedName);
    }

    @NotNull
    public static final QualifiedName[] getEMPTY_ARRAY() {
        return Companion.getEMPTY_ARRAY();
    }

    @NotNull
    public static final QualifiedName getEMPTY() {
        return Companion.getEMPTY();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010 \n\u0002\b\r\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J!\u0010\u0004\u001a\u00020\u00052\u0012\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\n\"\u00020\u0007H\u0007\u00a2\u0006\u0002\u0010\u000bJ\u0016\u0010\u0004\u001a\u00020\u00052\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\fH\u0007J\u0010\u0010\r\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0018\u0010\r\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J!\u0010\r\u001a\u00020\u00052\u0012\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\n\"\u00020\u0007H\u0007\u00a2\u0006\u0002\u0010\u000bJ\u0016\u0010\r\u001a\u00020\u00052\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\fH\u0007J\f\u0010\u000e\u001a\u00020\u0005*\u00020\u0007H\u0007J\f\u0010\u000f\u001a\u00020\u0005*\u00020\u0007H\u0007R$\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00050\n8\u0006X\u0087\u0004\u00a2\u0006\u0010\n\u0002\u0010\u0014\u0012\u0004\b\u0011\u0010\u0003\u001a\u0004\b\u0012\u0010\u0013R\u001c\u0010\u0015\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0016\u0010\u0003\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/cidr/lang/qualifiedName/QualifiedName$Companion;", "", "<init>", "()V", "of", "Lcom/jetbrains/cidr/lang/qualifiedName/QualifiedName;", "name", "", "qualifier", "names", "", "([Ljava/lang/String;)Lcom/jetbrains/cidr/lang/qualifiedName/QualifiedName;", "", "interned", "asQualifiedName", "asInternedQualifiedName", "EMPTY_ARRAY", "getEMPTY_ARRAY$annotations", "getEMPTY_ARRAY", "()[Lcom/jetbrains/cidr/lang/qualifiedName/QualifiedName;", "[Lcom/jetbrains/cidr/lang/qualifiedName/QualifiedName;", "EMPTY", "getEMPTY$annotations", "getEMPTY", "()Lcom/jetbrains/cidr/lang/qualifiedName/QualifiedName;", "intellij.c.core"})
    @SourceDebugExtension(value={"SMAP\nQualifiedName.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QualifiedName.kt\ncom/jetbrains/cidr/lang/qualifiedName/QualifiedName$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,135:1\n1803#2,3:136\n1803#2,3:139\n*S KotlinDebug\n*F\n+ 1 QualifiedName.kt\ncom/jetbrains/cidr/lang/qualifiedName/QualifiedName$Companion\n*L\n102#1:136,3\n120#1:139,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final QualifiedName of(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return new QualifiedName(null, name);
        }

        @JvmStatic
        @NotNull
        public final QualifiedName of(@NotNull String qualifier, @NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)qualifier, (String)"qualifier");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return new QualifiedName(new QualifiedName(null, qualifier), name);
        }

        @JvmStatic
        @NotNull
        public final QualifiedName of(String ... names) {
            Intrinsics.checkNotNullParameter((Object)names, (String)"names");
            return this.of(CollectionsKt.listOf((Object[])Arrays.copyOf(names, names.length)));
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final QualifiedName of(@NotNull List<String> names) {
            void $this$fold$iv;
            Intrinsics.checkNotNullParameter(names, (String)"names");
            if (names.isEmpty()) {
                throw new IllegalArgumentException("names must not be empty");
            }
            Iterable iterable = names;
            QualifiedName initial$iv = null;
            boolean $i$f$fold = false;
            QualifiedName accumulator$iv = initial$iv;
            for (Object element$iv : $this$fold$iv) {
                void part;
                String string = (String)element$iv;
                QualifiedName prev = accumulator$iv;
                boolean bl = false;
                accumulator$iv = new QualifiedName(prev, (String)part);
            }
            QualifiedName qualifiedName = accumulator$iv;
            Intrinsics.checkNotNull(qualifiedName);
            return qualifiedName;
        }

        @JvmStatic
        @NotNull
        public final QualifiedName interned(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            String string = OCNamesInterner.intern((String)name);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"intern(...)");
            return QualifiedNameInternerKt.intern(new QualifiedName(null, string));
        }

        @JvmStatic
        @NotNull
        public final QualifiedName interned(@NotNull String qualifier, @NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)qualifier, (String)"qualifier");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            QualifiedName q = QualifiedNameInternerKt.intern(new QualifiedName(null, OCNameInternerKt.interAsOCName((String)qualifier)));
            return QualifiedNameInternerKt.intern(new QualifiedName(q, OCNameInternerKt.interAsOCName((String)name)));
        }

        @JvmStatic
        @NotNull
        public final QualifiedName interned(String ... names) {
            Intrinsics.checkNotNullParameter((Object)names, (String)"names");
            return this.interned(CollectionsKt.listOf((Object[])Arrays.copyOf(names, names.length)));
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final QualifiedName interned(@NotNull List<String> names) {
            void $this$fold$iv;
            Intrinsics.checkNotNullParameter(names, (String)"names");
            if (names.isEmpty()) {
                throw new IllegalArgumentException();
            }
            Iterable iterable = names;
            QualifiedName initial$iv = null;
            boolean $i$f$fold = false;
            QualifiedName accumulator$iv = initial$iv;
            for (Object element$iv : $this$fold$iv) {
                void part;
                String string = (String)element$iv;
                QualifiedName prev = accumulator$iv;
                boolean bl = false;
                accumulator$iv = QualifiedNameInternerKt.intern(new QualifiedName(prev, OCNameInternerKt.interAsOCName((String)part)));
            }
            QualifiedName qualifiedName = accumulator$iv;
            Intrinsics.checkNotNull(qualifiedName);
            return qualifiedName;
        }

        @JvmStatic
        @NotNull
        public final QualifiedName asQualifiedName(@NotNull String $this$asQualifiedName) {
            Intrinsics.checkNotNullParameter((Object)$this$asQualifiedName, (String)"<this>");
            char[] cArray = new char[]{'.'};
            return this.of(StringsKt.split$default((CharSequence)$this$asQualifiedName, (char[])cArray, (boolean)false, (int)0, (int)6, null));
        }

        @JvmStatic
        @NotNull
        public final QualifiedName asInternedQualifiedName(@NotNull String $this$asInternedQualifiedName) {
            Intrinsics.checkNotNullParameter((Object)$this$asInternedQualifiedName, (String)"<this>");
            char[] cArray = new char[]{'.'};
            return this.interned(StringsKt.split$default((CharSequence)$this$asInternedQualifiedName, (char[])cArray, (boolean)false, (int)0, (int)6, null));
        }

        @NotNull
        public final QualifiedName[] getEMPTY_ARRAY() {
            return EMPTY_ARRAY;
        }

        @JvmStatic
        public static /* synthetic */ void getEMPTY_ARRAY$annotations() {
        }

        @NotNull
        public final QualifiedName getEMPTY() {
            return EMPTY;
        }

        @JvmStatic
        public static /* synthetic */ void getEMPTY$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

