/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.psi.impl;

import com.intellij.codeInsight.highlighting.ReadWriteAccessDetector;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.CommonProcessors;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.daemon.clang.ExternalResolveUtils;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.parser.OCPunctuatorElementType;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCCallExpression;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCQualifiedExpression;
import com.jetbrains.cidr.lang.psi.OCSendMessageExpression;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.psi.OCTypeArgumentList;
import com.jetbrains.cidr.lang.psi.impl.OCExpressionWithReferenceBase;
import com.jetbrains.cidr.lang.psi.visitors.OCVisitor;
import com.jetbrains.cidr.lang.refactoring.OCNameSuggester;
import com.jetbrains.cidr.lang.resolve.OCArgumentsList;
import com.jetbrains.cidr.lang.resolve.OCCompilerGeneratedConstructorSymbol;
import com.jetbrains.cidr.lang.resolve.OCExprValueCategory;
import com.jetbrains.cidr.lang.resolve.OCFunctionGroupSymbol;
import com.jetbrains.cidr.lang.resolve.OCResolveOverloadsUtil;
import com.jetbrains.cidr.lang.resolve.OCResolveUtil;
import com.jetbrains.cidr.lang.resolve.references.OCOperatorReference;
import com.jetbrains.cidr.lang.resolve.references.OCReferenceWithContext;
import com.jetbrains.cidr.lang.search.usages.OCReadWriteAccessDetector;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolContext;
import com.jetbrains.cidr.lang.symbols.OCSymbolGroupContext;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCSymbolReference;
import com.jetbrains.cidr.lang.symbols.OCSymbolReferenceResolver;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbolImpl;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCTemplateSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInstanceVariableSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMemberSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.types.CVQualifiers;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCIdType;
import com.jetbrains.cidr.lang.types.OCMagicType;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCObjectTypeContext;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeArgument;
import com.jetbrains.cidr.lang.types.OCTypeGuesser;
import com.jetbrains.cidr.lang.types.OCTypeUtils;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import com.jetbrains.cidr.lang.types.OCVoidType;
import com.jetbrains.cidr.lang.types.visitors.OCSimpleTypeSubstitution;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCCommonProcessors;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.util.OCExpectedTypeUtil;
import com.jetbrains.cidr.lang.util.OCParenthesesUtils;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerFeaturesHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCQualifiedExpressionImpl
extends OCExpressionWithReferenceBase
implements OCQualifiedExpression,
OCExpectedTypeUtil.Expectable {
    private static final Logger LOG = Logger.getInstance(OCQualifiedExpressionImpl.class);
    private static final Condition<OCSymbol> CAN_BE_STRUCTURE_FIELD = o -> o.getKind().isExpression();

    public OCQualifiedExpressionImpl(@NotNull ASTNode node) {
        if (node == null) {
            OCQualifiedExpressionImpl.$$$reportNull$$$0(0);
        }
        super(node);
    }

    @Override
    @NotNull
    public OCExpression getQualifier() {
        OCExpression qualifier = (OCExpression)this.findChildByType(OCElementTypes.EXPRESSIONS);
        if (qualifier == null) {
            LOG.error("Qualifier is null in: " + this.getText());
        }
        OCExpression oCExpression = qualifier;
        if (oCExpression == null) {
            OCQualifiedExpressionImpl.$$$reportNull$$$0(1);
        }
        return oCExpression;
    }

    @Override
    @NotNull
    public OCPunctuatorElementType getQualifyingTokenKind() {
        OCPunctuatorElementType oCPunctuatorElementType = (OCPunctuatorElementType)this.getQualifyingToken().getElementType();
        if (oCPunctuatorElementType == null) {
            OCQualifiedExpressionImpl.$$$reportNull$$$0(2);
        }
        return oCPunctuatorElementType;
    }

    @Override
    @NotNull
    public ASTNode getQualifyingToken() {
        OCElement accessor = this.getQualifyingElement();
        for (ASTNode child = accessor.getNode().getFirstChildNode(); child != null; child = child.getTreeNext()) {
            IElementType tt = child.getElementType();
            if (!(tt instanceof OCPunctuatorElementType)) continue;
            ASTNode aSTNode = child;
            if (aSTNode == null) {
                OCQualifiedExpressionImpl.$$$reportNull$$$0(3);
            }
            return aSTNode;
        }
        assert (false);
        if (null == null) {
            OCQualifiedExpressionImpl.$$$reportNull$$$0(4);
        }
        return null;
    }

    @Override
    @Nullable
    public OCType getQualifierContainerType(@Nullable Ref<Boolean> outSynthetic) {
        return this.getQualifierContainerType(this.getQualifier().getResolvedType(), null, outSynthetic);
    }

    @Nullable
    private OCType getQualifierContainerType(OCType qualifierType, @Nullable OCPunctuatorElementType forcedQualifyingToken, Ref<Boolean> outSynthetic) {
        if (outSynthetic != null) {
            outSynthetic.set((Object)false);
        }
        if (qualifierType instanceof OCCppReferenceType) {
            qualifierType = ((OCCppReferenceType)qualifierType).getRefType();
        }
        OCResolveContext context = OCResolveContext.forPsi(this);
        if (qualifierType instanceof OCStructType && qualifierType.isSubclassOfMagic(context)) {
            return new OCMagicType();
        }
        OCPunctuatorElementType qualifyingToken = forcedQualifyingToken;
        if (qualifyingToken == null) {
            qualifyingToken = this.getQualifyingTokenKind();
        }
        if (qualifyingToken == OCTokenTypes.DEREF) {
            Set processedTypes = OCTypeUtils.newTypeSet();
            boolean wasDerefOperator = false;
            while (qualifierType instanceof OCStructType) {
                OCStructType structType = (OCStructType)qualifierType;
                if (!processedTypes.add(qualifierType)) break;
                OCFunctionSymbol derefOperator = OCOperatorReference.resolveDerefOperator(this, structType);
                if (derefOperator == null) continue;
                wasDerefOperator = true;
                qualifierType = derefOperator.getEffectiveType(this).resolve(context);
            }
            if (qualifierType instanceof OCPointerType) {
                return ((OCPointerType)qualifierType).getRefType().resolve(this);
            }
            if (wasDerefOperator) {
                return qualifierType;
            }
            if (outSynthetic != null) {
                outSynthetic.set((Object)true);
            }
            return OCUnknownType.INSTANCE;
        }
        return qualifierType;
    }

    @Override
    @NotNull
    public OCElement getQualifyingElement() {
        OCElement oCElement = (OCElement)this.findChildByType((IElementType)OCElementTypes.QUALIFIED_EXPRESSION_ACCESSOR);
        if (oCElement == null) {
            OCQualifiedExpressionImpl.$$$reportNull$$$0(5);
        }
        return oCElement;
    }

    @Override
    public boolean canChangeQualifyingToken() {
        return OCElementUtil.getUserVisibleRangeInDocument(this.getQualifyingElement()) != null;
    }

    @Override
    @NotNull
    public List<OCPunctuatorElementType> qualifyingTokensForCompletion() {
        OCType type;
        OCPunctuatorElementType mQTK = this.getQualifyingTokenKind();
        if (this.canChangeQualifyingToken() && (!((type = this.getQualifier().getResolvedType(OCResolveContext.forPsi(this)).getTerminalType()) instanceof OCStructType) || OCOperatorReference.resolveDerefOperator(this, (OCStructType)type) == null)) {
            OCPunctuatorElementType[] items = new OCPunctuatorElementType[]{mQTK, mQTK == OCTokenTypes.DEREF ? OCTokenTypes.DOT : OCTokenTypes.DEREF};
            List<OCPunctuatorElementType> list = Arrays.asList(items);
            if (list == null) {
                OCQualifiedExpressionImpl.$$$reportNull$$$0(6);
            }
            return list;
        }
        List<OCPunctuatorElementType> list = Collections.singletonList(mQTK);
        if (list == null) {
            OCQualifiedExpressionImpl.$$$reportNull$$$0(7);
        }
        return list;
    }

    @NotNull
    public String getName() {
        String string = OCElementUtil.getIdentifierName(this.getNameIdentifier());
        if (string == null) {
            OCQualifiedExpressionImpl.$$$reportNull$$$0(8);
        }
        return string;
    }

    @Override
    @NotNull
    public String getSymbolName() {
        String string = OCElementUtil.getIdentifierName(this.findReferenceTokenInCall());
        if (string == null) {
            OCQualifiedExpressionImpl.$$$reportNull$$$0(9);
        }
        return string;
    }

    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            OCQualifiedExpressionImpl.$$$reportNull$$$0(10);
        }
        OCElementUtil.replaceWithIdentifier(this.getNameIdentifier(), name, this);
        return this;
    }

    @Nullable
    public PsiElement getNameIdentifier() {
        return this.findNameStartTokenInCall();
    }

    @Override
    public OCType getExpectedType() {
        OCType expectedType = this.getContext() instanceof OCCallExpression ? OCQualifiedExpressionImpl.getCallExpectedType((OCCallExpression)this.getParent()) : OCExpectedTypeUtil.getExpectedType((OCExpression)this, true);
        if (expectedType == OCUnknownType.INSTANCE) {
            expectedType = OCIdType.pointerToID();
        }
        return expectedType;
    }

    public static OCType getCallExpectedType(@NotNull OCCallExpression callExpr) {
        if (callExpr == null) {
            OCQualifiedExpressionImpl.$$$reportNull$$$0(11);
        }
        OCType returnExpectedType = OCExpectedTypeUtil.getExpectedType((OCExpression)callExpr, true);
        ArrayList<OCType> argumentTypes = new ArrayList<OCType>();
        if (returnExpectedType == OCUnknownType.INSTANCE) {
            returnExpectedType = OCVoidType.instance();
        }
        for (OCExpression argument : callExpr.getArguments()) {
            argumentTypes.add(OCExpectedTypeUtil.getExpressionType(argument, true));
        }
        return new OCFunctionType(returnExpectedType, argumentTypes);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public OCSymbolGroupContext getSymbolContext() {
        OCSymbolContext context;
        OCObjectTypeContext qualifierContext = this.getQualifier().getTypeContext();
        boolean shouldBeFunction = this.getParent() instanceof OCCallExpression && this.getContainingOCFile().isCpp();
        OCPunctuatorElementType qualifyingTokenKind = this.getQualifyingTokenKind();
        if (qualifierContext != null) {
            OCClassSymbol classSymbol = qualifierContext.getType().getClassSymbol();
            if (qualifierContext.getStaticMode() == OCObjectTypeContext.StaticMode.STATIC) {
                context = new OCSymbolContext(this, OCSymbolKind.METHOD, classSymbol);
                return new OCSymbolGroupContext(context);
            }
            if (qualifyingTokenKind == OCTokenTypes.DEREF) {
                context = new OCSymbolContext(this, OCSymbolKind.INSTANCE_VARIABLE, classSymbol);
                return new OCSymbolGroupContext(context);
            }
            if (qualifyingTokenKind != OCTokenTypes.DOT) return null;
            final OCSymbolContext context2 = new OCSymbolContext(this, OCSymbolKind.PROPERTY, classSymbol);
            OCSymbolGroupContext groupContext = new OCSymbolGroupContext(context2){

                @Override
                public String getCannotResolveMessagePrefix(@NotNull Project project) {
                    if (project == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return context2.getCannotResolveMessagePrefix(project);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/psi/impl/OCQualifiedExpressionImpl$1", "getCannotResolveMessagePrefix"));
                }
            };
            groupContext.addSymbolContext(new OCSymbolContext(this, OCSymbolKind.METHOD, classSymbol));
            return groupContext;
        }
        OCType qualifierType = OCTypeUtils.getCppReferencedType(this.getQualifier().getResolvedType());
        if (qualifyingTokenKind == OCTokenTypes.DOT && qualifierType instanceof OCStructType) {
            context = new OCSymbolContext(this, shouldBeFunction ? OCSymbolKind.FUNCTION_DECLARATION : OCSymbolKind.STRUCT_FIELD, ((OCStructType)qualifierType).getSymbol());
            return new OCSymbolGroupContext(context);
        }
        if (qualifyingTokenKind == OCTokenTypes.DEREF && qualifierType instanceof OCPointerType && ((OCPointerType)qualifierType).getRefType() instanceof OCStructType) {
            context = new OCSymbolContext(this, shouldBeFunction ? OCSymbolKind.FUNCTION_DECLARATION : OCSymbolKind.STRUCT_FIELD, ((OCStructType)((OCPointerType)qualifierType).getRefType()).getSymbol());
            return new OCSymbolGroupContext(context);
        }
        if (!(qualifierType instanceof OCObjectType)) return null;
        context = new OCSymbolContext(this, OCSymbolKind.INSTANCE_VARIABLE, ((OCObjectType)qualifierType).getClassSymbol());
        return new OCSymbolGroupContext(context);
    }

    @Override
    public void accept(@NotNull OCVisitor visitor) {
        if (visitor == null) {
            OCQualifiedExpressionImpl.$$$reportNull$$$0(12);
        }
        visitor.visitQualifiedExpression(this);
    }

    @Nullable
    public PsiElement resolve() {
        OCSymbol symbol = this.resolveToSymbol();
        return symbol != null ? symbol.locateDefinition(this.getProject()) : null;
    }

    @Override
    public boolean processTargets(String symbolName, Processor<OCSymbol> processor2, boolean processStaticMismatched, @Nullable OCPunctuatorElementType forcedQualifyingToken, boolean filterOverloads, boolean ignoreImports, @Nullable Ref<OCType> outQualifierType, @NotNull OCResolveContext resolveContext) {
        if (resolveContext == null) {
            OCQualifiedExpressionImpl.$$$reportNull$$$0(13);
        }
        if (resolveContext.isProcessNonImported() != ignoreImports) {
            resolveContext = resolveContext.clone();
            resolveContext.setProcessNonImported(ignoreImports);
        }
        Object qualifierContext = this.getContainerTypeContext(forcedQualifyingToken, resolveContext);
        if (outQualifierType != null && qualifierContext instanceof QualifierTypeContext) {
            outQualifierType.set((Object)((QualifierTypeContext)qualifierContext).containerType);
        }
        return this.doProcessTargets(qualifierContext, symbolName, processor2, processStaticMismatched, filterOverloads, false, false, resolveContext, true);
    }

    private boolean doProcessTargets(@Nullable Object qualifierContext, String symbolName, Processor<OCSymbol> processor2, boolean processStaticMismatched, boolean filterOverloads, boolean filterAmbigs, boolean acceptOnlyCompatible, @NotNull OCResolveContext context, boolean resolveSpecializations) {
        if (context == null) {
            OCQualifiedExpressionImpl.$$$reportNull$$$0(14);
        }
        if (qualifierContext instanceof OCObjectTypeContext) {
            return this.processObjCMembers((OCObjectTypeContext)qualifierContext, symbolName, processor2, processStaticMismatched);
        }
        if (qualifierContext instanceof QualifierTypeContext) {
            OCType containerType = ((QualifierTypeContext)qualifierContext).containerType;
            if (containerType instanceof OCStructType && ((OCStructType)containerType).getKind() != OCSymbolKind.ENUM) {
                return this.processStructMembers(symbolName, processor2, filterOverloads, context, (QualifierTypeContext)qualifierContext, acceptOnlyCompatible, filterAmbigs, resolveSpecializations);
            }
            if (containerType.isUnknown() || containerType instanceof OCMagicType) {
                processor2.process((Object)new OCDeclaratorSymbolImpl(symbolName, new OCMagicType(symbolName), OCSymbolKind.TEMPLATE_VALUE_PARAMETER));
            }
        }
        return true;
    }

    private boolean processObjCMembers(OCObjectTypeContext qualifierContext, String symbolName, Processor<OCSymbol> processor2, boolean processStaticMismatched) {
        ReadWriteAccessDetector.Access access;
        OCObjectTypeContext objectTypeContext = qualifierContext;
        boolean isStaticContext = objectTypeContext.getStaticMode() == OCObjectTypeContext.StaticMode.STATIC;
        boolean isDotAccess = this.getQualifyingTokenKind() == OCTokenTypes.DOT;
        Processor membersProcessor = symbol -> {
            if (!OCCompilerFeaturesHelper.supportsLaterMethodDeclaration() && !OCResolveUtil.isEarlierInCode((OCSymbol)symbol, this) || OCResolveUtil.isDisabledSymbol(symbol, this.getContainingOCFile())) {
                return true;
            }
            if (isDotAccess && symbol instanceof OCMethodSymbol) {
                return processor2.process(symbol);
            }
            if (isDotAccess && symbol instanceof OCPropertySymbol) {
                return processor2.process(symbol);
            }
            if (!isDotAccess && symbol instanceof OCInstanceVariableSymbol && !isStaticContext) {
                return processor2.process(symbol);
            }
            return true;
        };
        OCCommonProcessors.OrderedProcessor orderedProcessor = new OCCommonProcessors.OrderedProcessor(membersProcessor, symbol -> symbol instanceof OCPropertySymbol && !((OCPropertySymbol)symbol).isReadonly() && objectTypeContext.getStaticMode().fitsStaticness((OCMemberSymbol)symbol), symbol -> symbol instanceof OCInstanceVariableSymbol && ((OCInstanceVariableSymbol)symbol).getGeneratedFromProperty() == null || symbol instanceof OCMethodSymbol && OCNameSuggester.isObjCSetter(symbol.getName()) && objectTypeContext.getStaticMode().fitsStaticness((OCMemberSymbol)symbol), symbol -> symbol instanceof OCPropertySymbol && objectTypeContext.getStaticMode().fitsStaticness((OCMemberSymbol)symbol), symbol -> symbol instanceof OCInstanceVariableSymbol || objectTypeContext.getStaticMode().fitsStaticness((OCMemberSymbol)symbol), processStaticMismatched ? Conditions.alwaysTrue() : Conditions.alwaysFalse());
        objectTypeContext.getType().processMembers(symbolName, OCMemberSymbol.class, orderedProcessor);
        if (symbolName != null && isDotAccess && ((access = new OCReadWriteAccessDetector().getExpressionAccess(this)) == ReadWriteAccessDetector.Access.Write || access == ReadWriteAccessDetector.Access.ReadWrite && !objectTypeContext.getType().processMembers(symbolName, OCMethodSymbol.class, symbol -> symbol.isStatic()))) {
            objectTypeContext.getType().processMembers(OCQualifiedExpressionImpl.getSetterName(symbolName), OCMethodSymbol.class, orderedProcessor);
        }
        return orderedProcessor.finish();
    }

    @Override
    @NotNull
    public CVQualifiers getCVQualifiers() {
        CVQualifiers cVQualifiers = this.getCVQualifiers(this.getQualifier().getResolvedType());
        if (cVQualifiers == null) {
            OCQualifiedExpressionImpl.$$$reportNull$$$0(15);
        }
        return cVQualifiers;
    }

    @NotNull
    public CVQualifiers getCVQualifiers(@NotNull OCType qualifierType) {
        if (qualifierType == null) {
            OCQualifiedExpressionImpl.$$$reportNull$$$0(16);
        }
        CVQualifiers typeAndOuterFunctionQualifiers = OCCodeInsightUtil.getCVQualifiers(this.getQualifier(), qualifierType);
        if (this.getQualifyingTokenKind() == OCTokenTypes.DEREF) {
            if (qualifierType instanceof OCCppReferenceType) {
                qualifierType = ((OCCppReferenceType)qualifierType).getRefType();
            }
            if (qualifierType instanceof OCStructType && OCOperatorReference.resolveDerefOperator(this, (OCStructType)qualifierType) != null) {
                CVQualifiers cVQualifiers = CVQualifiers.EMPTY;
                if (cVQualifiers == null) {
                    OCQualifiedExpressionImpl.$$$reportNull$$$0(17);
                }
                return cVQualifiers;
            }
        }
        CVQualifiers cVQualifiers = typeAndOuterFunctionQualifiers;
        if (cVQualifiers == null) {
            OCQualifiedExpressionImpl.$$$reportNull$$$0(18);
        }
        return cVQualifiers;
    }

    @Nullable
    private OCExprValueCategory getQualifierValueCategory() {
        Object reference = this.getReference();
        try {
            ExternalResolveUtils.prohibitClangResolve();
            OCExprValueCategory oCExprValueCategory = reference != null ? (OCExprValueCategory)((Object)ResolveCache.getInstance((Project)this.getProject()).resolveWithCaching(reference, (ResolveCache.AbstractResolver)new ExprValueCategoryResolver(), false, false)) : null;
            return oCExprValueCategory;
        }
        finally {
            ExternalResolveUtils.allowClangResolve();
        }
    }

    private boolean processStructMembers(String name, Processor<OCSymbol> processor2, boolean filterOverloads, OCResolveContext context, QualifierTypeContext qualifierContext, boolean acceptOnlyCompatible, boolean filterAmbigs, boolean resolveSpecializations) {
        List<OCTypeArgument> typeArguments = OCSymbolReferenceResolver.getTypeArguments(this);
        List<OCSymbol> filtered = OCQualifiedExpressionImpl.getResolvedMembers((OCStructType)qualifierContext.containerType, name, typeArguments, context, resolveSpecializations);
        if (name == null) {
            return ContainerUtil.process(filtered, processor2);
        }
        if (filterOverloads && OCParenthesesUtils.topmostParenthesized(this).getParent() instanceof OCCallExpression) {
            OCType containerType = qualifierContext.containerType;
            CVQualifiers cvQualifiers = this.getCVQualifiers(qualifierContext.qualifierType);
            containerType = containerType.cloneWithAddedCVQualifiers(cvQualifiers, this.getProject());
            OCCallExpression parent = (OCCallExpression)OCParenthesesUtils.topmostParenthesized(this).getParent();
            OCArgumentsList<OCExpression> arguments = OCArgumentsList.getArgumentList(parent.getArguments(), context);
            boolean hasMagic = ((OCStructType)qualifierContext.containerType).getStructs().size() > 1;
            OCSymbol result = OCResolveOverloadsUtil.resolveOverloads(filtered, arguments, containerType, this.getQualifierValueCategory(), null, acceptOnlyCompatible, filterAmbigs, true, hasMagic, false, false, context, this);
            if (result != null) {
                return processor2.process((Object)result);
            }
        } else {
            return ContainerUtil.process(filtered, processor2);
        }
        return true;
    }

    public static List<OCSymbol> getResolvedMembers(OCStructType qualifierType, String memberName, List<OCTypeArgument> typeArguments, OCResolveContext context, boolean resolveSpecializations) {
        ArrayList<OCTemplateSymbol> resolved;
        List<OCCompilerGeneratedConstructorSymbol> filtered;
        OCSymbolReference.UsingAndTypedefSymbolsResolver usingsProcessor = new OCSymbolReference.UsingAndTypedefSymbolsResolver(false, true, false, resolveSpecializations, null, null, context);
        qualifierType.processMembers(memberName, usingsProcessor, context);
        if (OCResolveUtil.isDestructorName(memberName)) {
            filtered = usingsProcessor.getAnswer();
            if (filtered.isEmpty() && memberName.substring(1).equals(qualifierType.getName())) {
                filtered = Collections.singletonList(new OCCompilerGeneratedConstructorSymbol(qualifierType.getSymbol(), OCCompilerGeneratedConstructorSymbol.Kind.DefaultDtor, context.getProject()));
            }
        } else {
            filtered = ContainerUtil.filter(usingsProcessor.getAnswer(), CAN_BE_STRUCTURE_FIELD);
        }
        if (resolveSpecializations && typeArguments != null && !(resolved = new ArrayList<OCTemplateSymbol>(OCSimpleTypeSubstitution.resolveTemplateSpecialization(ContainerUtil.findAll((Collection)filtered, OCTemplateSymbol.class), typeArguments, context))).isEmpty()) {
            filtered = resolved;
        }
        return filtered;
    }

    @Nullable
    private Object getContainerTypeContext(@Nullable OCPunctuatorElementType forcedQualifyingToken, @NotNull OCResolveContext context) {
        OCExpression qualifier;
        if (context == null) {
            OCQualifiedExpressionImpl.$$$reportNull$$$0(19);
        }
        if ((qualifier = OCParenthesesUtils.diveIntoParentheses(this.getQualifier())) == null) {
            return null;
        }
        OCType qualifierType = qualifier.getResolvedType(context);
        if (qualifier instanceof OCSendMessageExpression && OCTypeGuesser.isOfficialNamingConvention(((OCSendMessageExpression)qualifier).getMessageSelector())) {
            qualifierType = qualifierType.getGuessedType();
        }
        if (qualifier instanceof OCQualifiedExpression && OCTypeGuesser.isOfficialNamingConvention(((OCQualifiedExpression)qualifier).getName())) {
            qualifierType = qualifierType.getGuessedType();
        }
        boolean treatIDAsNSObject = forcedQualifyingToken == OCTokenTypes.DEREF;
        OCObjectTypeContext typeContext = qualifier.getTypeContext(qualifier, qualifierType, treatIDAsNSObject, context.isProcessNonImported());
        return typeContext != null ? typeContext : new QualifierTypeContext(qualifierType, this.getQualifierContainerType(qualifierType, forcedQualifyingToken, null));
    }

    private static String getSetterName(String getterName) {
        return "set" + StringUtil.capitalize((String)getterName) + ":";
    }

    @Override
    @Nullable
    public OCSymbol resolveToSymbol() {
        return this.resolveToSymbol(OCResolveContext.forPsi(this), true, false, false);
    }

    @Override
    @Nullable
    public OCSymbol resolveToSymbol(@NotNull OCResolveContext context, boolean filterOverloads, boolean filterAmbigs, boolean acceptOnlyCompatible) {
        if (context == null) {
            OCQualifiedExpressionImpl.$$$reportNull$$$0(20);
        }
        CommonProcessors.FindFirstProcessor collector = new CommonProcessors.FindFirstProcessor();
        this.doProcessTargets(this.getContainerTypeContext(null, context), this.getSymbolName(), (Processor<OCSymbol>)collector, true, filterOverloads, filterAmbigs, acceptOnlyCompatible, context, true);
        return (OCSymbol)collector.getFoundValue();
    }

    @Override
    @NotNull
    public Collection<OCSymbol> resolveToOverloadsSymbols() {
        return this.resolveToOverloadsSymbols(true);
    }

    @Override
    @NotNull
    public Collection<OCSymbol> resolveTemplateDeclarations() {
        return this.resolveToOverloadsSymbols(false);
    }

    @NotNull
    private Collection<OCSymbol> resolveToOverloadsSymbols(boolean resolveSpecializations) {
        CommonProcessors.CollectProcessor collector = new CommonProcessors.CollectProcessor();
        OCResolveContext resolveContext = OCResolveContext.forPsi(this);
        Object qualifierContext = this.getContainerTypeContext(null, resolveContext);
        this.doProcessTargets(qualifierContext, this.getSymbolName(), (Processor<OCSymbol>)collector, true, false, false, false, resolveContext, resolveSpecializations);
        Collection collection = collector.getResults();
        if (collection == null) {
            OCQualifiedExpressionImpl.$$$reportNull$$$0(21);
        }
        return collection;
    }

    @Nullable
    protected PsiReference createReference() {
        return new OCReferenceWithContext(){

            @Contract(pure=true)
            @NotNull
            public PsiElement getElement() {
                OCQualifiedExpressionImpl oCQualifiedExpressionImpl = OCQualifiedExpressionImpl.this;
                if (oCQualifiedExpressionImpl == null) {
                    2.$$$reportNull$$$0(0);
                }
                return oCQualifiedExpressionImpl;
            }

            @NotNull
            public TextRange getRangeInElement() {
                TextRange textRange = OCQualifiedExpressionImpl.this.getRangeInCallElement();
                if (textRange == null) {
                    2.$$$reportNull$$$0(1);
                }
                return textRange;
            }

            public PsiElement resolve() {
                return ExternalResolveUtils.findCombined(this, ref -> {
                    OCSymbol clangSymbol = ExternalResolveUtils.resolveSymbol(ref);
                    if (clangSymbol != null) {
                        PsiElement clangElement = clangSymbol.locateDefinition(OCQualifiedExpressionImpl.this.getProject());
                        ExternalResolveUtils.assertFoundSameElement(clangElement, () -> OCQualifiedExpressionImpl.this.resolve());
                        return clangElement;
                    }
                    return null;
                }, ref -> OCQualifiedExpressionImpl.this.resolve());
            }

            @NotNull
            public String getCanonicalText() {
                String string = OCQualifiedExpressionImpl.this.getSymbolName();
                if (string == null) {
                    2.$$$reportNull$$$0(2);
                }
                return string;
            }

            public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
                if (newElementName == null) {
                    2.$$$reportNull$$$0(3);
                }
                return OCQualifiedExpressionImpl.this.setName(newElementName);
            }

            @Override
            public PsiElement bindToSymbol(@NotNull OCSymbol symbol) {
                String newName;
                String getterFromSetter;
                if (symbol == null) {
                    2.$$$reportNull$$$0(4);
                }
                if ((getterFromSetter = OCNameSuggester.getObjCGetterFromSetter(newName = symbol.getName())) != null) {
                    this.handleElementRename(getterFromSetter);
                } else {
                    this.handleElementRename(newName);
                }
                return this.getElement();
            }

            public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
                Object symbol;
                if (element == null) {
                    2.$$$reportNull$$$0(5);
                }
                return (symbol = ((OCSymbolDeclarator)element).getSymbol()) != null ? this.bindToSymbol((OCSymbol)symbol) : element;
            }

            public boolean isReferenceTo(@NotNull PsiElement element) {
                if (element == null) {
                    2.$$$reportNull$$$0(6);
                }
                if (!(element instanceof OCSymbolDeclarator)) {
                    return false;
                }
                Object symbol = ((OCSymbolDeclarator)element).getSymbol();
                OCSymbol thisSymbol = ExternalResolveUtils.findCombined(this, ref -> ExternalResolveUtils.resolveSymbol(ref), ref -> this.resolveToSymbol());
                if (Comparing.equal((Object)thisSymbol, symbol)) {
                    return true;
                }
                if (symbol instanceof OCMethodSymbol && thisSymbol instanceof OCPropertySymbol) {
                    ReadWriteAccessDetector.Access access = new OCReadWriteAccessDetector().getExpressionAccess(OCQualifiedExpressionImpl.this);
                    if (access == ReadWriteAccessDetector.Access.Read && OCNameSuggester.isObjCSetter(symbol.getName())) {
                        return false;
                    }
                    if (access == ReadWriteAccessDetector.Access.Write && OCNameSuggester.isObjCGetter(symbol.getName())) {
                        return false;
                    }
                    if ((symbol = symbol.getAssociatedSymbol(OCQualifiedExpressionImpl.this.getProject())) != null) {
                        symbol = ((OCMethodSymbol)symbol).getGeneratedFromProperty();
                    }
                    return Comparing.equal((Object)thisSymbol, symbol);
                }
                if (symbol instanceof OCPropertySymbol && thisSymbol instanceof OCMethodSymbol) {
                    if (symbol.equals(((OCMethodSymbol)thisSymbol).getGeneratedFromProperty())) {
                        return true;
                    }
                    return (thisSymbol = thisSymbol.getAssociatedSymbol(OCQualifiedExpressionImpl.this.getProject())) != null && Comparing.equal((Object)((OCMethodSymbol)thisSymbol).getGeneratedFromProperty(), symbol);
                }
                if (thisSymbol instanceof OCFunctionGroupSymbol) {
                    Object finalSymbol = symbol;
                    return ContainerUtil.exists(((OCFunctionGroupSymbol)thisSymbol).getOverloads(), f -> f.isSameSymbol((OCSymbol)finalSymbol, OCQualifiedExpressionImpl.this.getProject()));
                }
                if (thisSymbol != null && thisSymbol.getKind().isTemplateParameter() && symbol != null && !symbol.getKind().isTemplateParameter()) {
                    return true;
                }
                return thisSymbol != null && thisSymbol.isSameSymbol((OCSymbol)symbol, OCQualifiedExpressionImpl.this.getProject());
            }

            public boolean isSoft() {
                return false;
            }

            @Override
            public OCSymbol resolveToSymbol() {
                return OCQualifiedExpressionImpl.this.resolveToSymbol();
            }

            @Nullable
            public OCSymbol resolveToSymbol(@NotNull OCResolveContext context) {
                if (context == null) {
                    2.$$$reportNull$$$0(7);
                }
                return OCQualifiedExpressionImpl.this.resolveToSymbol(context, true, false, false);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 2;
                    case 3, 4, 5, 6, 7 -> 3;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/cidr/lang/psi/impl/OCQualifiedExpressionImpl$2";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "newElementName";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "symbol";
                        break;
                    }
                    case 5: 
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 7: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "context";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getElement";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getRangeInElement";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getCanonicalText";
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/cidr/lang/psi/impl/OCQualifiedExpressionImpl$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "handleElementRename";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray;
                        objectArray[2] = "bindToSymbol";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray;
                        objectArray[2] = "bindToElement";
                        break;
                    }
                    case 6: {
                        objectArray = objectArray;
                        objectArray[2] = "isReferenceTo";
                        break;
                    }
                    case 7: {
                        objectArray = objectArray;
                        objectArray[2] = "resolveToSymbol";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalStateException(string);
                    case 3, 4, 5, 6, 7 -> new IllegalArgumentException(string);
                };
            }
        };
    }

    @Override
    @NotNull
    public OCType getType(@NotNull OCResolveContext context) {
        if (context == null) {
            OCQualifiedExpressionImpl.$$$reportNull$$$0(22);
        }
        Object qualifierContext = this.getContainerTypeContext(null, context);
        CommonProcessors.FindFirstProcessor collector = new CommonProcessors.FindFirstProcessor();
        OCCommonProcessors.OrderedProcessor<OCSymbol> orderedProcessor = new OCCommonProcessors.OrderedProcessor<OCSymbol>((Processor<OCSymbol>)collector, (Condition<? super T>[])new Condition[]{symbol -> symbol instanceof OCMethodSymbol && OCNameSuggester.isObjCGetter(symbol.getName()) && qualifierContext instanceof OCObjectTypeContext && ((OCObjectTypeContext)qualifierContext).getStaticMode() == OCObjectTypeContext.StaticMode.STATIC == ((OCMethodSymbol)symbol).isStatic(), OCSymbol.NON_FANTOM_SYMBOL_CONDITION, Conditions.alwaysTrue()});
        this.doProcessTargets(qualifierContext, this.getSymbolName(), orderedProcessor, true, true, false, false, context, true);
        orderedProcessor.finish();
        OCSymbol symbol2 = (OCSymbol)collector.getFoundValue();
        if (symbol2 != null) {
            if (symbol2 instanceof OCMethodSymbol) {
                OCMethodSymbol methodSymbol = (OCMethodSymbol)symbol2;
                if (OCNameSuggester.isObjCGetter(symbol2.getName())) {
                    OCType type;
                    if (qualifierContext instanceof OCObjectTypeContext) {
                        OCObjectTypeContext objectTypeContext = (OCObjectTypeContext)qualifierContext;
                        type = methodSymbol.getEffectiveType(objectTypeContext.getType(), this).resolve(context);
                        OCType guessedType = OCTypeGuesser.getMethodGuessedReturnType(methodSymbol, objectTypeContext, null, this);
                        if (guessedType != null) {
                            OCType oCType = type.cloneWithGuessedType(guessedType);
                            if (oCType == null) {
                                OCQualifiedExpressionImpl.$$$reportNull$$$0(23);
                            }
                            return oCType;
                        }
                    } else {
                        type = methodSymbol.getEffectiveType(this).resolve(context);
                    }
                    OCType oCType = type;
                    if (oCType == null) {
                        OCQualifiedExpressionImpl.$$$reportNull$$$0(24);
                    }
                    return oCType;
                }
                if (OCNameSuggester.isObjCSetter(symbol2.getName())) {
                    List<OCMethodSymbol.SelectorPartSymbol> selectors = methodSymbol.getSelectors();
                    OCDeclaratorSymbol parameter = selectors.size() == 1 ? selectors.get(0).getParameter() : null;
                    OCType oCType = parameter != null ? parameter.getType() : OCUnknownType.INSTANCE;
                    if (oCType == null) {
                        OCQualifiedExpressionImpl.$$$reportNull$$$0(25);
                    }
                    return oCType;
                }
                OCVoidType oCVoidType = OCVoidType.instance();
                if (oCVoidType == null) {
                    OCQualifiedExpressionImpl.$$$reportNull$$$0(26);
                }
                return oCVoidType;
            }
            OCType oCType = OCTypeUtils.getSymbolType(symbol2, OCSymbolReference.getLocalReference(this.getName(), (PsiElement)this), context);
            if (oCType == null) {
                OCQualifiedExpressionImpl.$$$reportNull$$$0(27);
            }
            return oCType;
        }
        if (qualifierContext instanceof QualifierTypeContext && ((QualifierTypeContext)qualifierContext).qualifierType instanceof OCMagicType || qualifierContext instanceof OCObjectTypeContext && ((OCObjectTypeContext)qualifierContext).getOriginalType() instanceof OCMagicType) {
            return new OCMagicType(this.getSymbolName());
        }
        OCUnknownType oCUnknownType = OCUnknownType.INSTANCE;
        if (oCUnknownType == null) {
            OCQualifiedExpressionImpl.$$$reportNull$$$0(28);
        }
        return oCUnknownType;
    }

    @Override
    public OCTypeArgumentList getTemplateArgumentList() {
        return (OCTypeArgumentList)this.findChildByType((IElementType)OCElementTypes.TEMPLATE_ARGUMENT_LIST);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 15, 17, 18, 21, 23, 24, 25, 26, 27, 28 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 15: 
            case 17: 
            case 18: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/psi/impl/OCQualifiedExpressionImpl";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callExpr";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveContext";
                break;
            }
            case 14: 
            case 19: 
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifierType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/psi/impl/OCQualifiedExpressionImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifier";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifyingTokenKind";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifyingToken";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifyingElement";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "qualifyingTokensForCompletion";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getSymbolName";
                break;
            }
            case 15: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getCVQualifiers";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveToOverloadsSymbols";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 15: 
            case 17: 
            case 18: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getCallExpectedType";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "processTargets";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "doProcessTargets";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getCVQualifiers";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getContainerTypeContext";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "resolveToSymbol";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getType";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 15, 17, 18, 21, 23, 24, 25, 26, 27, 28 -> new IllegalStateException(string);
        };
    }

    private static class QualifierTypeContext {
        OCType qualifierType;
        OCType containerType;

        QualifierTypeContext(OCType qualifierType, OCType containerType) {
            this.qualifierType = qualifierType;
            this.containerType = containerType;
        }
    }

    private static class ExprValueCategoryResolver
    implements ResolveCache.AbstractResolver<PsiReference, OCExprValueCategory> {
        private ExprValueCategoryResolver() {
        }

        public OCExprValueCategory resolve(@NotNull PsiReference reference, boolean incompleteCode) {
            if (reference == null) {
                ExprValueCategoryResolver.$$$reportNull$$$0(0);
            }
            return OCExprValueCategory.classify(((OCQualifiedExpression)reference.getElement()).getQualifier());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/jetbrains/cidr/lang/psi/impl/OCQualifiedExpressionImpl$ExprValueCategoryResolver", "resolve"));
        }
    }
}

