/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.navigation;

import com.intellij.codeInsight.daemon.impl.PsiElementListNavigator;
import com.intellij.codeInsight.navigation.BackgroundUpdaterTask;
import com.intellij.concurrency.SensitiveProgressWrapper;
import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.IPopupChooserBuilder;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.ui.UIBundle;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBList;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.Function;
import com.intellij.util.Query;
import com.intellij.util.concurrency.EdtScheduler;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.navigation.OCGotoAction;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.Comparator;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public abstract class OCGotoActionAsync<Psi extends PsiElement>
extends OCGotoAction<Psi> {
    private static final int POPUP_DELAY_MS = 100;
    @NotNull
    private final Function<? super Psi, ? extends Query<? extends OCSymbol>> myQueryProvider;
    private GotoAsyncUpdater updater;

    public OCGotoActionAsync(@NotNull Psi source, @NotNull Icon icon, @NotNull Function<? super Psi, ? extends Query<? extends OCSymbol>> queryProvider) {
        if (source == null) {
            OCGotoActionAsync.$$$reportNull$$$0(0);
        }
        if (icon == null) {
            OCGotoActionAsync.$$$reportNull$$$0(1);
        }
        if (queryProvider == null) {
            OCGotoActionAsync.$$$reportNull$$$0(2);
        }
        super(source, icon);
        this.updater = null;
        this.myQueryProvider = queryProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void navigate(@Nullable MouseEvent mouseEvent, Editor editor) {
        Object source;
        if (this.updater != null) {
            this.updater.cancelTask();
        }
        if ((source = this.getSource()) == null) {
            return;
        }
        ProgressIndicatorBase queryIndicator = new ProgressIndicatorBase();
        Promise queryPromise = Promises.runAsync(() -> this.lambda$navigate$3(source, (ProgressIndicator)queryIndicator));
        boolean success = false;
        try {
            success = this.doNavigate((Promise<Query<OCSymbol>>)queryPromise, (ProgressIndicator)queryIndicator, mouseEvent, editor, source);
        }
        finally {
            if (!success) {
                queryIndicator.cancel();
            }
        }
    }

    private boolean doNavigate(@NotNull Promise<Query<? extends OCSymbol>> queryPromise, @NotNull ProgressIndicator queryIndicator, @Nullable MouseEvent mouseEvent, Editor editor, @NotNull Psi source) {
        if (queryPromise == null) {
            OCGotoActionAsync.$$$reportNull$$$0(3);
        }
        if (queryIndicator == null) {
            OCGotoActionAsync.$$$reportNull$$$0(4);
        }
        if (source == null) {
            OCGotoActionAsync.$$$reportNull$$$0(5);
        }
        Project project = source.getProject();
        AtomicReference firstTargetRef = new AtomicReference();
        boolean finished = OCGotoActionAsync.runAndWait(this.getProgressTitle(), 100, firstTargetRef, () -> {
            OCSymbol firstTarget;
            Query query = (Query)OCGotoActionAsync.waitForPromise(queryPromise);
            if (query == null) {
                return null;
            }
            Query query2 = query;
            synchronized (query2) {
                firstTarget = (OCSymbol)query.findFirst();
            }
            if (firstTarget == null) {
                return null;
            }
            PsiElement firstPsiTarget = firstTarget.locateDefinition(project);
            if (!(firstPsiTarget instanceof NavigatablePsiElement)) {
                return null;
            }
            return (NavigatablePsiElement)firstPsiTarget;
        });
        NavigatablePsiElement element = (NavigatablePsiElement)firstTargetRef.get();
        if (finished && element == null) {
            return false;
        }
        NavigatablePsiElement[] firstTargets = element != null ? new NavigatablePsiElement[]{element} : NavigatablePsiElement.EMPTY_NAVIGATABLE_ELEMENT_ARRAY;
        PsiElementListCellRenderer<PsiElement> renderer = this.createRenderer(source, (PsiElement[])firstTargets);
        this.updater = this.createGotoAsyncUpdater(project, queryPromise, queryIndicator, renderer.getComparator());
        if (this.createAndShowPopup(firstTargets, project, renderer, mouseEvent, editor)) {
            assert (this.updater != null) : "How is this possible?";
            ProgressManager.getInstance().run((Task)this.updater);
            return true;
        }
        return false;
    }

    private boolean createAndShowPopup(@NotNull @NotNull NavigatablePsiElement @NotNull [] firstTargets, @NotNull Project project, @NotNull PsiElementListCellRenderer<PsiElement> renderer, @Nullable MouseEvent mouseEvent, Editor editor) {
        String popupTitle;
        CustomNavigateOrPopupHelper helper;
        JBPopup popup;
        if (project == null) {
            OCGotoActionAsync.$$$reportNull$$$0(6);
        }
        if (renderer == null) {
            OCGotoActionAsync.$$$reportNull$$$0(7);
        }
        if (firstTargets == null) {
            OCGotoActionAsync.$$$reportNull$$$0(8);
        }
        if ((popup = (helper = new CustomNavigateOrPopupHelper(firstTargets, popupTitle = this.getPopupTitle())).setFindUsagesTitle(popupTitle).setListRenderer(renderer).setListUpdaterTask((BackgroundUpdaterTask)this.updater).setProject(project).navigateOrCreatePopup()) == null) {
            return false;
        }
        if (helper.getContentsList() != null) {
            helper.getContentsList().setEmptyText(OCBundle.message("navigation.goto.please.wait", new Object[0]));
            if (this.updater != null) {
                this.updater.setPopupContentsList(helper.getContentsList());
            }
        }
        this.showPopupWithOptionalDelay(popup, mouseEvent, editor);
        return true;
    }

    private void showPopupWithOptionalDelay(@NotNull JBPopup popup, @Nullable MouseEvent mouseEvent, Editor editor) {
        if (popup == null) {
            OCGotoActionAsync.$$$reportNull$$$0(9);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            OCGotoActionAsync.doShowPopup(popup, mouseEvent, editor);
            return;
        }
        EdtScheduler.getInstance().schedule(100, ModalityState.defaultModalityState(), () -> {
            if (this.updater.isCanceled() || this.updater.isFinished() && this.updater.getCurrentSize() == 1) {
                return;
            }
            OCGotoActionAsync.doShowPopup(popup, mouseEvent, editor);
        });
    }

    private static void doShowPopup(@NotNull JBPopup popup, @Nullable MouseEvent mouseEvent, Editor editor) {
        if (popup == null) {
            OCGotoActionAsync.$$$reportNull$$$0(10);
        }
        if (mouseEvent != null) {
            RelativePoint point = new RelativePoint(mouseEvent);
            popup.show(point);
        } else {
            popup.showInBestPositionFor(editor);
        }
    }

    @NotNull
    protected GotoAsyncUpdater createGotoAsyncUpdater(@Nullable Project project, @NotNull Promise<? extends Query<? extends OCSymbol>> targetQueryPromise, @NotNull ProgressIndicator queryIndicator, @Nullable Comparator<? super PsiElement> comparator) {
        if (targetQueryPromise == null) {
            OCGotoActionAsync.$$$reportNull$$$0(11);
        }
        if (queryIndicator == null) {
            OCGotoActionAsync.$$$reportNull$$$0(12);
        }
        return new GotoAsyncUpdater(project, targetQueryPromise, queryIndicator, comparator);
    }

    @Override
    @Nullable
    public Collection<OCSymbol> getTargets() {
        Object source = this.getSource();
        if (source == null) {
            return null;
        }
        return ((Query)this.myQueryProvider.fun(source)).findAll();
    }

    @Nullable
    private static <T> T waitForPromise(@NotNull Promise<T> promise) {
        if (promise == null) {
            OCGotoActionAsync.$$$reportNull$$$0(13);
        }
        while (promise.getState() == Promise.State.PENDING) {
            ProgressManager.checkCanceled();
            try {
                return (T)promise.blockingGet(50, TimeUnit.MILLISECONDS);
            }
            catch (TimeoutException timeoutException) {
            }
            catch (ExecutionException ex) {
                return null;
            }
        }
        if (promise.getState() == Promise.State.SUCCEEDED) {
            try {
                return (T)promise.blockingGet(Integer.MAX_VALUE);
            }
            catch (ExecutionException | TimeoutException ex) {
                LOG.error((Throwable)ex);
            }
        }
        return null;
    }

    private static <T> boolean runAndWait(@NotNull @NonNls String progressTitle, int timeoutMilliseconds, @NotNull AtomicReference<T> result, @NotNull ThrowableComputable<? extends T, ? extends RuntimeException> task2) {
        if (progressTitle == null) {
            OCGotoActionAsync.$$$reportNull$$$0(14);
        }
        if (result == null) {
            OCGotoActionAsync.$$$reportNull$$$0(15);
        }
        if (task2 == null) {
            OCGotoActionAsync.$$$reportNull$$$0(16);
        }
        ThreadingAssertions.assertEventDispatchThread();
        if (ApplicationManager.getApplication().isWriteAccessAllowed()) {
            return false;
        }
        AtomicReference exception = new AtomicReference();
        ProgressIndicatorBase indicator = new ProgressIndicatorBase();
        Future future = ApplicationManager.getApplication().executeOnPooledThread(ConcurrencyUtil.underThreadNameRunnable((String)progressTitle, () -> OCGotoActionAsync.lambda$runAndWait$8(task2, result, exception, (ProgressIndicator)indicator)));
        try {
            future.get(timeoutMilliseconds, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException ex) {
            indicator.cancel();
            return false;
        }
        Throwable ex = (Throwable)exception.get();
        if (ex != null && !(ex instanceof ControlFlowException)) {
            ExceptionUtil.rethrowUnchecked((Throwable)((Throwable)exception.get()));
        }
        return true;
    }

    private static /* synthetic */ void lambda$runAndWait$8(ThrowableComputable task2, AtomicReference result, AtomicReference exception, ProgressIndicator indicator) {
        ProgressManager.getInstance().executeProcessUnderProgress(() -> {
            try {
                Object value = ProgressManager.getInstance().computePrioritized(() -> ReadAction.compute((ThrowableComputable)task2));
                result.set(value);
            }
            catch (Throwable thr) {
                exception.set(thr);
            }
        }, indicator);
    }

    private /* synthetic */ Query lambda$navigate$3(PsiElement source, ProgressIndicator queryIndicator) {
        Ref result = Ref.create();
        ConcurrencyUtil.runUnderThreadName((String)"Creating goto query...", () -> ReadAction.run(() -> ProgressManager.getInstance().executeProcessUnderProgress(() -> result.set((Object)((Query)this.myQueryProvider.fun((Object)source))), queryIndicator)));
        return (Query)result.get();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "queryProvider";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "queryPromise";
                break;
            }
            case 4: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "queryIndicator";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderer";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "firstTargets";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "popup";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetQueryPromise";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "promise";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressTitle";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/lang/navigation/OCGotoActionAsync";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "doNavigate";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "createAndShowPopup";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "showPopupWithOptionalDelay";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "doShowPopup";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "createGotoAsyncUpdater";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "waitForPromise";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "runAndWait";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    protected class GotoAsyncUpdater
    extends BackgroundUpdaterTask {
        @NotNull
        private final Promise<? extends Query<? extends OCSymbol>> myTargetQueryPromise;
        @NotNull
        private final ProgressIndicator myQueryIndicator;
        @Nullable
        private JBList<?> myPopupContentsList;

        public GotoAsyncUpdater(@NotNull Project project, @NotNull Promise<? extends Query<? extends OCSymbol>> targetQueryPromise, @Nullable ProgressIndicator queryIndicator, Comparator<? super PsiElement> comparator) {
            if (targetQueryPromise == null) {
                GotoAsyncUpdater.$$$reportNull$$$0(0);
            }
            if (queryIndicator == null) {
                GotoAsyncUpdater.$$$reportNull$$$0(1);
            }
            super(project, OCGotoActionAsync.this.getProgressTitle(), comparator);
            this.myTargetQueryPromise = targetQueryPromise;
            this.myQueryIndicator = queryIndicator;
        }

        public String getCaption(int size) {
            if (this.isFinished()) {
                return size == 1 ? OCBundle.message("popup.title.element.found.singular", OCGotoActionAsync.this.getPopupTitle(), size) : OCBundle.message("popup.title.elements.found.plural", OCGotoActionAsync.this.getPopupTitle(), size);
            }
            return size == 1 ? OCBundle.message("popup.title.element.found.so.far.singular", OCGotoActionAsync.this.getPopupTitle(), size) : OCBundle.message("popup.title.elements.found.so.far.plural", OCGotoActionAsync.this.getPopupTitle(), size);
        }

        public void run(@NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                GotoAsyncUpdater.$$$reportNull$$$0(2);
            }
            super.run(indicator);
            Runnable action = () -> {
                Query<? extends OCSymbol> targetQuery = OCGotoActionAsync.waitForPromise(this.myTargetQueryPromise);
                if (targetQuery == null) {
                    indicator.cancel();
                    return;
                }
                Query<? extends OCSymbol> query = targetQuery;
                synchronized (query) {
                    targetQuery.forEach(symbol -> {
                        PsiElement element = symbol.locateDefinition(this.myProject);
                        if (element != null) {
                            if (!this.updateComponent(element)) {
                                indicator.cancel();
                            }
                            return !indicator.isCanceled();
                        }
                        return true;
                    });
                }
            };
            Ref result = new Ref((Object)Boolean.FALSE);
            boolean success = ProgressIndicatorUtils.runWithWriteActionPriority(() -> result.set((Object)ApplicationManagerEx.getApplicationEx().tryRunReadAction(action)), (ProgressIndicator)new SensitiveProgressWrapper(indicator));
            if (!success || !((Boolean)result.get()).booleanValue()) {
                UIUtil.invokeAndWaitIfNeeded(() -> this.myPopup.cancel());
            }
        }

        public void onSuccess() {
            super.onSuccess();
            PsiElement oneElement = this.getTheOnlyOneElement();
            if (oneElement instanceof NavigatablePsiElement) {
                ((NavigatablePsiElement)oneElement).navigate(true);
                this.myPopup.cancel();
            }
        }

        public void onFinished() {
            super.onFinished();
            this.myQueryIndicator.cancel();
            if (this.getCurrentSize() == 0) {
                if (this.myPopupContentsList != null) {
                    this.myPopupContentsList.setEmptyText(UIBundle.message((String)"message.noMatchesFound", (Object[])new Object[0]));
                } else {
                    this.myPopup.cancel();
                }
            }
        }

        private void setPopupContentsList(@Nullable JBList<?> popupContentsList) {
            this.myPopupContentsList = popupContentsList;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "targetQueryPromise";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "queryIndicator";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/cidr/lang/navigation/OCGotoActionAsync$GotoAsyncUpdater";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "run";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class CustomNavigateOrPopupHelper
    extends PsiElementListNavigator.NavigateOrPopupHelper<NavigatablePsiElement> {
        @Nullable
        private JBList<NavigatablePsiElement> myContentsList;

        private CustomNavigateOrPopupHelper(NavigatablePsiElement @NotNull [] targets, @NlsContexts.PopupTitle @NotNull String title) {
            if (title == null) {
                CustomNavigateOrPopupHelper.$$$reportNull$$$0(0);
            }
            if (targets == null) {
                CustomNavigateOrPopupHelper.$$$reportNull$$$0(1);
            }
            super(targets, title);
        }

        protected boolean allowEmptyTargets() {
            return true;
        }

        protected void afterPopupBuilderCreated(@NotNull IPopupChooserBuilder<NavigatablePsiElement> builder) {
            JComponent chooser;
            if (builder == null) {
                CustomNavigateOrPopupHelper.$$$reportNull$$$0(2);
            }
            super.afterPopupBuilderCreated(builder);
            if (builder instanceof PopupChooserBuilder && (chooser = ((PopupChooserBuilder)builder).getChooserComponent()) instanceof JBList) {
                this.myContentsList = (JBList)chooser;
            }
        }

        @Nullable
        private JBList<NavigatablePsiElement> getContentsList() {
            return this.myContentsList;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "title";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "targets";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "builder";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/cidr/lang/navigation/OCGotoActionAsync$CustomNavigateOrPopupHelper";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "afterPopupBuilderCreated";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

