/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.navigation;

import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.ui.IconManager;
import com.intellij.ui.breadcrumbs.BreadcrumbsProvider;
import com.jetbrains.cidr.lang.LanguageUtils;
import com.jetbrains.cidr.lang.parser.OCLexerTokenTypes;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCClassDeclarationBase;
import com.jetbrains.cidr.lang.psi.OCCppNamespace;
import com.jetbrains.cidr.lang.psi.OCCppNamespaceQualifier;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCEnum;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCLambdaExpression;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.psi.OCNamespaceQualifierOwner;
import com.jetbrains.cidr.lang.psi.OCParameterList;
import com.jetbrains.cidr.lang.psi.OCStruct;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.psi.OCUnion;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.Objects;
import javax.swing.Icon;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class OCBreadcrumbsProvider
implements BreadcrumbsProvider {
    private static final int MAX_CRUMB_LENGTH = 48;
    private static final Language[] ourLanguages = new Language[]{LanguageUtils.getInstance().getSlowLanguage()};

    public Language[] getLanguages() {
        if (ApplicationManager.getApplication().isUnitTestMode() || Registry.is((String)"cidr.show.breadcrumbs")) {
            return ourLanguages;
        }
        return Language.EMPTY_ARRAY;
    }

    public boolean acceptElement(@NotNull PsiElement e) {
        if (e == null) {
            OCBreadcrumbsProvider.$$$reportNull$$$0(0);
        }
        return e instanceof OCCppNamespace || e instanceof OCStruct || e instanceof OCEnum || e instanceof OCUnion || e instanceof OCFunctionDeclaration || e instanceof OCLambdaExpression || e instanceof OCClassDeclarationBase || e instanceof OCMethod;
    }

    @NotNull
    public String getElementInfo(@NotNull PsiElement e) {
        String symbolName;
        OCClassDeclaration cls;
        String name;
        if (e == null) {
            OCBreadcrumbsProvider.$$$reportNull$$$0(1);
        }
        if (e instanceof OCLambdaExpression) {
            PsiElement psiElement = e.getParent();
            if (psiElement instanceof OCDeclarator) {
                OCDeclarator declarator = (OCDeclarator)psiElement;
                return OCBreadcrumbsProvider.prepareCrumb(declarator.getName());
            }
            OCLambdaExpression exprNode = (OCLambdaExpression)e;
            return OCBreadcrumbsProvider.prepareCrumb(OCBreadcrumbsProvider.getLambdaPresentableName(exprNode));
        }
        if (e instanceof OCClassDeclaration && (name = (cls = (OCClassDeclaration)e).getName()) != null) {
            return OCBreadcrumbsProvider.prepareCrumb(OCCodeInsightUtil.getClassNameWithCategory(name, cls.getCategory()));
        }
        if (e instanceof OCNamespaceQualifierOwner) {
            String symbolName2;
            String qualText;
            OCCppNamespaceQualifier qualifier = ((OCNamespaceQualifierOwner)e).getNamespaceQualifier();
            String string = qualText = qualifier != null ? qualifier.getText() : null;
            if (qualText != null && (symbolName2 = OCElementUtil.getSymbolName(e)) != null) {
                return OCBreadcrumbsProvider.prepareCrumb(qualText + OCLexerTokenTypes.COLON2X.getName() + symbolName2);
            }
        }
        if ((symbolName = OCElementUtil.getSymbolName(e)) != null) {
            return OCBreadcrumbsProvider.prepareCrumb(symbolName);
        }
        return "<unnamed>";
    }

    @Nullable
    public Icon getElementIcon(@NotNull PsiElement element) {
        if (element == null) {
            OCBreadcrumbsProvider.$$$reportNull$$$0(2);
        }
        Icon baseIcon = OCBreadcrumbsProvider.getElementBaseIcon(element);
        if (element instanceof OCSymbolDeclarator && !(element instanceof OCLambdaExpression) && Registry.is((String)"cidr.crumbs.featured.icons")) {
            if (Registry.is((String)"psi.deferIconLoading")) {
                VirtualFile file = element.getContainingFile().getViewProvider().getVirtualFile();
                return IconManager.getInstance().createDeferredIcon(baseIcon, (Object)new LightIconKey(file, file.getTimeStamp(), element.getTextOffset()), key -> OCBreadcrumbsProvider.computeFullIconNow((OCSymbolDeclarator)element, baseIcon));
            }
            return OCBreadcrumbsProvider.computeFullIconNow((OCSymbolDeclarator)element, baseIcon);
        }
        return baseIcon;
    }

    @Nullable
    private static Icon computeFullIconNow(@NotNull OCSymbolDeclarator<?> symbolDeclarator, @Nullable Icon baseIcon) {
        Object symbol;
        if (symbolDeclarator == null) {
            OCBreadcrumbsProvider.$$$reportNull$$$0(3);
        }
        if (symbolDeclarator.isValid() && (symbol = symbolDeclarator.getSymbol()) != null) {
            return symbol.computeFullIconNow(symbolDeclarator, symbolDeclarator.getProject());
        }
        return baseIcon;
    }

    @Nullable
    private static Icon getElementBaseIcon(@NotNull PsiElement element) {
        if (element == null) {
            OCBreadcrumbsProvider.$$$reportNull$$$0(4);
        }
        if (element instanceof OCCppNamespace) {
            return OCSymbolKind.NAMESPACE.getIcon();
        }
        if (element instanceof OCStruct) {
            return OCSymbolKind.STRUCT.getIcon();
        }
        if (element instanceof OCEnum) {
            return OCSymbolKind.ENUM.getIcon();
        }
        if (element instanceof OCUnion) {
            return OCSymbolKind.UNION.getIcon();
        }
        if (element instanceof OCFunctionDeclaration) {
            return OCSymbolKind.FUNCTION_DECLARATION.getIcon();
        }
        if (element instanceof OCLambdaExpression) {
            return OCSymbolKind.FUNCTION_DECLARATION.getIcon();
        }
        return null;
    }

    @Nullable
    public String getElementTooltip(@NotNull PsiElement e) {
        if (e == null) {
            OCBreadcrumbsProvider.$$$reportNull$$$0(5);
        }
        return null;
    }

    @NotNull
    private static String getLambdaPresentableName(@NotNull OCLambdaExpression lambdaNode) {
        if (lambdaNode == null) {
            OCBreadcrumbsProvider.$$$reportNull$$$0(6);
        }
        StringBuilder lambdaText = new StringBuilder();
        String introducerText = lambdaNode.getLambdaIntroducer().getText();
        lambdaText.append(introducerText != null ? introducerText : "[]");
        lambdaText.append("(");
        OCParameterList parameterList = lambdaNode.getParameterList();
        if (parameterList != null && !parameterList.isEmpty()) {
            boolean first = true;
            for (OCDeclarator param : parameterList.getParameters()) {
                if (!first) {
                    lambdaText.append(", ");
                }
                OCType paramType = param.getResolvedType(OCResolveContext.forPsi(lambdaNode));
                lambdaText.append(paramType.getBestNameInContext(lambdaNode));
                first = false;
            }
        }
        lambdaText.append(")");
        String string = lambdaText.toString();
        if (string == null) {
            OCBreadcrumbsProvider.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    private static String prepareCrumb(@NotNull String crumb) {
        if (crumb == null) {
            OCBreadcrumbsProvider.$$$reportNull$$$0(8);
        }
        return OCBreadcrumbsProvider.ensureFits(OCBreadcrumbsProvider.trimWhitespaces(crumb));
    }

    @NotNull
    private static String trimWhitespaces(@NotNull String text) {
        if (text == null) {
            OCBreadcrumbsProvider.$$$reportNull$$$0(9);
        }
        if (StringUtil.containsWhitespaces((CharSequence)text)) {
            StringBuilder sb = new StringBuilder();
            boolean wsFound = false;
            for (int i = 0; i < text.length(); ++i) {
                char ch = text.charAt(i);
                if (Character.isWhitespace(ch)) {
                    if (wsFound) continue;
                    sb.append(" ");
                    wsFound = true;
                    continue;
                }
                sb.append(ch);
                wsFound = false;
            }
            String string = sb.toString();
            if (string == null) {
                OCBreadcrumbsProvider.$$$reportNull$$$0(10);
            }
            return string;
        }
        String string = text;
        if (string == null) {
            OCBreadcrumbsProvider.$$$reportNull$$$0(11);
        }
        return string;
    }

    @NotNull
    private static String ensureFits(@NotNull String text) {
        if (text == null) {
            OCBreadcrumbsProvider.$$$reportNull$$$0(12);
        }
        String string = StringUtil.shortenTextWithEllipsis((String)text, (int)48, (int)0);
        if (string == null) {
            OCBreadcrumbsProvider.$$$reportNull$$$0(13);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 10, 11, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbolDeclarator";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lambdaNode";
                break;
            }
            case 7: 
            case 10: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/navigation/OCBreadcrumbsProvider";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "crumb";
                break;
            }
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/navigation/OCBreadcrumbsProvider";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getLambdaPresentableName";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "trimWhitespaces";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "ensureFits";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "acceptElement";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getElementInfo";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getElementIcon";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "computeFullIconNow";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getElementBaseIcon";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getElementTooltip";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getLambdaPresentableName";
                break;
            }
            case 7: 
            case 10: 
            case 11: 
            case 13: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "prepareCrumb";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "trimWhitespaces";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "ensureFits";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 10, 11, 13 -> new IllegalStateException(string);
        };
    }

    private static class LightIconKey {
        private final VirtualFile myFile;
        private final long myStamp;
        private final int myOffset;

        /*
         * WARNING - void declaration
         */
        @Contract(pure=true)
        LightIconKey(@NotNull VirtualFile file, long stamp, int n) {
            void offset;
            if (file == null) {
                LightIconKey.$$$reportNull$$$0(0);
            }
            this.myFile = file;
            this.myStamp = stamp;
            this.myOffset = offset;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LightIconKey key = (LightIconKey)o;
            return this.myStamp == key.myStamp && this.myOffset == key.myOffset && Objects.equals(this.myFile, key.myFile);
        }

        public int hashCode() {
            return Objects.hash(this.myFile, this.myStamp, this.myOffset);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/cidr/lang/navigation/OCBreadcrumbsProvider$LightIconKey", "<init>"));
        }
    }
}

