/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor.smartEnter;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.editor.smartEnter.OCFixer;
import com.jetbrains.cidr.lang.editor.smartEnter.OCSmartEnterProcessor;
import com.jetbrains.cidr.lang.parser.OCLexerTokenTypes;
import com.jetbrains.cidr.lang.psi.OCCaseStatement;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CaseColonFixer
extends OCFixer {
    public void apply(@NotNull Editor editor, @NotNull OCSmartEnterProcessor processor2, @NotNull PsiElement psiElement) throws IncorrectOperationException {
        if (editor == null) {
            CaseColonFixer.$$$reportNull$$$0(0);
        }
        if (processor2 == null) {
            CaseColonFixer.$$$reportNull$$$0(1);
        }
        if (psiElement == null) {
            CaseColonFixer.$$$reportNull$$$0(2);
        }
        if (psiElement instanceof OCCaseStatement) {
            TextRange range;
            int caretOffset = editor.getCaretModel().getOffset();
            Document document = editor.getDocument();
            if (document.getLineNumber((range = OCChangeUtil.getRangeWithMacros(psiElement)).getStartOffset()) == document.getLineNumber(caretOffset) || range.contains(caretOffset)) {
                OCExpression beforeColon = ((OCCaseStatement)psiElement).getExpression();
                if (beforeColon == null && OCElementUtil.getElementType(beforeColon = psiElement.getFirstChild()) != OCLexerTokenTypes.DEFAULT_KEYWORD) {
                    beforeColon = null;
                }
                if (beforeColon != null) {
                    int offset;
                    ASTNode colon = CaseColonFixer.findFirstColonInCase(psiElement);
                    if (colon != null) {
                        offset = CaseColonFixer.getRangeWithMacros(colon).getEndOffset();
                    } else {
                        offset = OCChangeUtil.getRangeWithMacros(beforeColon).getEndOffset();
                        document.insertString(offset, (CharSequence)":");
                        ++offset;
                    }
                    editor.getCaretModel().moveToOffset(offset);
                }
            }
        }
    }

    @Nullable
    public static ASTNode findFirstColonInCase(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            CaseColonFixer.$$$reportNull$$$0(3);
        }
        return psiElement.getNode().findChildByType((IElementType)OCLexerTokenTypes.COLON);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/lang/editor/smartEnter/CaseColonFixer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "apply";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "findFirstColonInCase";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

