/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.documentation;

import com.intellij.psi.PsiElement;
import com.jetbrains.cidr.lang.documentation.CppReferenceDocumentationUtilKt;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.cpp.OCAliasUsingSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\u001b\u0010\u0010\u001a\r\u0012\t\u0012\u00070\u0005\u00a2\u0006\u0002\b\u00120\u00112\u0006\u0010\f\u001a\u00020\rH\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/cidr/lang/documentation/CppReferenceDocumentationUtil;", "", "<init>", "()V", "searchUrl", "", "siteSuffix", "invalidSymbolKinds", "", "Lcom/jetbrains/cidr/lang/symbols/OCSymbolKind;", "getSymbolWithQualifiedName", "Lcom/jetbrains/cidr/lang/symbols/cpp/OCSymbolWithQualifiedName;", "elem", "Lcom/intellij/psi/PsiElement;", "resolveUsing", "", "getUrlFor", "", "Lcom/intellij/openapi/util/NlsSafe;", "intellij.c.core"})
public final class CppReferenceDocumentationUtil {
    @NotNull
    public static final CppReferenceDocumentationUtil INSTANCE = new CppReferenceDocumentationUtil();
    @NotNull
    private static final String searchUrl = "https://duckduckgo.com/?q=!ducky+";
    @NotNull
    private static final String siteSuffix = "+site%3Acppreference.com";
    @NotNull
    private static final Set<OCSymbolKind> invalidSymbolKinds;

    private CppReferenceDocumentationUtil() {
    }

    @JvmStatic
    @Nullable
    public static final OCSymbolWithQualifiedName getSymbolWithQualifiedName(@NotNull PsiElement elem, boolean resolveUsing) {
        Intrinsics.checkNotNullParameter((Object)elem, (String)"elem");
        OCSymbolDeclarator oCSymbolDeclarator = elem instanceof OCSymbolDeclarator ? (OCSymbolDeclarator)elem : null;
        if (oCSymbolDeclarator == null) {
            return null;
        }
        OCSymbolDeclarator symbolDecl = oCSymbolDeclarator;
        Object t = symbolDecl.getSymbol();
        OCSymbolWithQualifiedName oCSymbolWithQualifiedName = t instanceof OCSymbolWithQualifiedName ? (OCSymbolWithQualifiedName)t : null;
        if (oCSymbolWithQualifiedName == null) {
            return null;
        }
        OCSymbolWithQualifiedName qualifiedSym = oCSymbolWithQualifiedName;
        if (qualifiedSym instanceof OCAliasUsingSymbol && resolveUsing) {
            OCType oCType = ((OCAliasUsingSymbol)qualifiedSym).getType().resolve(elem);
            Intrinsics.checkNotNullExpressionValue((Object)oCType, (String)"resolve(...)");
            OCType type = oCType;
            if (type instanceof OCStructType) {
                return ((OCStructType)type).getSymbol();
            }
        }
        return qualifiedSym;
    }

    @JvmStatic
    @NotNull
    public static final List<String> getUrlFor(@NotNull PsiElement elem) {
        Intrinsics.checkNotNullParameter((Object)elem, (String)"elem");
        OCSymbolWithQualifiedName oCSymbolWithQualifiedName = CppReferenceDocumentationUtil.getSymbolWithQualifiedName(elem, true);
        if (oCSymbolWithQualifiedName == null) {
            return CollectionsKt.emptyList();
        }
        OCSymbolWithQualifiedName symbol = oCSymbolWithQualifiedName;
        if (invalidSymbolKinds.contains((Object)symbol.getKind()) || !CppReferenceDocumentationUtilKt.access$isInStdNamespace(symbol)) {
            return CollectionsKt.emptyList();
        }
        OCResolveContext oCResolveContext = OCResolveContext.forSymbol(symbol, elem.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)oCResolveContext, (String)"forSymbol(...)");
        OCResolveContext context = oCResolveContext;
        OCQualifiedName oCQualifiedName = symbol.getResolvedQualifiedNameWithoutArguments(context);
        if (oCQualifiedName == null) {
            return CollectionsKt.emptyList();
        }
        OCQualifiedName qualifiedName = oCQualifiedName;
        String string = qualifiedName.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String name = CppReferenceDocumentationUtilKt.access$cleanSymbolName(string);
        String url = searchUrl + name + siteSuffix;
        return CollectionsKt.listOf((Object)url);
    }

    static {
        OCSymbolKind[] oCSymbolKindArray = new OCSymbolKind[]{OCSymbolKind.NAMESPACE, OCSymbolKind.NAMESPACE_ALIAS, OCSymbolKind.NAMESPACE_USING_SYMBOL};
        invalidSymbolKinds = SetsKt.setOf((Object[])oCSymbolKindArray);
    }
}

