/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.IntentionManager;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.limits.FileSizeLimit;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.daemon.FileWideHighlighterFactory;
import com.jetbrains.cidr.lang.daemon.OCCodeInsightUnavailabilityHighlighter;
import com.jetbrains.cidr.lang.daemon.OCCodeInsightUnavailableInfo;
import com.jetbrains.cidr.lang.parser.OCLexerTokenTypes;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContext;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesCache;
import com.jetbrains.cidr.lang.symbols.symtable.building.OCSymbolTablesBuildingActivity;
import com.jetbrains.cidr.lang.symbols.symtable.building.OCSymbolTablesBuildingMode;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class OCCodeInsightUnavailabilityHighlighterImpl
implements OCCodeInsightUnavailabilityHighlighter {
    @Nullable
    public OCCodeInsightUnavailableInfo check(@NotNull Project project, @NotNull PsiFile file) {
        String message;
        if (project == null) {
            OCCodeInsightUnavailabilityHighlighterImpl.$$$reportNull$$$0(0);
        }
        if (file == null) {
            OCCodeInsightUnavailabilityHighlighterImpl.$$$reportNull$$$0(1);
        }
        if (!(file instanceof OCFile)) {
            return null;
        }
        long textLength = file.getViewProvider().getVirtualFile().getLength();
        boolean isCodeInsightLimit = true;
        String languageName = file.getLanguage().getDisplayName();
        if (!OCCodeInsightUtil.isCodeInsightAvailable(file)) {
            int maxFileLength = OCCodeInsightUtil.getMaxFileLength();
            message = OCBundle.message("inspections.fileChecks.sourceTooLarge", StringUtil.formatFileSize((long)textLength), languageName, StringUtil.formatFileSize((long)maxFileLength));
        } else {
            if (DumbService.isDumb((Project)project) || !FileSymbolTablesCache.areSymbolsLoaded(project)) {
                return null;
            }
            String tooLongInlineHeader = OCCodeInsightUnavailabilityHighlighterImpl.findTooLongInlineHeader((ASTNode)file.getNode());
            if (tooLongInlineHeader != null) {
                String[] comps = tooLongInlineHeader.split(":");
                OCLog.LOG.assertTrue(comps.length == 3, (Object)comps.length);
                tooLongInlineHeader = comps[0];
                int length = Integer.parseInt(comps[1]);
                isCodeInsightLimit = Boolean.parseBoolean(comps[2]);
                tooLongInlineHeader = OCInclusionContext.extractPath(tooLongInlineHeader, false).getPath();
                message = isCodeInsightLimit ? OCBundle.message("inspections.fileChecks.headerTooLarge", StringUtil.formatFileSize((long)length), languageName, StringUtil.formatFileSize((long)OCCodeInsightUtil.getMaxFileLength()), tooLongInlineHeader) : OCBundle.message("inspections.fileChecks.headerTooLargePlatform", StringUtil.formatFileSize((long)length), StringUtil.formatFileSize((long)FileSizeLimit.getIntellisenseLimit((String)FileUtilRt.getExtension((String)file.getName()))), tooLongInlineHeader);
            } else {
                return null;
            }
        }
        ArrayList<ChangeMaximumFileLengthAction> fixes = new ArrayList<ChangeMaximumFileLengthAction>();
        if (isCodeInsightLimit) {
            ChangeMaximumFileLengthAction fix = new ChangeMaximumFileLengthAction(languageName);
            fixes.add(fix);
        }
        return new OCCodeInsightUnavailableInfo(message, fixes);
    }

    private static void adjustMaxFileSize(@NotNull Project project, @Nullable Document document, @NotNull String languageName) {
        OCSymbolTablesBuildingActivity activity;
        if (project == null) {
            OCCodeInsightUnavailabilityHighlighterImpl.$$$reportNull$$$0(2);
        }
        if (languageName == null) {
            OCCodeInsightUnavailabilityHighlighterImpl.$$$reportNull$$$0(3);
        }
        int initialValue = OCCodeInsightUtil.getMaxFileLength();
        String result = Messages.showInputDialog((Project)project, (String)OCBundle.message("highlighter.change.file.length.limit.input", languageName), (String)OCBundle.message("highlighter.max.file.length.title", new Object[0]), null, (String)String.valueOf(initialValue), (InputValidator)new InputValidator(){

            public boolean checkInput(String inputString) {
                return StringUtil.parseInt((String)inputString, (int)-1) > 0;
            }

            public boolean canClose(String inputString) {
                return true;
            }
        });
        int newValue = StringUtil.parseInt((String)result, (int)initialValue);
        if (initialValue == newValue) {
            return;
        }
        OCCodeInsightUtil.setMaxFileLength(newValue);
        if (document != null) {
            FileWideHighlighterFactory.clearHighlightings((Project)project, (Document)document);
        }
        if ((activity = OCSymbolTablesBuildingActivity.getInstance(project)) != null) {
            activity.rebuildSymbols(OCSymbolTablesBuildingMode.FULL);
        }
    }

    @Nullable
    private static String findTooLongInlineHeader(@NotNull ASTNode node) {
        if (node == null) {
            OCCodeInsightUnavailabilityHighlighterImpl.$$$reportNull$$$0(4);
        }
        for (ASTNode child : node.getChildren(null)) {
            if (child.getElementType() == OCLexerTokenTypes.HEADER_TOO_LONG_INLINED_PATH_LITERAL) {
                return child.getText();
            }
            String header = OCCodeInsightUnavailabilityHighlighterImpl.findTooLongInlineHeader(child);
            if (header == null) continue;
            return header;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/lang/daemon/OCCodeInsightUnavailabilityHighlighterImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "check";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "adjustMaxFileSize";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "findTooLongInlineHeader";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class ChangeMaximumFileLengthAction
    extends UserDataHolderBase
    implements IntentionAction {
        @NotNull
        @NlsSafe
        private final String myLanguageName;

        private ChangeMaximumFileLengthAction(@NotNull @NlsSafe String languageName) {
            if (languageName == null) {
                ChangeMaximumFileLengthAction.$$$reportNull$$$0(0);
            }
            this.myLanguageName = languageName;
            this.putUserData(IntentionManager.SHOW_INTENTION_OPTIONS_KEY, Boolean.FALSE);
        }

        @NotNull
        public String getText() {
            String string = OCBundle.message("highlighter.change.file.length.limit", new Object[0]);
            if (string == null) {
                ChangeMaximumFileLengthAction.$$$reportNull$$$0(1);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = this.myLanguageName;
            if (string == null) {
                ChangeMaximumFileLengthAction.$$$reportNull$$$0(2);
            }
            return string;
        }

        public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile psiFile) {
            if (project == null) {
                ChangeMaximumFileLengthAction.$$$reportNull$$$0(3);
            }
            return true;
        }

        public void invoke(@NotNull Project project, Editor editor, PsiFile psiFile) throws IncorrectOperationException {
            if (project == null) {
                ChangeMaximumFileLengthAction.$$$reportNull$$$0(4);
            }
            OCCodeInsightUnavailabilityHighlighterImpl.adjustMaxFileSize(project, editor != null ? editor.getDocument() : null, this.myLanguageName);
        }

        public boolean startInWriteAction() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "languageName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/lang/daemon/OCCodeInsightUnavailabilityHighlighterImpl$ChangeMaximumFileLengthAction";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/lang/daemon/OCCodeInsightUnavailabilityHighlighterImpl$ChangeMaximumFileLengthAction";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "isAvailable";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2 -> new IllegalStateException(string);
            };
        }
    }
}

